/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.log;

import io.airbridge.AirBridge;
import io.airbridge.internal.log.LogEntry;
import io.airbridge.internal.networking.ABRequest;
import io.airbridge.internal.networking.ABResponse;
import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.DeviceInfo;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

class CrashReporter {
    private List<LogEntry> logs = new ArrayList<LogEntry>();

    CrashReporter() {
    }

    public void record(LogEntry log) {
        this.logs.add(log);
    }

    public void reportToServer() {
        JSONArray logEntries = new JSONArray();
        for (LogEntry log : this.logs) {
            logEntries.put((Object)log.toJson());
        }
        DeviceInfo device = DeviceInfo.getInstance();
        Param payload = new Param().put("logs", logEntries).put("logTimestamp", System.currentTimeMillis()).put("sdkVersion", "M_A_1.0.0-beta2").put("device", device.serialize()).put("app", new Param().put("version", device.appVersion).put("versionCode", device.appVersionCode).put("packageName", device.packageName));
        String url = "/api/v2/apps/" + AirBridge.appId + "/logs/mobile-app";
        ABRequest request = new ABRequest("POST", url);
        request.setParameter(payload);
        request.callAsync(new ABRequest.Callback(){

            @Override
            public void done(ABRequest request, ABResponse response) {
            }
        });
    }
}

