/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import io.airbridge.installation.Installer;
import io.airbridge.internal.log.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Set;

public class DeferredLinkReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        try {
            String referrer = intent.getExtras().getString("referrer");
            if (referrer == null) {
                Logger.d("Got a deferred deep link but no referrer.", new Object[0]);
                return;
            }
            if (!(referrer = URLDecoder.decode(referrer, "UTF-8")).contains("udl") && !referrer.contains("airbridge=true")) {
                Logger.e("Referrer doesn't have AirBridge token: " + referrer);
            }
            Installer.referrerFuture.complete(referrer);
        }
        catch (Exception e) {
            Logger.e("Failed to parse deferred deep link from Play Store.", e);
        }
        this.call3rdPartyReceiver(context, intent);
    }

    public void call3rdPartyReceiver(Context context, Intent intent) {
        try {
            Object myApiKey = null;
            try {
                ComponentName cn = new ComponentName(context, DeferredLinkReceiver.class);
                ActivityInfo info = context.getPackageManager().getReceiverInfo(cn, 128);
                Bundle bundle = info.metaData;
                if (bundle == null) {
                    return;
                }
                Set keySet = bundle.keySet();
                for (String key : keySet) {
                    String value = bundle.getString(key);
                    Class<?> adidClass = Class.forName(value);
                    Constructor<?>[] constructors = adidClass.getDeclaredConstructors();
                    Constructor<?> constructor = null;
                    for (int i = 0; i < constructors.length && (constructor = constructors[i]).getGenericParameterTypes().length != 0; ++i) {
                    }
                    constructor.setAccessible(true);
                    Object clazz = constructor.newInstance(new Object[0]);
                    Method getAdvertisingIdInfoMethod = adidClass.getMethod("onReceive", Context.class, Intent.class);
                    getAdvertisingIdInfoMethod.invoke(clazz, context, intent);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.d((String)"AirBridge", (String)("Failed to load meta-data, NameNotFound: " + e.getMessage()));
            }
            catch (NullPointerException e) {
                Log.d((String)"AirBridge", (String)("Failed to load meta-data, NullPointer: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

