/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.log;

import android.content.Context;
import android.os.Build;
import io.airbridge.internal.log.LogEntry;
import io.airbridge.internal.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class BlackBox {
    private File blackBoxFile;
    private List<LogEntry> logs = new ArrayList<LogEntry>();

    public BlackBox(Context context) {
        File blackBoxDir = Build.VERSION.SDK_INT >= 21 ? context.getNoBackupFilesDir() : context.getFilesDir();
        this.blackBoxFile = new File(blackBoxDir, "ab_session");
        this.load();
    }

    public void load() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.blackBoxFile));
            while ((line = br.readLine()) != null) {
                this.logs.add(LogEntry.fromJson(new JSONObject(line)));
            }
        }
        catch (Exception e) {
            Logger.e("Error occurred while loading BlackBox", e);
        }
    }

    public void save() {
    }

    public boolean hasBlackbox() {
        return this.logs.size() > 0;
    }
}

