package io.airbridge.statistics.events;

import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.Tracker;

/**
 * @author Hyojun Kim
 */
public class InstallEvent extends Event {

    private static final int EVENT_CATEGORY = 9161;

    private String referrer;

    public InstallEvent(String referrer) {
        this.referrer = referrer;
    }

    @Override
    public Param getEventData(Tracker tracker) {
        Param data = new Param();
        if (referrer != null) data.put("googleReferrer", referrer);
        return data;
    }

    @Override
    public int getCategory() {
        return EVENT_CATEGORY;
    }

    @Override
    public boolean isImportant() {
        return true;
    }
}
