package io.airbridge.statistics.events;

import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.Tracker;

/**
 * @author Hyojun Kim
 */
public class GoalEvent extends Event {

    private static final int EVENT_CATEGORY = 9360;

    private String category, action, label = "";
    private int value = 0;
    private Param customAttributes = new Param();

    public GoalEvent(String category) {
        this(category, "");
    }

    public GoalEvent(String category, String action) {
        this.category = category;
        this.action = action;
    }

    @Override
    public Param getEventData(Tracker tracker) {
        Param goalParam = new Param()
                .put("category", category)
                .put("action", action)
                .put("label", label)
                .put("value", value)
                .put("customAttributes", customAttributes);

        return new Param().put("goal", goalParam);
    }

    public GoalEvent setLabel(String label) {
        this.label = label;
        return this;
    }

    public GoalEvent setCategory(String category) {
        this.category = category;
        return this;
    }

    public GoalEvent setAction(String action) {
        this.action = action;
        return this;
    }

    public GoalEvent setValue(int value) {
        this.value = value;
        return this;
    }

    public GoalEvent setCustomAttribute(String key, Object value) {
        customAttributes.put(key, value);
        return this;
    }

    @Override
    public int getCategory() {
        return EVENT_CATEGORY;
    }
}
