package io.airbridge.internal.log;

import org.json.JSONArray;

import java.util.ArrayList;
import java.util.List;

import io.airbridge.AirBridge;
import io.airbridge.Constants;
import io.airbridge.internal.networking.ABRequest;
import io.airbridge.internal.networking.ABResponse;
import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.DeviceInfo;

/**
 * Sends all log to the server when critical error occurred.
 * @author Hyojun Kim
 */
class CrashReporter {

    private List<LogEntry> logs = new ArrayList<>();

    public void record(LogEntry log) {
        logs.add(log);
    }

    public void reportToServer() {
        JSONArray logEntries = new JSONArray();
        for (LogEntry log : logs) {
            logEntries.put(log.toJson());
        }

        // make a request
        DeviceInfo device = DeviceInfo.getInstance();
        Param payload = new Param()
                .put("logs", logEntries)
                .put("logTimestamp", System.currentTimeMillis())
                .put("sdkVersion", "M_A_" + Constants.VERSION)
                .put("device", device.serialize())
                .put("app", new Param()
                        .put("version", device.appVersion)
                        .put("versionCode", device.appVersionCode)
                        .put("packageName", device.packageName));

        String url = Constants.STATS_ENDPOINT + AirBridge.appId + "/logs/mobile-app";
        ABRequest request = new ABRequest("POST", url);
        request.setParameter(payload);
        request.callAsync(new ABRequest.Callback() {
            @Override
            public void done(ABRequest request, ABResponse response) {
                // TODO: 네트워크 연결 불가 상황에선 어떻게 대처해야할까? RequestQueue 이용 고민 필요.
                // fire and forget.
            }
        });
    }
}
