package io.airbridge.deeplink;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import io.airbridge.Link;

/**
 * Airbridge에서의 딥 링크 사용을 도와주는 클래스이다.
 * @author Hyojun Kim
 */
public class DeepLink extends Link {

    static Router router;

    /**
     * 딥 링크 라우터를 반환한다.
     * @return {@link Router}
     */
    public static Router getRouter() {
        if (router == null) router = new Router();
        return router;
    }

    public static void init(Context context) {
        AnnotationScanner.scanAndRegister(context, getRouter());
    }

    /**
     * 주어진 {@link Activity}가 Airbridge 딥 링크로 실행되었는지 여부를 확인한다.
     * @param activity 액티비티
     * @return 해당 액티비티가 딥 링크로 실행되었는지 여부
     */
    public static boolean hadOpened(Activity activity) {
        return activity.getIntent() != null && Intent.ACTION_VIEW.equals(activity.getIntent().getAction());
    }

    /**
     * 주어진 {@link Activity}를 실행시킨 딥 링크의 파라미터를 가져온다.
     * @param activity 액티비티
     * @return {@link DeepLink} 객체. 딥 링크로 열린게 아닐 시엔 {@code null}을 반환.
     */
    public static DeepLink fromActivity(Activity activity) {
        if (!DeepLink.hadOpened(activity)) return null;
        return new DeepLink(activity.getIntent().getData().toString());
    }

    public DeepLink(String uriString) {
        super(uriString);
    }

    /**
     * An handler interface that handles deep link.
     */
    public interface Handler {
        void onLink(Context context, DeepLink deepLink);
    }

    /**
     * An filter interface that filters deep link.
     */
    public interface Filter {
        boolean filter(Context context, DeepLink deepLink);
    }

}
