/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.database.Cursor;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.Param;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public class DeviceInfo {
    private static final String PREF_UNIQUE_ID = "PREF_UNIQUE_ID";
    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final Uri ATTRIBUTION_ID_CONTENT_URI = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
    private static DeviceInfo instance;
    private Context context;
    String facebookAttributionId;
    public Boolean isLAT = false;
    public String gaid;
    public String uuid;
    public String packageName;
    public String appVersion;
    public String appVersionCode;
    public int screenWidth;
    public int screenHeight;
    public int screenDensity;
    public String locale;
    public String timezone;

    public DeviceInfo(Context context) {
        this.context = context;
    }

    public static DeviceInfo getInstance() {
        if (instance == null) {
            throw new IllegalStateException("You must call DeviceInfo.fetch before you use it.");
        }
        return instance;
    }

    public static void fetch(Context context) {
        instance = new DeviceInfo(context);
        instance.fetchGaid(context);
        instance.fetchAttributionId(context);
        instance.fetchScreenSize(context);
        DeviceInfo.instance.locale = Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
        DeviceInfo.instance.timezone = TimeZone.getDefault().getID();
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            DeviceInfo.instance.appVersion = info.versionName;
            DeviceInfo.instance.appVersionCode = String.valueOf(info.versionCode);
            DeviceInfo.instance.packageName = info.packageName;
        }
        catch (Exception e) {
            DeviceInfo.instance.appVersion = "(N/A)";
            DeviceInfo.instance.appVersionCode = "(N/A)";
            DeviceInfo.instance.packageName = context.getPackageName();
        }
        if (DeviceInfo.instance.gaid != null) {
            DeviceInfo.instance.uuid = DeviceInfo.instance.gaid;
        } else {
            try {
                Logger.d("Using UUID instead...", new Object[0]);
                DeviceInfo.instance.uuid = DeviceInfo.generateTelephonyUuid(context);
            }
            catch (Exception ex) {
                Logger.d("Using random UUID instead...", new Object[0]);
                DeviceInfo.instance.uuid = DeviceInfo.generateRandomUuid(context);
            }
        }
    }

    private void fetchGaid(Context context) {
        try {
            Class<?> adidClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            Method getAdvertisingIdInfoMethod = adidClass.getMethod("getAdvertisingIdInfo", Context.class);
            Object adidInfoObject = getAdvertisingIdInfoMethod.invoke(null, context);
            Method isLimitAdTrackingEnabledMethod = adidInfoObject.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
            Method getAdIdMethod = adidInfoObject.getClass().getMethod("getId", new Class[0]);
            this.gaid = getAdIdMethod.invoke(adidInfoObject, new Object[0]).toString();
            this.isLAT = (Boolean)isLimitAdTrackingEnabledMethod.invoke(adidInfoObject, new Object[0]) == false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodError ignored) {
            Logger.e("Google Play Services SDK not found. We recommend to add Google Play Service to your project.");
        }
        catch (NullPointerException ignored) {
            Log.w((String)"AirBridge", (String)"GAID fetching failed. Trying to use custom UUID...");
        }
        catch (Exception e) {
            Logger.e("Error occurred while fetching GAID", e);
        }
        Logger.v("GAID Set.", new Object[0]);
    }

    private void fetchAttributionId(Context context) {
        try {
            String[] projection = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
            ContentResolver contentResolver = context.getContentResolver();
            Cursor c = contentResolver.query(ATTRIBUTION_ID_CONTENT_URI, projection, null, null, null);
            if (c == null || !c.moveToFirst()) {
                return;
            }
            this.facebookAttributionId = c.getString(c.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
            if (this.facebookAttributionId == null) {
                this.facebookAttributionId = "";
            }
            c.close();
        }
        catch (Throwable e) {
            Logger.d("Unable to retrieve Facebook Attribution ID.", new Object[0]);
        }
    }

    private void fetchScreenSize(Context context) {
        WindowManager w = (WindowManager)context.getSystemService("window");
        Display d = w.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        this.screenDensity = metrics.densityDpi;
        if (Build.VERSION.SDK_INT >= 17) {
            Point realSize = new Point();
            d.getRealSize(realSize);
            this.screenWidth = realSize.x;
            this.screenHeight = realSize.y;
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                this.screenWidth = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)d, new Object[0]);
                this.screenHeight = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)d, new Object[0]);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.screenWidth = metrics.widthPixels;
        this.screenHeight = metrics.heightPixels;
    }

    public Param serialize() {
        Param deviceData = new Param().put("deviceModel", Build.MODEL).put("manufacturer", Build.MANUFACTURER).put("osName", "Android").put("osVersion", Build.VERSION.RELEASE).put("locale", this.locale).put("timezone", this.timezone).put("deviceIP", this.getIPAddress()).put("deviceUUID", this.uuid).put("gaid", this.gaid).put("limitAdTracking", this.isLAT).put("facebookAttributionID", this.facebookAttributionId);
        Param screenData = new Param().put("width", this.screenWidth).put("height", this.screenHeight).put("density", this.screenDensity);
        deviceData.put("screen", screenData);
        deviceData.put("network", this.getNetworkInfo());
        return deviceData;
    }

    String getIPAddress() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String sAddr;
                    boolean isIPv4;
                    if (addr.isLoopbackAddress() || !(isIPv4 = (sAddr = addr.getHostAddress()).indexOf(58) < 0)) continue;
                    return sAddr;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    Param getNetworkInfo() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        boolean wifiOn = false;
        boolean bluetoothOn = false;
        boolean cellularOn = false;
        String carrier = null;
        try {
            NetworkInfo activeInfo = connectivityManager.getActiveNetworkInfo();
            if (activeInfo != null) {
                if (activeInfo.getType() == 1) {
                    wifiOn = true;
                } else if (activeInfo.getType() == 7) {
                    bluetoothOn = true;
                } else {
                    cellularOn = true;
                }
            }
            if (!bluetoothOn && this.hasPermission("android.permission.BLUETOOTH")) {
                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                bluetoothOn = bluetoothAdapter.isEnabled();
            }
            if (this.hasPermission("android.permission.READ_PHONE_STATE")) {
                TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
                carrier = telephonyManager.getNetworkOperatorName();
            }
        }
        catch (Exception e) {
            Logger.e("Failed to fetch network info", e);
        }
        ((TelephonyManager)this.context.getSystemService("phone")).getNetworkOperatorName();
        return new Param().put("wifi", wifiOn).put("bluetooth", bluetoothOn).put("cellular", cellularOn).put("carrier", carrier);
    }

    private boolean hasPermission(String permission2) {
        return Build.VERSION.SDK_INT >= 23 && this.context.checkSelfPermission(permission2) == 0 || this.context.getPackageManager().checkPermission(permission2, this.context.getPackageName()) == 0;
    }

    private static String generateRandomUuid(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREF_UNIQUE_ID, 0);
        String uniqueID = prefs.getString(PREF_UNIQUE_ID, null);
        if (uniqueID == null) {
            uniqueID = UUID.randomUUID().toString();
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(PREF_UNIQUE_ID, uniqueID);
            editor.apply();
        }
        return uniqueID;
    }

    private static String generateTelephonyUuid(Context context) throws Exception {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String tmDevice = "" + tm.getDeviceId();
        String tmSerial = "" + tm.getSimSerialNumber();
        String androidId = "" + Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        UUID deviceUuid = new UUID(androidId.hashCode(), (long)tmDevice.hashCode() << 32 | (long)tmSerial.hashCode());
        return deviceUuid.toString();
    }
}

