/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.SystemClock;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;

public class Session {
    private static final int SAVE_DELAY_IN_MS = 3000;
    private static final String KEY_INSTALLED = "installed";
    static Session instance;
    static boolean disableOffline;
    private Properties props;
    private File preferenceFile;
    private volatile boolean saveStarted;

    static void init(Context context) {
        instance = new Session(context);
    }

    public static Session getCurrent() {
        if (instance == null) {
            throw new IllegalStateException("You must initialize AirBridge SDK first.");
        }
        return instance;
    }

    @TargetApi(value=21)
    private Session(Context context) {
        File preferenceDir = Build.VERSION.SDK_INT >= 21 ? context.getNoBackupFilesDir() : context.getFilesDir();
        this.preferenceFile = new File(preferenceDir, "ab_session");
        this.props = new Properties();
        this.load(context);
    }

    public void load(Context context) {
        String initialTransactionId;
        boolean hasInitialTransaction;
        if (this.preferenceFile.exists() && !disableOffline) {
            try {
                this.props.load(new FileInputStream(this.preferenceFile));
            }
            catch (Exception e) {
                Logger.e("Failed to load existing session.", e);
            }
        } else {
            SharedPreferences prefs = context.getSharedPreferences("ab_session", 32768);
            if (prefs.contains("initialTransactionId")) {
                Logger.d("Old session file found. Migrating...", new Object[0]);
                Map prefData = prefs.getAll();
                for (String key : prefData.keySet()) {
                    this.put(key, prefData.get(key));
                }
                prefs.edit().clear().apply();
            }
        }
        boolean bl = hasInitialTransaction = (initialTransactionId = this.getString("initialTransactionId", null)) != null && !"".equals(initialTransactionId);
        if (this.isFirstTime() && hasInitialTransaction) {
            Logger.d("Initial transaction migration.", new Object[0]);
            this.put(KEY_INSTALLED, true);
        }
    }

    public void put(String key, Object value) {
        if (value == null || value.equals(this.props.get(key))) {
            return;
        }
        this.props.put(key, value.toString());
        this.save();
    }

    public synchronized void save() {
        if (this.saveStarted || disableOffline) {
            return;
        }
        this.saveStarted = true;
        AirBridgeExecutor.run(new Runnable(){

            @Override
            public void run() {
                try {
                    SystemClock.sleep((long)3000L);
                    Session.this.saveStarted = false;
                    Logger.d("Saving session data...", new Object[0]);
                    Session.this.props.store(new FileOutputStream(Session.this.preferenceFile), null);
                }
                catch (Exception e) {
                    Logger.e("Failed to save preferences.", e);
                }
            }
        });
    }

    public void setInstalled() {
        this.put(KEY_INSTALLED, true);
    }

    public boolean hasActiveSession() {
        return !this.isFirstTime();
    }

    public boolean isFirstTime() {
        return !this.getBoolean(KEY_INSTALLED, false);
    }

    public void delete() {
        this.props.clear();
        try {
            this.preferenceFile.delete();
        }
        catch (Exception e) {
            Logger.e("Failed to remove session data", e);
        }
        this.put(KEY_INSTALLED, false);
    }

    public String getString(String key, String defaults) {
        return this.props.getProperty(key, defaults);
    }

    public int getInt(String key, int defaults) {
        return Integer.valueOf(this.props.getProperty(key, String.valueOf(defaults)));
    }

    public long getLong(String key, long defaults) {
        return Long.valueOf(this.props.getProperty(key, String.valueOf(defaults)));
    }

    public boolean getBoolean(String key, boolean defaults) {
        return Boolean.valueOf(this.props.getProperty(key, String.valueOf(defaults)));
    }

    static {
        disableOffline = false;
    }
}

