/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.page;

import android.app.Activity;
import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.page.Page;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

class PageInfo {
    public String name;
    public String componentName;
    public Param customInfo = new Param();
    public WeakReference<Activity> activity;

    public PageInfo(Activity activity) {
        this.name = this.getPageName(activity);
        this.componentName = activity.getClass().getName();
        this.activity = new WeakReference<Activity>(activity);
    }

    private String getPageName(Activity activity) {
        Page pageAnnotation = activity.getClass().getAnnotation(Page.class);
        if (pageAnnotation != null) {
            return pageAnnotation.value();
        }
        return activity.getTitle().toString();
    }

    public JSONObject toJson() {
        return new Param().put("name", this.name).put("packageName", this.componentName).put("customInfo", this.customInfo).toJson();
    }
}

