/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.events;

import io.airbridge.Session;
import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.StateContainer;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.Event;

public class DeepLinkLaunchEvent
extends Event {
    private static final int LAUNCH_EVENT_CATEGORY = 9162;
    private static final int FIRST_LAUNCH_EVENT_CATEGORY = 9163;
    private String deeplinkUri;

    public DeepLinkLaunchEvent(String deeplinkUri) {
        this.deeplinkUri = deeplinkUri;
    }

    @Override
    public void onBeforeSendingEvent() {
        super.onBeforeSendingEvent();
        StateContainer.set(StateContainer.State.DEEP_LINK_CLICKED);
        if (Session.getCurrent().isFirstTime()) {
            StateContainer.set(StateContainer.State.INSTALL_WITH_DEEP_LINK);
        }
    }

    @Override
    public Param getEventData(Tracker tracker) {
        return new Param().put("deeplink", this.deeplinkUri);
    }

    @Override
    public int getCategory() {
        return StateContainer.get() == StateContainer.State.INSTALL_WITH_DEEP_LINK ? 9163 : 9162;
    }
}

