package io.airbridge.statistics.page;

import android.app.Activity;

import org.json.JSONObject;

import java.lang.ref.WeakReference;

import io.airbridge.internal.networking.Param;

/**
 * 페이지 정보를 저장한다.
 * @author Hyojun Kim
 */
class PageInfo {

    /**
     * 페이지 이름 - 직접 입력받거나, {@link Page} 어노테이션으로 가져오거나, 타이틀을 통해 유추함.
     */
    public String name;

    /**
     * 액티비티의 컴포넌트 이름.
     * @see {@link Activity#getComponentName()}
     */
    public String componentName;

    /**
     * 개발자에게 입력받는 커스텀 정보
     */
    public Param customInfo = new Param();

    /**
     * 액티비티. 메모리 누수 방지를 위해 Weak하게 관리
     */
    public WeakReference<Activity> activity;

    public PageInfo(Activity activity) {
        this.name = getPageName(activity);
        this.componentName = activity.getClass().getName();
        this.activity = new WeakReference<>(activity);
    }

    private String getPageName(Activity activity) {
        // @Page 어노테이션에서 가져오려고 시도
        Page pageAnnotation = activity.getClass().getAnnotation(Page.class);
        if (pageAnnotation != null) return pageAnnotation.value();

        // 없으면 타이틀 채움
        return activity.getTitle().toString();
    }

    public JSONObject toJson() {
        return new Param()
                .put("name", name)
                .put("packageName", componentName)
                .put("customInfo", customInfo)
                .toJson();
    }
}
