package io.airbridge.statistics;

import java.util.HashMap;
import java.util.Map;

import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.CompletableFuture;

import static io.airbridge.statistics.StateContainer.State.APP_STARTED;

/**
 * 현재 앱의 상태를 저장한다.
 */
public class StateContainer {
    public enum State {
        APP_STARTED,
        DEVICE_INFO_FETCHED,
        INSTALL_WITH_DEEP_LINK,
        DEEP_LINK_CLICKED,
        INIT_FINISHED
    }

    private static volatile State currentState = APP_STARTED;
    private static volatile Map<State, CompletableFuture<Boolean>> awaiters = new HashMap<>();

    public static State get() {
        return currentState;
    }

    public static void set(State state) {
        Logger.d("Process change : " + currentState + " -> " + state);
        currentState = state;

        // notify to subscribers
        if (awaiters.containsKey(state)) {
            awaiters.get(state).complete(true);
        }
    }

    public static void waitFor(State state, long timeout) {
        if (currentState == state) return;

        CompletableFuture<Boolean> future = awaiters.get(state);
        if (future == null || future.isDone()) {
            future = new CompletableFuture<>();
            awaiters.put(state, future);
        }

        future.await(timeout);
    }

    public static void reset() {
        currentState = APP_STARTED;
        awaiters = new HashMap<>();
    }
}
