
package io.airbridge.internal.log;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.PrintWriter;
import java.io.StringWriter;

import io.airbridge.internal.networking.Param;

class LogEntry {

    private long at;
    private String level;
    private String message;
    private String stackTrace;

    public static LogEntry fromJson(JSONObject json) {
        try {
            LogEntry entry = new LogEntry(json.getString("level"), json.getString("message"));
            entry.at = json.getLong("at");
            if (json.has("stackTrace")) {
                entry.stackTrace = json.getString("stackTrace");
            }
            return entry;

        } catch (JSONException e) {
            e.printStackTrace();
        }

        // because the Logger is very acute part, DO NOT throw exceptions like InvalidArgument.
        return new LogEntry("INVALID", "INVALID");
    }

    public LogEntry(String level, String message) {
        this.at = System.currentTimeMillis();
        this.level = level;
        this.message = message;
    }

    public LogEntry setErrorInfo(Throwable error) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        error.printStackTrace(printer);

        this.stackTrace = stringWriter.toString();
        return this;
    }

    public JSONObject toJson() {
        Param data = new Param()
                .put("at", at)
                .put("level", level)
                .put("message", message);

        if (stackTrace != null) data.put("stacktrace", stackTrace);
        return data.toJson();
    }
}
