package io.airbridge.integration;

import android.content.Context;

import io.airbridge.statistics.Attribution;

/**
 * 3rd-party와의 연동을 담당한다.
 * @author Hyojun Kim
 */
public interface Integrator {

    /**
     * AirBridge에서 처음 앱 설치시, Install 정보를 서버로 보내기 직전에 호출된다.
     * @param context Application Context
     */
    void onInstall(Context context);

    /**
     * Attribution 정보를 서버로 보낸다.
     * @param context App context
     * @param attribution {@link Attribution}
     */
    void sendAttribution(Context context, Attribution attribution);
}
