package io.airbridge.integration;

import android.content.Context;

import java.util.ArrayList;
import java.util.List;

import io.airbridge.AirBridge;
import io.airbridge.statistics.Attribution;

/**
 * Integrator를 관리한다.
 */
public class IntegrationManager {
    static List<Integrator> integrators = new ArrayList<>();

    /**
     * 연동 목록에 새로운 서비스를 추가한다.
     * @param integrator {@link Integrator}
     */
    public static void registerIntegration(Integrator integrator) {
        integrators.add(integrator);
    }

    /**
     * 클래스를 통해 등록된 Integrator를 가져온다.
     * @param integratorClass Integrator 인터페이스를 구현한 클래스 객체
     * @return Integrator 객체. 없을 시 null
     */
    public static Integrator getIntegratorByClass(Class<? extends Integrator> integratorClass) {
        for (Integrator integrator : integrators) {
            if (integrator.getClass().equals(integratorClass))
                return integrator;
        }
        return null;
    }

    /**
     * 앱 처음 설치 콜백을 호출한다.
     */
    public static void notifyInstalled(Context context) {
        for (Integrator integrator : integrators)
            integrator.onInstall(context);
    }

    /**
     * 연동된 모든 서비스에 Attribution 정보를 전송한다.
     * @param attrib 정보
     */
    public static void sendAttribution(Attribution attrib, Context context) {
        for (Integrator integrator : integrators)
            integrator.sendAttribution(context, attrib);
    }

    /**
     * 모든 서드파티 연동을 등록 해제한다.
     */
    public static void unregisterAll() {
        integrators.clear();
    }
}
