package io.airbridge.installation;

import android.content.Context;

import io.airbridge.Link;
import io.airbridge.internal.log.Logger;

/**
 * Simplelink 핸들링을 담당하는 클래스이다.
 * @author Hyojun Kim
 */
public class SimpleLink extends Link {

    private static SimpleLinkHandler simpleLinkHandler;

    public SimpleLink(String uriString) {
        super(uriString);
    }

    /**
     * 심플링크 핸들러를 설정한다. 앱이 설치된 직후 호출된다.
     * @param handler {@link SimpleLinkHandler}
     */
    public static void setHandler(SimpleLinkHandler handler) {
        simpleLinkHandler = handler;
    }

    /**
     * 심플링크 핸들러를 호출한다.
     * @param link 심플링크
     * @param context Application Context
     */
    static void callHandler(SimpleLink link, Context context) {
        Logger.d("Incoming SimpleLink : " + link.getUri());
        simpleLinkHandler.onInstall(context, link);
    }


    /**
     * @author Hyojun Kim
     */
    public interface SimpleLinkHandler {
        void onInstall(Context context, SimpleLink link);
    }
}
