package io.airbridge;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Set;

import io.airbridge.installation.Installer;
import io.airbridge.internal.log.Logger;

/**
 * Play Store 설치 URL에 referrer를 지정하면, 앱이 설치된 후 이 리시버가 호출된다
 * 지연된 딥 링크 (Deferred Deep Link) 구현에 사용된다.
 */
public class DeferredLinkReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(final Context context, Intent intent) {
        // 앱 실행시 처음 한번만 검사한다.
        try {
            String referrer = intent.getExtras().getString("referrer");
            if (referrer == null) {
                Logger.d("Got a deferred deep link but no referrer.");
                return;
            }
            referrer = URLDecoder.decode(referrer, "UTF-8");

            if (!referrer.contains("udl") && !referrer.contains("airbridge=true")) {
                Logger.e("Referrer doesn't have AirBridge token: "+referrer);
            }

            // pass referrer information to the Initialization Task
            Installer.referrerFuture.complete(referrer);

        } catch (Exception e) {
            Logger.e("Failed to parse deferred deep link from Play Store.", e);
        }

        call3rdPartyReceiver(context,intent);
    }

    public void call3rdPartyReceiver(Context context, Intent intent) {
        /* Check 3rd party Referrer */
        try {
            String myApiKey = null;
            try {
                /* Get Metadata in Receiver */
                ComponentName cn=new ComponentName(context, DeferredLinkReceiver.class);
                ActivityInfo info=context.getPackageManager()
                        .getReceiverInfo(cn, PackageManager.GET_META_DATA);

                Bundle bundle = info.metaData;
                if (bundle == null) return;

                // Get Metadata Keyset
                Set<String> keySet = bundle.keySet();

                /* Check all 3rd party Receiver orderly
                 * if one Receiver is failed, after all Receiver is failed */
                for (String key:keySet) {
//                    Logger.d("3rdParty Receiver with " + key);
                    /* Anonymous class */
                    String value = bundle.getString(key);
                    Class<?> adidClass = Class.forName(value);
                    /* Anonymous class constructor */
                    Constructor<?>[] constructors = adidClass.getDeclaredConstructors();
                    Constructor<?> constructor = null;
                    for (int i = 0; i < constructors.length; i++) {
                        constructor = constructors[i];
                        if (constructor.getGenericParameterTypes().length == 0)
                            break;
                    }
                    constructor.setAccessible(true);
                    Object clazz = constructor.newInstance();
                    /* Anonymous Method (onReceive) */
                    Method getAdvertisingIdInfoMethod = adidClass.getMethod("onReceive", Context.class, Intent.class);
                    getAdvertisingIdInfoMethod.invoke(clazz, context, intent);
                }
            } catch (PackageManager.NameNotFoundException e) {
                Log.d("AirBridge", "Failed to load meta-data, NameNotFound: " + e.getMessage());
            } catch (NullPointerException e) {
                Log.d("AirBridge", "Failed to load meta-data, NullPointer: " + e.getMessage());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}