/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.test;

import io.agroal.test.MockConnection;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface MockDriver
extends Driver {
    public static final DriverPropertyInfo[] EMPTY_PROPERTY_INFO = new DriverPropertyInfo[0];

    public static void registerMockDriver(Class<? extends Connection> connectionType) {
        try {
            DriverManager.registerDriver(new Empty(connectionType));
        }
        catch (SQLException e) {
            Logger.getLogger(MockDriver.class.getName()).log(Level.WARNING, "Unable to register MockDriver into Driver Manager", e);
        }
    }

    public static void registerMockDriver() {
        MockDriver.registerMockDriver(MockConnection.Empty.class);
    }

    public static void deregisterMockDriver() {
        try {
            DriverManager.deregisterDriver(DriverManager.getDriver(""));
        }
        catch (SQLException e) {
            Logger.getLogger(MockDriver.class.getName()).log(Level.WARNING, "Unable to deregister MockDriver from Driver Manager", e);
        }
    }

    @Override
    default public Connection connect(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    default public boolean acceptsURL(String url) throws SQLException {
        return true;
    }

    @Override
    default public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return EMPTY_PROPERTY_INFO;
    }

    @Override
    default public int getMajorVersion() {
        return 0;
    }

    @Override
    default public int getMinorVersion() {
        return 0;
    }

    @Override
    default public boolean jdbcCompliant() {
        return false;
    }

    @Override
    default public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public static class Empty
    implements MockDriver {
        Class<? extends Connection> connectionType;

        public Empty() {
            this(MockConnection.Empty.class);
        }

        public Empty(Class<? extends Connection> connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            try {
                return this.connectionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new SQLException("Cannot create mock connection", e);
            }
        }

        public String toString() {
            return "MockDriver@" + System.identityHashCode(this);
        }
    }
}

