/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.junit.platform.launcher.LauncherInterceptor;

public class IsolatingClassloaderLauncherInterceptor
implements LauncherInterceptor {
    private static final String TRANSACTION_TEST_PACKAGE_PREFIX = "io.agroal.test.narayana";
    private static final String NARAYANA_PACKAGE_PREFIX = "com.arjuna";
    private final ClassLoader parentClassloader = Thread.currentThread().getContextClassLoader();

    public <T> T intercept(LauncherInterceptor.Invocation<T> invocation) {
        Thread.currentThread().setContextClassLoader(new IsolatingClassLoader(this.parentClassloader));
        return (T)invocation.proceed();
    }

    public void close() {
        Thread.currentThread().setContextClassLoader(this.parentClassloader);
    }

    private static class IsolatingClassLoader
    extends ClassLoader {
        private static final Logger logger = Logger.getLogger(IsolatingClassLoader.class.getName());

        public IsolatingClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> existingClass;
            URL resourceURL;
            if (name.startsWith(IsolatingClassloaderLauncherInterceptor.TRANSACTION_TEST_PACKAGE_PREFIX) && !name.contains("$") && (resourceURL = this.getResource((String)((existingClass = this.findLoadedClass(name)) != null ? existingClass.getSimpleName() : name.replace(".", "/") + ".class"))) != null) {
                Class<?> clazz;
                block9: {
                    InputStream in = resourceURL.openStream();
                    try {
                        logger.info("New NarayanaRedefiningClassloader for test class " + name);
                        clazz = new NarayanaRedefiningClassloader(this.getParent()).defineClass(name, in.readAllBytes());
                        if (in == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    in.close();
                }
                return clazz;
            }
            return super.loadClass(name, resolve);
        }
    }

    private static class NarayanaRedefiningClassloader
    extends ClassLoader {
        public NarayanaRedefiningClassloader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> existingClass;
            URL resourceURL;
            if ((name.startsWith(IsolatingClassloaderLauncherInterceptor.TRANSACTION_TEST_PACKAGE_PREFIX) || name.startsWith(IsolatingClassloaderLauncherInterceptor.NARAYANA_PACKAGE_PREFIX)) && (resourceURL = this.getResource((String)((existingClass = this.findLoadedClass(name)) != null ? existingClass.getSimpleName() : name.replace(".", "/") + ".class"))) != null) {
                try (InputStream in = resourceURL.openStream();){
                    this.defineClass(name, in.readAllBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.loadClass(name, resolve);
        }

        public Class<?> defineClass(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

