/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot.metrics;

import io.agroal.api.AgroalDataSource;
import io.agroal.pool.DefaultMetricsRepository;
import io.agroal.springframework.boot.AgroalDataSourceAutoConfiguration;
import io.agroal.springframework.boot.metrics.AgroalDataSourcePoolMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={AgroalDataSourceAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={AgroalDataSource.class, MeterRegistry.class})
@ConditionalOnBean(value={AgroalDataSource.class, MeterRegistry.class})
public class AgroalDataSourcePoolMetricsAutoConfiguration {
    @Bean
    AgroalDataSourceMeterBinder agroalDataSourceMeterBinder(Map<String, ? extends DataSource> dataSources) {
        return new AgroalDataSourceMeterBinder(dataSources);
    }

    public static class AgroalDataSourceMeterBinder
    implements MeterBinder {
        private final Map<String, ? extends DataSource> dataSources;

        AgroalDataSourceMeterBinder(Map<String, ? extends DataSource> dataSources) {
            this.dataSources = dataSources;
        }

        public void bindTo(MeterRegistry registry) {
            this.dataSources.forEach((name, dataSource) -> this.bindDataSourceToRegistry((String)name, (DataSource)dataSource, registry));
        }

        private void bindDataSourceToRegistry(String name, DataSource dataSource, MeterRegistry registry) {
            AgroalDataSource agroalDataSource = (AgroalDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, AgroalDataSource.class);
            if (agroalDataSource != null && agroalDataSource.getMetrics() instanceof DefaultMetricsRepository) {
                new AgroalDataSourcePoolMetrics(name, agroalDataSource).bindTo(registry);
            }
        }
    }
}

