/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot;

import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.NarayanaTransactionIntegration;
import io.agroal.springframework.boot.AgroalDataSource;
import io.agroal.springframework.boot.AgroalJdbcConnectionDetailsBeanPostProcessor;
import io.agroal.springframework.boot.jndi.AgroalDataSourceJndiBinder;
import io.agroal.springframework.boot.jndi.DefaultAgroalDataSourceJndiBinder;
import io.agroal.springframework.boot.metrics.AgroalPoolDataSourceMetadataProviderConfiguration;
import javax.sql.DataSource;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={DataSourceAutoConfiguration.class})
@ConditionalOnClass(value={AgroalDataSource.class})
@ConditionalOnMissingBean(value={DataSource.class})
@ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="io.agroal.springframework.boot.AgroalDataSource", matchIfMissing=true)
@EnableConfigurationProperties(value={DataSourceProperties.class})
@Import(value={AgroalPoolDataSourceMetadataProviderConfiguration.class})
public class AgroalDataSourceAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(AgroalDataSourceAutoConfiguration.class);
    private final JtaTransactionManager jtaPlatform;
    private final XAResourceRecoveryRegistry recoveryRegistry;

    public AgroalDataSourceAutoConfiguration(@Autowired(required=false) JtaTransactionManager jtaPlatform, @Autowired(required=false) XAResourceRecoveryRegistry recoveryRegistry) {
        this.jtaPlatform = jtaPlatform;
        this.recoveryRegistry = recoveryRegistry;
    }

    @Bean
    static AgroalJdbcConnectionDetailsBeanPostProcessor agroalJdbcConnectionDetailsBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider, ObjectProvider<JtaTransactionManager> jtaPlatformProvider) {
        return new AgroalJdbcConnectionDetailsBeanPostProcessor(connectionDetailsProvider, jtaPlatformProvider);
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.agroal")
    public AgroalDataSource dataSource(DataSourceProperties properties, @Value(value="${spring.datasource.agroal.connectable:false}") boolean connectable, @Value(value="${spring.datasource.agroal.firstResource:false}") boolean firstResource, ObjectProvider<AgroalDataSourceJndiBinder> jndiBinder) {
        Object jndiName;
        AgroalDataSource dataSource = (AgroalDataSource)((Object)properties.initializeDataSourceBuilder().type(AgroalDataSource.class).build());
        if (!StringUtils.hasLength((String)properties.getDriverClassName())) {
            if (connectable) {
                dataSource.setDriverClassName(DatabaseDriver.fromJdbcUrl((String)properties.determineUrl()).getDriverClassName());
            } else if (StringUtils.hasLength((String)properties.getXa().getDataSourceClassName())) {
                dataSource.setDriverClassName(properties.getXa().getDataSourceClassName());
            } else {
                dataSource.setDriverClassName(DatabaseDriver.fromJdbcUrl((String)properties.determineUrl()).getXaDataSourceClassName());
            }
        }
        String name = properties.determineDatabaseName();
        dataSource.setName(name);
        Object object = jndiName = properties.getJndiName() != null ? properties.getJndiName() : "java:comp/env/jdbc/" + name;
        if (this.jtaPlatform != null && this.jtaPlatform.getTransactionManager() != null && this.jtaPlatform.getTransactionSynchronizationRegistry() != null) {
            dataSource.setJtaTransactionIntegration((TransactionIntegration)new NarayanaTransactionIntegration(this.jtaPlatform.getTransactionManager(), this.jtaPlatform.getTransactionSynchronizationRegistry(), (String)jndiName, connectable, firstResource, connectable ? null : this.recoveryRegistry));
            if (connectable && ((AgroalDataSourceJndiBinder)jndiBinder.getIfUnique(DefaultAgroalDataSourceJndiBinder::new)).bindToJndi((String)jndiName, dataSource)) {
                this.logger.info("Bind DataSource {} as {} to JNDI registry", (Object)name, jndiName);
            }
        }
        if (!connectable && !properties.getXa().getProperties().isEmpty()) {
            dataSource.setXaProperties(properties.getXa().getProperties());
        }
        return dataSource;
    }
}

