/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.pool.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ConnectionHandler {
    private static final AtomicReferenceFieldUpdater<ConnectionHandler, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(ConnectionHandler.class, State.class, "state");
    private final Connection connection;
    private ConnectionPool connectionPool;
    private volatile State state;
    private Thread holdingThread;
    private long lastAccess;

    public ConnectionHandler(Connection connection) {
        this.connection = connection;
        this.state = State.NEW;
        this.lastAccess = System.nanoTime();
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void closeConnection() throws SQLException {
        if (this.state != State.FLUSH) {
            throw new SQLException("Closing connection in incorrect state");
        }
        this.connection.close();
    }

    public void returnConnection() throws SQLException {
        this.connectionPool.returnConnection(this);
    }

    public boolean setState(State expected, State newState) {
        if (expected == State.DESTROYED) {
            throw new IllegalArgumentException("Trying to move out of state DESTROYED");
        }
        switch (newState) {
            case NEW: {
                throw new IllegalArgumentException("Trying to set invalid state NEW");
            }
            case CHECKED_IN: 
            case CHECKED_OUT: 
            case VALIDATION: 
            case FLUSH: 
            case DESTROYED: {
                return stateUpdater.compareAndSet(this, expected, newState);
            }
        }
        throw new IllegalArgumentException("Trying to set invalid state " + (Object)((Object)newState));
    }

    public void setState(State newState) {
        stateUpdater.set(this, newState);
    }

    public boolean isActive() {
        return stateUpdater.get(this) == State.CHECKED_OUT;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public Thread getHoldingThread() {
        return this.holdingThread;
    }

    public void setHoldingThread(Thread holdingThread) {
        this.holdingThread = holdingThread;
    }

    public static enum State {
        NEW,
        CHECKED_IN,
        CHECKED_OUT,
        VALIDATION,
        FLUSH,
        DESTROYED;

    }
}

