/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration;

import io.agroal.api.configuration.ClassLoaderProvider;
import io.agroal.api.configuration.InterruptProtection;
import java.security.Principal;
import java.util.Collection;
import java.util.Properties;

public interface AgroalConnectionFactoryConfiguration {
    public boolean autoCommit();

    public String jdbcUrl();

    public String initialSql();

    public Class<?> connectionProviderClass();

    @Deprecated
    public String driverClassName();

    @Deprecated
    public ClassLoaderProvider classLoaderProvider();

    public TransactionIsolation jdbcTransactionIsolation();

    @Deprecated
    public InterruptProtection interruptProtection();

    public Principal principal();

    public Collection<Object> credentials();

    public Properties jdbcProperties();

    public static enum TransactionIsolation {
        UNDEFINED,
        NONE,
        READ_UNCOMMITTED,
        READ_COMMITTED,
        REPEATABLE_READ,
        SERIALIZABLE;


        public static TransactionIsolation fromLevel(int level) {
            switch (level) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return READ_UNCOMMITTED;
                }
                case 2: {
                    return READ_COMMITTED;
                }
                case 4: {
                    return REPEATABLE_READ;
                }
                case 8: {
                    return SERIALIZABLE;
                }
            }
            return UNDEFINED;
        }

        public int level() {
            switch (this) {
                case READ_UNCOMMITTED: {
                    return 1;
                }
                case READ_COMMITTED: {
                    return 2;
                }
                case REPEATABLE_READ: {
                    return 4;
                }
                case SERIALIZABLE: {
                    return 8;
                }
                case NONE: {
                    return 0;
                }
            }
            return -1;
        }

        public boolean isDefined() {
            return this != UNDEFINED;
        }
    }
}

