/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.ClassLoaderProvider;
import io.agroal.api.configuration.InterruptProtection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AgroalConnectionFactoryConfigurationSupplier
implements Supplier<AgroalConnectionFactoryConfiguration> {
    private static final String USER_PROPERTY_NAME = "user";
    private static final String PASSWORD_PROPERTY_NAME = "password";
    private volatile boolean lock = false;
    private boolean autoCommit = false;
    private String jdbcUrl = "";
    private String initialSql = "";
    private String driverClassName = "";
    private ClassLoaderProvider classLoaderProvider = ClassLoaderProvider.systemClassloader();
    private AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolation = AgroalConnectionFactoryConfiguration.TransactionIsolation.UNDEFINED;
    @Deprecated
    private InterruptProtection interruptProtection = InterruptProtection.none();
    private Principal principal;
    private Collection<Object> credentials = new ArrayList<Object>();
    private Properties jdbcProperties = new Properties();

    public AgroalConnectionFactoryConfigurationSupplier() {
    }

    public AgroalConnectionFactoryConfigurationSupplier(AgroalConnectionFactoryConfiguration existingConfiguration) {
        this();
        if (existingConfiguration == null) {
            return;
        }
        this.autoCommit = existingConfiguration.autoCommit();
        this.jdbcUrl = existingConfiguration.jdbcUrl();
        this.initialSql = existingConfiguration.initialSql();
        this.driverClassName = existingConfiguration.driverClassName();
        this.classLoaderProvider = existingConfiguration.classLoaderProvider();
        this.transactionIsolation = existingConfiguration.jdbcTransactionIsolation();
        this.interruptProtection = existingConfiguration.interruptProtection();
        this.principal = existingConfiguration.principal();
        this.credentials = existingConfiguration.credentials();
        this.jdbcProperties = existingConfiguration.jdbcProperties();
    }

    private AgroalConnectionFactoryConfigurationSupplier applySetting(Consumer<AgroalConnectionFactoryConfigurationSupplier> consumer) {
        if (this.lock) {
            throw new IllegalStateException("Attempt to modify an immutable configuration");
        }
        consumer.accept(this);
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier autoCommit(boolean autoCommitEnabled) {
        return this.applySetting(c -> {
            c.autoCommit = autoCommitEnabled;
        });
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcUrl(String jdbcUrlString) {
        return this.applySetting(c -> {
            c.jdbcUrl = jdbcUrlString;
        });
    }

    public AgroalConnectionFactoryConfigurationSupplier initialSql(String initialSqlString) {
        return this.applySetting(c -> {
            c.initialSql = initialSqlString;
        });
    }

    public AgroalConnectionFactoryConfigurationSupplier driverClassName(String driverClass) {
        return this.applySetting(c -> {
            c.driverClassName = driverClass;
        });
    }

    public AgroalConnectionFactoryConfigurationSupplier classLoaderProvider(ClassLoaderProvider provider) {
        return this.applySetting(c -> {
            c.classLoaderProvider = provider;
        });
    }

    public AgroalConnectionFactoryConfigurationSupplier classLoader(ClassLoader classLoader) {
        return this.applySetting(c -> {
            c.classLoaderProvider = className -> classLoader;
        });
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolationLevel) {
        return this.applySetting(c -> {
            c.transactionIsolation = transactionIsolationLevel;
        });
    }

    @Deprecated
    public AgroalConnectionFactoryConfigurationSupplier interruptHandlingMode(InterruptProtection interruptProtectionEnabled) {
        return this.applySetting(c -> {
            c.interruptProtection = interruptProtectionEnabled;
        });
    }

    public AgroalConnectionFactoryConfigurationSupplier principal(Principal loginPrincipal) {
        return this.applySetting(c -> {
            c.principal = loginPrincipal;
        });
    }

    public AgroalConnectionFactoryConfigurationSupplier credential(Object credential) {
        return this.applySetting(c -> c.credentials.add(credential));
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcProperty(String key, String value) {
        return this.applySetting(c -> c.jdbcProperties.put(key, value));
    }

    private void validate() {
        if (this.jdbcProperties.containsKey(USER_PROPERTY_NAME)) {
            throw new IllegalArgumentException("Invalid JDBC property 'user': use principal instead.");
        }
        if (this.jdbcProperties.containsKey(PASSWORD_PROPERTY_NAME)) {
            throw new IllegalArgumentException("Invalid property 'password': use credential instead.");
        }
    }

    @Override
    public AgroalConnectionFactoryConfiguration get() {
        this.validate();
        this.lock = true;
        return new AgroalConnectionFactoryConfiguration(){

            @Override
            public boolean autoCommit() {
                return AgroalConnectionFactoryConfigurationSupplier.this.autoCommit;
            }

            @Override
            public String jdbcUrl() {
                return AgroalConnectionFactoryConfigurationSupplier.this.jdbcUrl;
            }

            @Override
            public String initialSql() {
                return AgroalConnectionFactoryConfigurationSupplier.this.initialSql;
            }

            @Override
            public String driverClassName() {
                return AgroalConnectionFactoryConfigurationSupplier.this.driverClassName;
            }

            @Override
            public ClassLoaderProvider classLoaderProvider() {
                return AgroalConnectionFactoryConfigurationSupplier.this.classLoaderProvider;
            }

            @Override
            public AgroalConnectionFactoryConfiguration.TransactionIsolation jdbcTransactionIsolation() {
                return AgroalConnectionFactoryConfigurationSupplier.this.transactionIsolation;
            }

            @Override
            public InterruptProtection interruptProtection() {
                return AgroalConnectionFactoryConfigurationSupplier.this.interruptProtection;
            }

            @Override
            public Principal principal() {
                return AgroalConnectionFactoryConfigurationSupplier.this.principal;
            }

            @Override
            public Collection<Object> credentials() {
                return AgroalConnectionFactoryConfigurationSupplier.this.credentials;
            }

            @Override
            public Properties jdbcProperties() {
                return AgroalConnectionFactoryConfigurationSupplier.this.jdbcProperties;
            }
        };
    }
}

