/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api;

import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.AgroalDataSourceProvider;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.sql.DataSource;

public interface AgroalDataSource
extends AutoCloseable,
DataSource,
Serializable {
    public static AgroalDataSource from(Supplier<AgroalDataSourceConfiguration> configurationSupplier, AgroalDataSourceListener ... listeners) throws SQLException {
        return AgroalDataSource.from(configurationSupplier.get(), listeners);
    }

    public static AgroalDataSource from(AgroalDataSourceConfiguration configuration, AgroalDataSourceListener ... listeners) throws SQLException {
        for (AgroalDataSourceProvider provider : ServiceLoader.load(AgroalDataSourceProvider.class)) {
            AgroalDataSource implementation = provider.getDataSource(configuration, listeners);
            if (implementation == null) continue;
            return implementation;
        }
        throw new SQLException("Unable to find the required implementation");
    }

    public AgroalDataSourceConfiguration getConfiguration();

    public AgroalDataSourceMetrics getMetrics();

    @Deprecated
    public void addListener(AgroalDataSourceListener var1);

    @Override
    public void close();
}

