/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AgroalPropertiesReader
implements Supplier<AgroalDataSourceConfiguration> {
    private static final String IMPLEMENTATION = "implementation";
    private static final String JNDI_NAME = "jndiName";
    private static final String METRICS_ENABLED = "metricsEnabled";
    private static final String XA = "xa";
    private static final String MIN_SIZE = "minSize";
    private static final String MAX_SIZE = "maxSize";
    private static final String PRE_FILL_MODE = "preFillMode";
    private static final String ACQUISITION_TIMEOUT = "acquisitionTimeout";
    private static final String VALIDATION_TIMEOUT = "validationTimeout";
    private static final String LEAK_TIMEOUT = "leakTimeout";
    private static final String REAP_TIMEOUT = "reapTimeout";
    private static final String JDBC_URL = "jdbcUrl";
    private static final String AUTO_COMMIT = "autoCommit";
    private static final String INITIAL_SQL = "initialSQL";
    private static final String DRIVER_CLASS_NAME = "driverClassName";
    private static final String TRANSACTION_ISOLATION = "jdbcTransactionIsolation";
    private static final String PRINCIPAL = "principal";
    private static final String CREDENTIAL = "credential";
    private static final String JDBC_PROPERTIES = "jdbcProperties";
    private final String prefix;
    private final AgroalDataSourceConfigurationSupplier dataSourceSupplier;
    private final AgroalConnectionPoolConfigurationSupplier connectionPoolSupplier;
    private final AgroalConnectionFactoryConfigurationSupplier connectionFactorySupplier;

    public AgroalPropertiesReader(String prefix) {
        this.prefix = prefix;
        this.dataSourceSupplier = new AgroalDataSourceConfigurationSupplier();
        this.connectionPoolSupplier = new AgroalConnectionPoolConfigurationSupplier();
        this.connectionFactorySupplier = new AgroalConnectionFactoryConfigurationSupplier();
    }

    @Override
    public AgroalDataSourceConfiguration get() {
        return this.dataSourceSupplier.connectionPoolConfiguration(this.connectionPoolSupplier.connectionFactoryConfiguration(this.connectionFactorySupplier)).get();
    }

    public AgroalPropertiesReader readProperties(String filename) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(filename);){
            Properties properties = new Properties();
            properties.load(inputStream);
            AgroalPropertiesReader agroalPropertiesReader = this.readProperties(properties);
            return agroalPropertiesReader;
        }
    }

    private AgroalPropertiesReader readProperties(Properties properties) {
        this.apply(this.dataSourceSupplier::dataSourceImplementation, AgroalDataSourceConfiguration.DataSourceImplementation::valueOf, properties, IMPLEMENTATION);
        this.apply(this.dataSourceSupplier::jndiName, Function.identity(), properties, JNDI_NAME);
        this.apply(this.dataSourceSupplier::metricsEnabled, Boolean::parseBoolean, properties, METRICS_ENABLED);
        this.apply(this.dataSourceSupplier::xa, Boolean::parseBoolean, properties, XA);
        this.apply(this.connectionPoolSupplier::minSize, Integer::parseInt, properties, MIN_SIZE);
        this.apply(this.connectionPoolSupplier::maxSize, Integer::parseInt, properties, MAX_SIZE);
        this.apply(this.connectionPoolSupplier::preFillMode, AgroalConnectionPoolConfiguration.PreFillMode::valueOf, properties, PRE_FILL_MODE);
        this.apply(this.connectionPoolSupplier::acquisitionTimeout, Duration::parse, properties, ACQUISITION_TIMEOUT);
        this.apply(this.connectionPoolSupplier::validationTimeout, Duration::parse, properties, VALIDATION_TIMEOUT);
        this.apply(this.connectionPoolSupplier::leakTimeout, Duration::parse, properties, LEAK_TIMEOUT);
        this.apply(this.connectionPoolSupplier::reapTimeout, Duration::parse, properties, REAP_TIMEOUT);
        this.apply(this.connectionFactorySupplier::jdbcUrl, Function.identity(), properties, JDBC_URL);
        this.apply(this.connectionFactorySupplier::autoCommit, Boolean::parseBoolean, properties, AUTO_COMMIT);
        this.apply(this.connectionFactorySupplier::initialSql, Function.identity(), properties, INITIAL_SQL);
        this.apply(this.connectionFactorySupplier::driverClassName, Function.identity(), properties, DRIVER_CLASS_NAME);
        this.apply(this.connectionFactorySupplier::jdbcTransactionIsolation, AgroalConnectionFactoryConfiguration.TransactionIsolation::valueOf, properties, TRANSACTION_ISOLATION);
        this.apply(this.connectionFactorySupplier::principal, NamePrincipal::new, properties, PRINCIPAL);
        this.apply(this.connectionFactorySupplier::credential, SimplePassword::new, properties, CREDENTIAL);
        this.applyJdbcProperties(this.connectionFactorySupplier::jdbcProperty, properties, JDBC_PROPERTIES);
        return this;
    }

    private <T> void apply(Consumer<T> consumer, Function<String, T> converter, Properties properties, String key) {
        String value = properties.getProperty(this.prefix + key);
        if (value != null) {
            consumer.accept(converter.apply(value));
        }
    }

    private void applyJdbcProperties(BiConsumer<String, String> consumer, Properties properties, String key) {
        String propertiesArray = properties.getProperty(this.prefix + key);
        if (propertiesArray != null) {
            for (String property : propertiesArray.split(";")) {
                String[] keyValue = property.split("=");
                consumer.accept(keyValue[0], keyValue[1]);
            }
        }
    }
}

