/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AgroalDataSourceConfigurationSupplier
implements Supplier<AgroalDataSourceConfiguration> {
    private volatile boolean lock = false;
    private String jndiName = "";
    private AgroalConnectionPoolConfiguration connectionPoolConfiguration = new AgroalConnectionPoolConfigurationSupplier().get();
    private AgroalDataSourceConfiguration.DataSourceImplementation dataSourceImplementation = AgroalDataSourceConfiguration.DataSourceImplementation.AGROAL;
    private boolean xa;
    private volatile boolean metrics = false;
    private volatile AgroalDataSourceConfiguration.MetricsEnabledListener metricsEnabledListener;

    private AgroalDataSourceConfigurationSupplier applySetting(Consumer<AgroalDataSourceConfigurationSupplier> consumer) {
        if (this.lock) {
            throw new IllegalStateException("Attempt to modify an immutable configuration");
        }
        consumer.accept(this);
        return this;
    }

    public AgroalDataSourceConfigurationSupplier connectionPoolConfiguration(AgroalConnectionPoolConfiguration configuration) {
        return this.applySetting(c -> {
            c.connectionPoolConfiguration = configuration;
        });
    }

    public AgroalDataSourceConfigurationSupplier connectionPoolConfiguration(Supplier<AgroalConnectionPoolConfiguration> supplier) {
        return this.connectionPoolConfiguration(supplier.get());
    }

    public AgroalDataSourceConfigurationSupplier connectionPoolConfiguration(Function<AgroalConnectionPoolConfigurationSupplier, AgroalConnectionPoolConfigurationSupplier> function) {
        return this.connectionPoolConfiguration(function.apply(new AgroalConnectionPoolConfigurationSupplier(this.connectionPoolConfiguration)));
    }

    public AgroalDataSourceConfigurationSupplier dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation implementation) {
        return this.applySetting(c -> {
            c.dataSourceImplementation = implementation;
        });
    }

    public AgroalDataSourceConfigurationSupplier jndiName(String name) {
        return this.applySetting(c -> {
            c.jndiName = name;
        });
    }

    public AgroalDataSourceConfigurationSupplier xa(boolean xa) {
        return this.applySetting(c -> {
            c.xa = xa;
        });
    }

    public AgroalDataSourceConfigurationSupplier metricsEnabled(boolean metrics) {
        return this.applySetting(c -> {
            c.metrics = metrics;
        });
    }

    private void validate() {
        if (this.connectionPoolConfiguration == null) {
            throw new IllegalArgumentException("Connection poll configuration not defined");
        }
    }

    @Override
    public AgroalDataSourceConfiguration get() {
        this.validate();
        this.lock = true;
        return new AgroalDataSourceConfiguration(){

            @Override
            public String jndiName() {
                return AgroalDataSourceConfigurationSupplier.this.jndiName;
            }

            @Override
            public AgroalConnectionPoolConfiguration connectionPoolConfiguration() {
                return AgroalDataSourceConfigurationSupplier.this.connectionPoolConfiguration;
            }

            @Override
            public AgroalDataSourceConfiguration.DataSourceImplementation dataSourceImplementation() {
                return AgroalDataSourceConfigurationSupplier.this.dataSourceImplementation;
            }

            @Override
            public boolean isXA() {
                return AgroalDataSourceConfigurationSupplier.this.xa;
            }

            @Override
            public boolean metricsEnabled() {
                return AgroalDataSourceConfigurationSupplier.this.metrics;
            }

            @Override
            public void setMetricsEnabled(boolean metricsEnabled) {
                AgroalDataSourceConfigurationSupplier.this.metrics = metricsEnabled;
                if (AgroalDataSourceConfigurationSupplier.this.metricsEnabledListener != null) {
                    AgroalDataSourceConfigurationSupplier.this.metricsEnabledListener.onMetricsEnabled(metricsEnabled);
                }
            }

            @Override
            public void registerMetricsEnabledListener(AgroalDataSourceConfiguration.MetricsEnabledListener listener) {
                AgroalDataSourceConfigurationSupplier.this.metricsEnabledListener = listener;
            }
        };
    }
}

