/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.RemoteInvitation;
import io.agora.rtm.jni.IRemoteCallInvitation;

class RemoteInvitationWrapper
implements RemoteInvitation {
    private static final String TAG = RemoteInvitationWrapper.class.getSimpleName();
    private String callerId = "";
    private String response = "";
    IRemoteCallInvitation invitationNative;

    RemoteInvitationWrapper(@NonNull IRemoteCallInvitation invitationNative) {
        this.invitationNative = invitationNative;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isNativeNull()) {
            this.invitationNative.release();
        }
    }

    @Override
    public String getCallerId() {
        if (this.callerId == null || this.callerId.isEmpty()) {
            this.callerId = this.isNativeNull() ? "" : this.invitationNative.getCallerId();
        }
        return this.callerId;
    }

    @Override
    public String getContent() {
        return this.isNativeNull() ? "" : this.invitationNative.getContent();
    }

    @Override
    public String getChannelId() {
        return this.isNativeNull() ? "" : this.invitationNative.getChannelId();
    }

    @Override
    public void setResponse(String response) {
        this.response = response;
        if (!this.isNativeNull()) {
            this.invitationNative.setResponse(response);
        }
    }

    @Override
    public String getResponse() {
        return this.response;
    }

    @Override
    public int getState() {
        return this.isNativeNull() ? 0 : this.invitationNative.getState().swigValue();
    }

    public String toString() {
        return "remoteInvitation {callerId: " + this.getCallerId() + ", channelId: " + this.getChannelId() + "}";
    }

    private boolean isNativeNull() {
        if (this.invitationNative == null) {
            Logging.e(TAG, "native is null!");
            return true;
        }
        return false;
    }
}

