/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.LocalInvitation;
import io.agora.rtm.jni.ILocalCallInvitation;
import io.agora.rtm.jni.IRtmCallManager;

class LocalInvitationWrapper
implements LocalInvitation {
    private static final String TAG = LocalInvitationWrapper.class.getSimpleName();
    private String calleeId;
    private String content = "";
    private String channelId = "";
    ILocalCallInvitation invitationNative;

    private LocalInvitationWrapper(ILocalCallInvitation invitationNative, String calleeId) {
        this.invitationNative = invitationNative;
        this.calleeId = calleeId;
    }

    static LocalInvitationWrapper create(@NonNull IRtmCallManager callManager, String calleeId) {
        ILocalCallInvitation invitationNative = callManager.createLocalCallInvitation(calleeId);
        return invitationNative == null ? null : new LocalInvitationWrapper(invitationNative, calleeId);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isNativeNull()) {
            this.invitationNative.release();
        }
    }

    @Override
    public String getCalleeId() {
        return this.calleeId;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
        if (!this.isNativeNull()) {
            this.invitationNative.setContent(content);
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setChannelId(String channelId) {
        this.channelId = channelId;
        if (!this.isNativeNull()) {
            this.invitationNative.setChannelId(channelId);
        }
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public String getResponse() {
        return this.isNativeNull() ? "" : this.invitationNative.getResponse();
    }

    @Override
    public int getState() {
        return this.isNativeNull() ? 0 : this.invitationNative.getState().swigValue();
    }

    public String toString() {
        return "localInvitation {callee: " + this.getCalleeId() + ", channelId: " + this.getChannelId() + "}";
    }

    private boolean isNativeNull() {
        if (this.invitationNative == null) {
            Logging.e(TAG, "native is null!");
            return true;
        }
        return false;
    }
}

