/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import android.content.Context;
import android.os.Process;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.VideoCaptureFactory;

public class CameraUtils {
    private static final String TAG = "CameraUtils";

    public static void checkCameraPermission(Context context) {
        if (context == null || context.checkPermission("android.permission.CAMERA", Process.myPid(), Process.myUid()) != 0) {
            throw new SecurityException("android.permission.CAMERA is not granted");
        }
    }

    public static int selectFrontCamera(Context context) {
        return VideoCaptureFactory.getFrontCameraIndex(context);
    }

    public static int getNumberOfCameras(Context context) {
        try {
            return VideoCaptureFactory.getNumberOfCameras(context);
        }
        catch (Exception exception) {
            Logging.e(TAG, exception.toString());
            return 0;
        }
    }
}

