/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.CoordinatesTransform;
import io.agora.rtc.video.VideoCapture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@TargetApi(value=21)
public class VideoCaptureCamera2
extends VideoCapture {
    private static final boolean DEBUG = false;
    private CameraDevice mCameraDevice = null;
    private CaptureRequest.Builder mPreviewBuilder = null;
    private CameraCaptureSession mCaptureSession = null;
    private ImageReader mImageReader = null;
    private static final double kNanoSecondsToFps = 1.0E-9;
    private static final String TAG = "CAMERA2";
    private CameraState mCameraState = CameraState.STOPPED;
    private CameraManager mManager = null;
    private Handler mStateHandler = null;
    private HandlerThread mCameraStateThread = null;
    private HandlerThread mPreviewThread = null;
    private final Object mCameraStateLock = new Object();
    private int mExpectedFrameSize = 0;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFps = -1;
    private int mCaptureFormat = 35;
    private byte[] mCaptureData;
    private boolean mFaceDetectSupported;
    private int mFaceDetectMode;
    private boolean mIsAutoFaceFocusEnabled = false;
    private RectF[] rectArray = null;
    private int[] distanceArray = null;
    private boolean faceDistaneEnabled = false;
    private static final int DEFAULT_MATCH_FPS = 15;
    private static final MeteringRectangle[] ZERO_WEIGHT_3A_REGION = new MeteringRectangle[]{new MeteringRectangle(0, 0, 0, 0, 0)};
    private MeteringRectangle[] mAFAERegions = ZERO_WEIGHT_3A_REGION;
    private static final float ZOOM_UNSUPPORTED_DEFAULT_VALUE = 1.0f;
    private static final float DEFAULT_VALUE = -1.0f;
    private float mLastZoomRatio = -1.0f;
    private float mCurZoomRatio = 1.0f;
    private float mMaxZoom = -1.0f;
    private Rect mSensorRect = null;
    public CameraManager.AvailabilityCallback mAvailabilityCallback = new CameraManager.AvailabilityCallback(){

        public synchronized void onCameraAvailable(String string) {
            super.onCameraAvailable(string);
            if (VideoCaptureCamera2.this.mCameraState == CameraState.EVICTED) {
                if (VideoCaptureCamera2.this.tryOpenCamera() == 0) {
                    if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                        VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "no error");
                    }
                } else {
                    Logging.e(VideoCaptureCamera2.TAG, "start capture failed");
                }
            }
        }

        public synchronized void onCameraUnavailable(String string) {
            super.onCameraUnavailable(string);
            Logging.e(VideoCaptureCamera2.TAG, "Camera " + string + " unavailable");
        }
    };
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){
        private long mLastFocusedTs;

        private void notifyCameraFocusAreaChanged(Rect rect, Rect rect2) {
            Rect rect3 = CoordinatesTransform.sensorToNormalizedPreview(rect2, VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, rect);
            Logging.d(VideoCaptureCamera2.TAG, "face bound = " + rect2.toString());
            Logging.d(VideoCaptureCamera2.TAG, "rect (-1000, 1000) = " + rect3.toString());
            boolean bl = false;
            if (VideoCaptureCamera2.this.mId == 1) {
                bl = true;
            }
            RectF rectF = CoordinatesTransform.normalizedFaceRect(rect3, 0, bl);
            Logging.d(VideoCaptureCamera2.TAG, "preview size width = " + VideoCaptureCamera2.this.mCaptureWidth + " height = " + VideoCaptureCamera2.this.mCaptureHeight);
            Logging.d(VideoCaptureCamera2.TAG, "auto face focus left =" + rectF.left + " top = " + rectF.top + " right = " + rectF.right + " bottom = " + rectF.bottom + "isMirror =" + bl);
            float f2 = rectF.left;
            float f3 = rectF.top;
            float f4 = rectF.width();
            float f5 = rectF.height();
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.NotifyCameraFocusAreaChanged(f2, f3, f4, f5, VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid);
            }
        }

        private void notifyFaceDetection(Rect rect, Face[] faceArray) {
            VideoCaptureCamera2.access$402(VideoCaptureCamera2.this, null);
            int n2 = 0;
            boolean bl = false;
            if (VideoCaptureCamera2.this.mId == 1) {
                bl = true;
            }
            if (faceArray != null && faceArray.length > 0) {
                n2 = faceArray.length;
                VideoCaptureCamera2.access$402(VideoCaptureCamera2.this, new RectF[n2]);
                VideoCaptureCamera2.access$502(VideoCaptureCamera2.this, new int[n2]);
                for (int i2 = 0; i2 < n2; ++i2) {
                    Rect rect2 = CoordinatesTransform.sensorToNormalizedPreview(faceArray[i2].getBounds(), VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, rect);
                    ((VideoCaptureCamera2)VideoCaptureCamera2.this).rectArray[i2] = CoordinatesTransform.normalizedFaceRect(rect2, 0, bl);
                    ((VideoCaptureCamera2)VideoCaptureCamera2.this).distanceArray[i2] = 5;
                }
            } else {
                return;
            }
            Logging.d(VideoCaptureCamera2.TAG, "before notify face");
            VideoCaptureCamera2.this.NotifyFaceDetection(VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, VideoCaptureCamera2.this.rectArray, n2, VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid);
        }

        private void process(CaptureResult captureResult) {
            Face[] faceArray = (Face[])captureResult.get(CaptureResult.STATISTICS_FACES);
            if (faceArray != null && faceArray.length > 0) {
                if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                    if (faceArray[0].getScore() > 20) {
                        Rect rect = (Rect)captureResult.get(CaptureResult.SCALER_CROP_REGION);
                        this.notifyCameraFocusAreaChanged(rect, faceArray[0].getBounds());
                    }
                    return;
                }
                if (faceArray[0].getScore() <= 50) {
                    return;
                }
                VideoCaptureCamera2.access$602(VideoCaptureCamera2.this, new MeteringRectangle[]{new MeteringRectangle(faceArray[0].getBounds(), 1000)});
                VideoCaptureCamera2.this.addRegionsToCaptureRequestBuilder(VideoCaptureCamera2.this.mPreviewBuilder);
                if (VideoCaptureCamera2.this.mCameraState != CameraState.STARTED) {
                    return;
                }
                try {
                    Rect rect = (Rect)captureResult.get(CaptureResult.SCALER_CROP_REGION);
                    Logging.d(VideoCaptureCamera2.TAG, "cropRegion = " + rect.toString());
                    Logging.d(VideoCaptureCamera2.TAG, "capture size wxh = " + VideoCaptureCamera2.this.mCaptureWidth + " x " + VideoCaptureCamera2.this.mCaptureHeight);
                    this.notifyCameraFocusAreaChanged(rect, faceArray[0].getBounds());
                    VideoCaptureCamera2.this.mCaptureSession.capture(VideoCaptureCamera2.this.mPreviewBuilder.build(), VideoCaptureCamera2.this.mCaptureCallback, null);
                }
                catch (Exception exception) {
                    Logging.e(VideoCaptureCamera2.TAG, "capture: " + exception);
                    return;
                }
                VideoCaptureCamera2.this.createCaptureRequest();
                this.mLastFocusedTs = System.currentTimeMillis();
            } else {
                VideoCaptureCamera2.access$602(VideoCaptureCamera2.this, ZERO_WEIGHT_3A_REGION);
            }
        }

        public void onCaptureProgressed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureResult captureResult) {
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            if (VideoCaptureCamera2.this.mIsAutoFaceFocusEnabled && VideoCaptureCamera2.this.isAutoFaceFocusSupported()) {
                this.process((CaptureResult)totalCaptureResult);
            }
            if (VideoCaptureCamera2.this.faceDistaneEnabled) {
                this.notifyFaceDetection((Rect)totalCaptureResult.get(CaptureResult.SCALER_CROP_REGION), (Face[])totalCaptureResult.get(CaptureResult.STATISTICS_FACES));
            }
        }
    };
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult captureResult) {
            Integer n2 = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
            if (null == n2) {
                return;
            }
            if (4 == n2 || 5 == n2) {
                VideoCaptureCamera2.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                VideoCaptureCamera2.this.startNormalPreview();
            }
        }

        public void onCaptureProgressed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureResult captureResult) {
            this.process(captureResult);
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            this.process((CaptureResult)totalCaptureResult);
        }
    };

    private static CameraCharacteristics getCameraCharacteristics(Context context, int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            Logging.i(TAG, "getCameraCharacteristics error,  camera id: " + n2);
            return null;
        }
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            return cameraManager.getCameraCharacteristics(Integer.toString(n2));
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.i(TAG, "getNumberOfCameras: getCameraIdList(): " + (Object)((Object)cameraAccessException));
        }
        catch (Exception exception) {
            Logging.i(TAG, "getNumberOfCameras: got exception: " + exception);
        }
        return null;
    }

    static boolean isLegacyDevice(Context context, int n2) {
        try {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n2);
            return cameraCharacteristics == null || (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2;
        }
        catch (Throwable throwable) {
            Logging.w(TAG, "this is a legacy camera device");
            return true;
        }
    }

    static int getNumberOfCameras(Context context) {
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            int n2 = cameraManager.getCameraIdList().length;
            Logging.i(TAG, "VideoCaptureCamera2 listCount:" + n2);
            return n2;
        }
        catch (Exception exception) {
            Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): ", exception);
            return 0;
        }
    }

    static String getName(int n2, Context context) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n2);
        if (cameraCharacteristics == null) {
            return null;
        }
        int n3 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        return "camera2 " + n2 + ", facing " + (n3 == 0 ? "front" : "back");
    }

    static String getCaptureName() {
        return "camera2";
    }

    static int getSensorOrientation(int n2, Context context) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n2);
        if (cameraCharacteristics == null) {
            return -1;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    VideoCaptureCamera2(Context context, int n2, long l2, int n3) {
        super(context, n2, l2, n3);
    }

    private void startNormalPreview() {
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        Handler handler = new Handler(this.mPreviewThread.getLooper());
        try {
            this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "setRepeatingRequest failed, error message : " + cameraAccessException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCameraStateAndNotify(CameraState cameraState) {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mCameraState = cameraState;
            this.mCameraStateLock.notifyAll();
        }
    }

    private int createCaptureRequest() {
        try {
            this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, null);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "setRepeatingRequest: ", cameraAccessException);
            return -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "setRepeatingRequest: ", illegalArgumentException);
            return -2;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "setRepeatingRequest: ", securityException);
            return -3;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "capture:" + illegalStateException);
            return -4;
        }
        return 0;
    }

    private static void readImageIntoBuffer(Image image, byte[] byArray) {
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        Image.Plane[] planeArray = image.getPlanes();
        int n4 = 0;
        for (int i2 = 0; i2 < planeArray.length; ++i2) {
            int n5;
            int n6;
            ByteBuffer byteBuffer = planeArray[i2].getBuffer();
            if (byteBuffer == null) {
                Logging.e(TAG, "plane " + i2 + " buffer is null ");
                break;
            }
            int n7 = planeArray[i2].getRowStride();
            int n8 = planeArray[i2].getPixelStride();
            int n9 = i2 == 0 ? n2 : n2 / 2;
            int n10 = n6 = i2 == 0 ? n3 : n3 / 2;
            if (n8 == 1 && n7 == n9) {
                byteBuffer.get(byArray, n4, n9 * n6);
                n4 += n9 * n6;
                continue;
            }
            byte[] byArray2 = new byte[n7];
            for (n5 = 0; n5 < n6 - 1; ++n5) {
                byteBuffer.get(byArray2, 0, n7);
                for (int i3 = 0; i3 < n9; ++i3) {
                    byArray[n4++] = byArray2[i3 * n8];
                }
            }
            byteBuffer.get(byArray2, 0, Math.min(n7, byteBuffer.remaining()));
            for (n5 = 0; n5 < n9; ++n5) {
                byArray[n4++] = byArray2[n5 * n8];
            }
        }
    }

    private int tryOpenCamera() {
        CrStateListener crStateListener = new CrStateListener();
        try {
            this.mManager.openCamera(Integer.toString(this.mId), (CameraDevice.StateCallback)crStateListener, this.mStateHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", cameraAccessException);
            return -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", illegalArgumentException);
            return -2;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", securityException);
            return -3;
        }
        catch (Exception exception) {
            Logging.e(TAG, "unknown error", exception);
            return -4;
        }
        return 0;
    }

    private void addRegionsToCaptureRequestBuilder(CaptureRequest.Builder builder) {
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        builder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)this.mAFAERegions);
        builder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)this.mAFAERegions);
        builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
    }

    private int doStartCapture() {
        Object object;
        int n2;
        this.mExpectedFrameSize = n2 = this.mCaptureWidth * this.mCaptureHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat) / 8;
        this.mCaptureData = new byte[this.mExpectedFrameSize];
        this.mImageReader = ImageReader.newInstance((int)this.mCaptureWidth, (int)this.mCaptureHeight, (int)this.mCaptureFormat, (int)2);
        if (this.mPreviewThread == null) {
            this.mPreviewThread = new HandlerThread("CameraPreview");
            this.mPreviewThread.start();
        }
        Handler handler = new Handler(this.mPreviewThread.getLooper());
        ImageReaderListener imageReaderListener = new ImageReaderListener();
        this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)imageReaderListener, handler);
        try {
            this.mPreviewBuilder = this.mCameraDevice.createCaptureRequest(1);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "createCaptureRequest: ", cameraAccessException);
            return -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "createCaptureRequest: ", illegalArgumentException);
            return -2;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "createCaptureRequest ", securityException);
            return -3;
        }
        if (this.mPreviewBuilder == null) {
            Logging.e(TAG, "mPreviewBuilder error");
            return -4;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics != null && (object = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) != null) {
            if (this.mPQFirst < 1) {
                Arrays.sort(object, new Comparator<Range<Integer>>(){

                    @Override
                    public int compare(Range<Integer> range, Range<Integer> range2) {
                        return (Integer)range.getLower() - (Integer)range2.getLower();
                    }
                });
                Logging.i(TAG, "sorted fps Ranges List:" + Arrays.toString((Object[])object));
                for (Object object2 : object) {
                    if ((Integer)object2.getLower() < Math.max(this.mCaptureFps, 15)) continue;
                    Logging.i(TAG, "set fps :" + object2.toString() + " to camera2::fps first, request:" + this.mCaptureFps);
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, object2);
                    break;
                }
            } else {
                Arrays.sort(object, new Comparator<Range<Integer>>(){

                    @Override
                    public int compare(Range<Integer> range, Range<Integer> range2) {
                        return (Integer)range.getUpper() - (Integer)range2.getUpper();
                    }
                });
                Logging.i(TAG, "sorted fps Ranges List:" + Arrays.toString((Object[])object));
                for (Object object3 : object) {
                    if ((Integer)object3.getUpper() < this.mCaptureFps) continue;
                    Logging.i(TAG, "set fps :" + object3.toString() + " to camera2::PQ first, request:" + this.mCaptureFps);
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, object3);
                    break;
                }
            }
        }
        this.mPreviewBuilder.addTarget(this.mImageReader.getSurface());
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        this.setFaceDetect(this.mPreviewBuilder, this.mFaceDetectMode);
        object = new ArrayList(1);
        object.add(this.mImageReader.getSurface());
        CaptureSessionListener captureSessionListener = new CaptureSessionListener();
        try {
            this.mCameraDevice.createCaptureSession((List)object, (CameraCaptureSession.StateCallback)captureSessionListener, null);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "createCaptureSession :", cameraAccessException);
            return -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "createCaptureSession :", illegalArgumentException);
            return -2;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "createCaptureSession :", securityException);
            return -3;
        }
        return 0;
    }

    private int doStopCapture() {
        if (this.mPreviewThread != null) {
            this.mPreviewThread.quitSafely();
            this.mPreviewThread = null;
        }
        if (this.mCaptureSession != null) {
            try {
                this.mCaptureSession.abortCaptures();
                this.mCaptureSession = null;
            }
            catch (CameraAccessException cameraAccessException) {
                Logging.e(TAG, "abortCaptures: ", cameraAccessException);
                return -1;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "abortCaptures: ", illegalStateException);
                return -1;
            }
        }
        if (this.mImageReader != null) {
            this.mImageReader.setOnImageAvailableListener(null, null);
            this.mImageReader.close();
            this.mImageReader = null;
        }
        if (this.mCameraDevice != null) {
            this.mCameraDevice.close();
            this.mCameraDevice = null;
        }
        return 0;
    }

    @Override
    public int UnRegisterNativeHandle() {
        this.mNativeVideoCaptureDeviceAndroid = 0L;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate() {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            if (this.mCameraState == CameraState.OPENING) {
                Logging.e(TAG, "allocate() invoked while Camera is busy opening/configuring");
                return -1;
            }
        }
        object = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (object == null) {
            return -1;
        }
        if (VideoCapture.fetchCapability(this.mId, this.mContext, VideoCaptureCamera2.getCaptureName()) == null) {
            VideoCaptureCamera2.createCapabilities(this.mId, this.mContext);
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.mIsAutoFaceFocusEnabled = this.isAutoFaceFocusEnabled(this.mNativeVideoCaptureDeviceAndroid);
            this.faceDistaneEnabled = this.isFaceDetectionEnabled(this.mNativeVideoCaptureDeviceAndroid);
        }
        this.mCameraNativeOrientation = (Integer)object.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.mManager = (CameraManager)this.mContext.getSystemService("camera");
        int[] nArray = (int[])object.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        int n2 = (Integer)object.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (nArray.length > 1 && n2 > 0) {
            this.mFaceDetectSupported = true;
            int n3 = 0;
            for (int n4 : nArray) {
                n3 += n4;
            }
            this.mFaceDetectMode = n3 % 2 != 0 ? 1 : 2;
        }
        Logging.i(TAG, "allocate() face detection: " + this.mFaceDetectMode + " " + n2 + " " + this.mFaceDetectSupported);
        if (this.mCameraStateThread == null) {
            this.mCameraStateThread = new HandlerThread("CameraCallbackThread");
            this.mCameraStateThread.start();
            this.mStateHandler = new Handler(this.mCameraStateThread.getLooper());
        }
        this.mManager.registerAvailabilityCallback(this.mAvailabilityCallback, this.mStateHandler);
        return 0;
    }

    @Override
    public int setCaptureFormat(int n2) {
        int n3 = VideoCaptureCamera2.translateToAndroidFormat(n2);
        if (n3 != this.mCaptureFormat) {
            Logging.e(TAG, "For camera2 api, only YUV_420_888 format are supported");
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startCapture(int n2, int n3, int n4) {
        Logging.d(TAG, "startCapture, w=" + n2 + ", h=" + n3 + ", fps=" + n4);
        this.mCaptureWidth = n2;
        this.mCaptureHeight = n3;
        this.mCaptureFps = n4;
        Object object = this.mCameraStateLock;
        synchronized (object) {
            while (this.mCameraState != CameraState.STARTED && this.mCameraState != CameraState.EVICTED && this.mCameraState != CameraState.STOPPED) {
                try {
                    this.mCameraStateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logging.e(TAG, "CaptureStartedEvent: ", interruptedException);
                }
            }
            if (this.mCameraState == CameraState.STARTED) {
                return 0;
            }
        }
        this.changeCameraStateAndNotify(CameraState.OPENING);
        int n5 = this.tryOpenCamera();
        if (n5 != 0) {
            this.changeCameraStateAndNotify(CameraState.STOPPED);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopCapture() {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            while (this.mCameraState != CameraState.STARTED && this.mCameraState != CameraState.EVICTED && this.mCameraState != CameraState.STOPPED) {
                try {
                    this.mCameraStateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logging.e(TAG, "CaptureStartedEvent: ", interruptedException);
                }
            }
            if (this.mCameraState == CameraState.EVICTED) {
                this.mCameraState = CameraState.STOPPED;
            }
            if (this.mCameraState == CameraState.STOPPED) {
                return 0;
            }
            this.doStopCapture();
            this.mCameraState = CameraState.STOPPED;
            this.mCameraStateLock.notifyAll();
        }
        return 0;
    }

    @Override
    public boolean isTorchSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Boolean bl = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        boolean bl2 = bl == null ? false : bl;
        return bl2;
    }

    @Override
    public boolean isFocusSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (1 != i2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExposureSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                Logging.d(TAG, "isExposureSupported AE mode = " + nArray[i2]);
                if (1 != i2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isZoomSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        float f2 = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        return f2 > 1.0f;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        if (!this.isFocusSupported()) {
            return false;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Integer n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        return n2 > 0;
    }

    @Override
    public int setZoom(float f2) {
        boolean bl;
        Log.d((String)"zoom", (String)("setCameraZoom api2 called zoomValue =" + f2));
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setZoom mPreviewBuilder is null");
            return -1;
        }
        if (this.mSensorRect == null) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1;
            }
            this.mSensorRect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            this.mMaxZoom = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        if (Math.abs(this.mMaxZoom - 1.0f) < 0.001f) {
            Logging.w(TAG, "Camera " + this.mId + " does not support camera zoom");
            return -1;
        }
        this.mCurZoomRatio = f2;
        boolean bl2 = bl = this.mCurZoomRatio >= 1.0f && this.mCurZoomRatio <= this.mMaxZoom && this.mCurZoomRatio != this.mLastZoomRatio;
        if (!bl) {
            return -2;
        }
        Rect rect = this.cropRegionForZoom(this.mCurZoomRatio);
        this.mPreviewBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)rect);
        this.mLastZoomRatio = this.mCurZoomRatio;
        if (this.mPreviewThread != null) {
            Handler handler = new Handler(this.mPreviewThread.getLooper());
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                }
                catch (CameraAccessException cameraAccessException) {
                    cameraAccessException.printStackTrace();
                    return -3;
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    return -4;
                }
            }
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mMaxZoom <= 0.0f) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1.0f;
            }
            this.mMaxZoom = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        return this.mMaxZoom;
    }

    @Override
    public int setTorchMode(boolean bl) {
        boolean bl2;
        Log.d((String)"flash", (String)("setFlashMode isTorchOn " + bl));
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return -1;
        }
        Boolean bl3 = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        boolean bl4 = bl2 = bl3 == null ? false : bl3;
        if (bl2) {
            if (this.mPreviewThread != null && this.mPreviewBuilder != null) {
                Handler handler = new Handler(this.mPreviewThread.getLooper());
                if (bl) {
                    this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                } else {
                    this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                }
                if (this.mCaptureSession != null) {
                    try {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, handler);
                        return 0;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                }
            }
        } else {
            Logging.w(TAG, "flash is not supported");
        }
        return -1;
    }

    @Override
    public int setFocus(float f2, float f3, boolean bl) {
        int n2;
        if (f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setFocus mPreviewBuilder is null");
            return -1;
        }
        double d2 = f2;
        double d3 = f3;
        Rect rect = (Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (rect == null) {
            return -1;
        }
        int n3 = rect.width();
        int n4 = rect.height();
        Log.d((String)"test", (String)("crop width = " + n3 + " crop height = " + n4 + " capture width = " + this.mCaptureWidth + " capture height = " + this.mCaptureHeight));
        int n5 = 0;
        int n6 = 0;
        if (n3 * this.mCaptureHeight > n4 * this.mCaptureWidth) {
            n2 = n4 * this.mCaptureWidth / this.mCaptureHeight;
            n5 = (int)((double)((float)(n3 - n2) / 2.0f) + d2 * (double)n2);
            n6 = (int)(d3 * (double)n4);
        } else {
            n2 = n3 * this.mCaptureHeight / this.mCaptureWidth;
            n5 = (int)(d2 * (double)n3);
            n6 = (int)((double)((float)(n4 - n2) / 2.0f) + d3 * (double)n2);
        }
        double d4 = 0.1;
        Rect rect2 = new Rect();
        rect2.left = VideoCaptureCamera2.clamp((int)((double)n5 - d4 / 2.0 * (double)n3), 0, n3);
        rect2.right = VideoCaptureCamera2.clamp((int)((double)n5 + d4 / 2.0 * (double)n3), 0, n3);
        rect2.top = VideoCaptureCamera2.clamp((int)((double)n6 - d4 / 2.0 * (double)n4), 0, n4);
        rect2.bottom = VideoCaptureCamera2.clamp((int)((double)n6 + d4 / 2.0 * (double)n4), 0, n4);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect2, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect2, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mPreviewThread != null) {
            Handler handler = new Handler(this.mPreviewThread.getLooper());
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mAfCaptureCallback, handler);
                }
                catch (CameraAccessException cameraAccessException) {
                    cameraAccessException.printStackTrace();
                    return -1;
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    return -1;
                }
            }
            if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
                this.NotifyCameraFocusAreaChanged(f2, f3, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
            }
        }
        return 0;
    }

    @Override
    public int setExposure(float f2, float f3, boolean bl) {
        int n2;
        Logging.d(TAG, "setExposure called camera api2");
        if (f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            Logging.e(TAG, "set exposure unreasonable inputs");
            return -1;
        }
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setExposure mPreviewBuilder is null");
            return -1;
        }
        double d2 = f2;
        double d3 = f3;
        Rect rect = (Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (rect == null) {
            return -1;
        }
        int n3 = rect.width();
        int n4 = rect.height();
        Logging.d(TAG, "crop width = " + n3 + " crop height = " + n4 + " capture width = " + this.mCaptureWidth + " capture height = " + this.mCaptureHeight);
        int n5 = 0;
        int n6 = 0;
        if (n3 * this.mCaptureHeight > n4 * this.mCaptureWidth) {
            n2 = n4 * this.mCaptureWidth / this.mCaptureHeight;
            n5 = (int)((double)((float)(n3 - n2) / 2.0f) + d2 * (double)n2);
            n6 = (int)(d3 * (double)n4);
        } else {
            n2 = n3 * this.mCaptureHeight / this.mCaptureWidth;
            n5 = (int)(d2 * (double)n3);
            n6 = (int)((double)((float)(n4 - n2) / 2.0f) + d3 * (double)n2);
        }
        double d4 = 0.1;
        Rect rect2 = new Rect();
        rect2.left = VideoCaptureCamera2.clamp((int)((double)n5 - d4 / 2.0 * (double)n3), 0, n3);
        rect2.right = VideoCaptureCamera2.clamp((int)((double)n5 + d4 / 2.0 * (double)n3), 0, n3);
        rect2.top = VideoCaptureCamera2.clamp((int)((double)n6 - d4 / 2.0 * (double)n4), 0, n4);
        rect2.bottom = VideoCaptureCamera2.clamp((int)((double)n6 + d4 / 2.0 * (double)n4), 0, n4);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect2, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mCaptureSession != null) {
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, null);
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
                return -1;
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
                return -1;
            }
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraExposureAreaChanged(f2, f3, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setAutoFaceFocus(boolean bl) {
        boolean bl2 = this.mIsAutoFaceFocusEnabled != bl;
        this.mIsAutoFaceFocusEnabled = bl;
        if (this.mFaceDetectSupported && bl2) {
            if (this.mPreviewThread != null && this.mPreviewBuilder != null) {
                Handler handler = new Handler(this.mPreviewThread.getLooper());
                if (this.mIsAutoFaceFocusEnabled) {
                    this.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
                } else {
                    if (this.faceDistaneEnabled) {
                        Logging.w(TAG, "face detect did not turn off due to faceDistance on");
                        return 0;
                    }
                    this.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                }
                if (this.mCaptureSession != null) {
                    try {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                        return 0;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                }
            }
        } else {
            Logging.w(TAG, "face detect no change");
        }
        return 0;
    }

    @Override
    public int setFaceDetection(boolean bl) {
        boolean bl2 = this.faceDistaneEnabled != bl;
        this.faceDistaneEnabled = bl;
        if (this.mFaceDetectSupported && bl2) {
            if (this.mPreviewThread != null && this.mPreviewBuilder != null) {
                Handler handler = new Handler(this.mPreviewThread.getLooper());
                if (this.faceDistaneEnabled) {
                    this.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
                } else {
                    if (this.mIsAutoFaceFocusEnabled) {
                        Logging.w(TAG, "face detect did not turn off due to autoFocus on");
                        return 0;
                    }
                    this.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                }
                if (this.mCaptureSession != null) {
                    try {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, handler);
                        return 0;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                }
            }
        } else {
            Logging.w(TAG, "face detect no change");
        }
        return 0;
    }

    @Override
    public void deallocate() {
        if (this.mManager != null) {
            this.mManager.unregisterAvailabilityCallback(this.mAvailabilityCallback);
            if (this.mCameraStateThread != null) {
                this.mCameraStateThread.quitSafely();
                this.mCameraStateThread = null;
                this.mStateHandler = null;
            }
        }
    }

    private void setFaceDetect(CaptureRequest.Builder builder, int n2) {
        if (this.mFaceDetectSupported && (this.mIsAutoFaceFocusEnabled || this.faceDistaneEnabled)) {
            builder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int createCapabilities(int n2, Context context) {
        Object object;
        Object object2;
        String string = null;
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n2);
        if (cameraCharacteristics == null) {
            return -1;
        }
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (streamConfigurationMap == null) {
            Logging.e(TAG, "Failed to create capabilities");
            return -1;
        }
        try {
            Logging.i(TAG, "dump configuration map:" + streamConfigurationMap.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ArrayList<Object> arrayList = new ArrayList<Size>(Arrays.asList(streamConfigurationMap.getOutputSizes(35)));
        if ("SM-G9300".equals(Build.MODEL)) {
            object2 = new ArrayList();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                if (((Size)arrayList.get(i2)).getHeight() < 720) continue;
                object2.add(arrayList.get(i2));
            }
            arrayList = object2;
        }
        object2 = "\"id\":" + n2 + ",";
        String string2 = "\"resolution\":";
        String string3 = "";
        String string4 = String.valueOf(15);
        Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (rangeArray != null) {
            void n3;
            ArrayList<Comparable> arrayList2 = new ArrayList<Comparable>();
            object = rangeArray;
            int n4 = ((Range[])object).length;
            boolean bl = false;
            while (n3 < n4) {
                Range range = object[n3];
                arrayList2.add(range.getUpper());
                ++n3;
            }
            object = new StringBuilder();
            for (Integer string5 : arrayList2) {
                ((StringBuilder)object).append(string5 + ",");
            }
            if (arrayList2.size() > 0) {
                ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
            }
            string4 = ((StringBuilder)object).toString();
        }
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            int n4 = ((Size)arrayList.get(i3)).getWidth();
            int n5 = ((Size)arrayList.get(i3)).getHeight();
            if (n4 < 240 || n5 < 240 || n4 < 320 && n5 < 320) continue;
            String string8 = "{\"w\":" + n4 + ",\"h\":" + n5 + "}";
            string3 = !string3.isEmpty() ? string3 + "," + string8 : string8;
        }
        String string6 = "\"format\":";
        object = "" + VideoCaptureCamera2.translateToEngineFormat(35);
        String string7 = "\"fps\":";
        String string5 = string4;
        string = "{" + (String)object2 + string2 + "[" + string3 + "]," + string6 + "[" + (String)object + "]," + string7 + "[" + string5 + "]}";
        VideoCaptureCamera2.cacheCapability(n2, context, string, VideoCaptureCamera2.getCaptureName());
        return 0;
    }

    private Rect cropRegionForZoom(float f2) {
        int n2 = this.mSensorRect.width() / 2;
        int n3 = this.mSensorRect.height() / 2;
        int n4 = (int)(0.5f * (float)this.mSensorRect.width() / f2);
        int n5 = (int)(0.5f * (float)this.mSensorRect.height() / f2);
        return new Rect(n2 - n4, n3 - n5, n2 + n4, n3 + n5);
    }

    private static int clamp(int n2, int n3, int n4) {
        return Math.max(n3, Math.min(n4, n2));
    }

    private boolean isMeteringAreaAFSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF) >= 1;
    }

    static /* synthetic */ RectF[] access$402(VideoCaptureCamera2 videoCaptureCamera2, RectF[] rectFArray) {
        videoCaptureCamera2.rectArray = rectFArray;
        return rectFArray;
    }

    static /* synthetic */ int[] access$502(VideoCaptureCamera2 videoCaptureCamera2, int[] nArray) {
        videoCaptureCamera2.distanceArray = nArray;
        return nArray;
    }

    static /* synthetic */ MeteringRectangle[] access$602(VideoCaptureCamera2 videoCaptureCamera2, MeteringRectangle[] meteringRectangleArray) {
        videoCaptureCamera2.mAFAERegions = meteringRectangleArray;
        return meteringRectangleArray;
    }

    static /* synthetic */ Object access$2000(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCameraStateLock;
    }

    static /* synthetic */ byte[] access$2100(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCaptureData;
    }

    static /* synthetic */ void access$2200(Image image, byte[] byArray) {
        VideoCaptureCamera2.readImageIntoBuffer(image, byArray);
    }

    static /* synthetic */ int access$2300(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mExpectedFrameSize;
    }

    private class ImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private ImageReaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onImageAvailable(ImageReader var1_1) {
            block17: {
                block16: {
                    var2_2 = null;
                    var3_3 = VideoCaptureCamera2.access$2000(VideoCaptureCamera2.this);
                    // MONITORENTER : var3_3
                    if (VideoCaptureCamera2.access$000(VideoCaptureCamera2.this) != CameraState.STARTED || var1_1 == null) {
                        // MONITOREXIT : var3_3
                        return;
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 40->51)] { 
lbl-1000:
                    // 1 sources

                    {
                        var2_2 = var1_1.acquireLatestImage();
                        if (var2_2 != null) break block16;
                        // MONITOREXIT : var3_3
                        if (var2_2 == null) return;
                    }
                    var2_2.close();
                    return;
                }
                try {
                    if (var2_2.getFormat() == 35 && var2_2.getPlanes().length == 3) break block17;
                    Logging.e("CAMERA2", "Unexpected image format: " + var2_2.getFormat() + "or #planes:" + var2_2.getPlanes().length);
                    // MONITOREXIT : var3_3
                    if (var2_2 == null) return;
                }
lbl21:
                // 4 sources

                catch (IllegalStateException var3_4) {
                    Logging.e("CAMERA2", "acquireLastest Image():", var3_4);
                    return;
                }
                var2_2.close();
                return;
            }
            if (var1_1.getWidth() != var2_2.getWidth()) throw new IllegalStateException("ImageReader size " + var1_1.getWidth() + "x" + var1_1.getHeight() + " did not match Image size: " + var2_2.getWidth() + "x" + var2_2.getHeight());
            if (var1_1.getHeight() != var2_2.getHeight()) {
                throw new IllegalStateException("ImageReader size " + var1_1.getWidth() + "x" + var1_1.getHeight() + " did not match Image size: " + var2_2.getWidth() + "x" + var2_2.getHeight());
            }
            VideoCaptureCamera2.access$2200(var2_2, VideoCaptureCamera2.access$2100(VideoCaptureCamera2.this));
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.ProvideCameraFrame(VideoCaptureCamera2.access$2100(VideoCaptureCamera2.this), VideoCaptureCamera2.access$2300(VideoCaptureCamera2.this), VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid);
            } else {
                Logging.w("CAMERA2", "warning mNativeVideoCaptureDeviceAndroid = 0, error");
            }
            // MONITOREXIT : var3_3
            if (var2_2 == null) return;
            var2_2.close();
            return;
            finally {
                if (var2_2 != null) {
                    var2_2.close();
                }
            }
        }
    }

    private class CaptureSessionListener
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionListener() {
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mCaptureSession = cameraCaptureSession;
            if (VideoCaptureCamera2.this.createCaptureRequest() != 0) {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Fail to setup capture session");
                }
            } else {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STARTED);
            }
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Logging.e(VideoCaptureCamera2.TAG, "onConfigureFailed");
            if (VideoCaptureCamera2.this.mCameraState != CameraState.EVICTED) {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            }
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera session configuration error");
            }
        }
    }

    private class CrStateListener
    extends CameraDevice.StateCallback {
        private CrStateListener() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mCameraDevice = cameraDevice;
            if (VideoCaptureCamera2.this.doStartCapture() < 0) {
                VideoCaptureCamera2.this.doStopCapture();
                if (VideoCaptureCamera2.this.mCameraState != CameraState.EVICTED) {
                    VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                }
                Logging.e(VideoCaptureCamera2.TAG, "Camera startCapture failed!!");
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Error configuring camera");
                }
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            if (VideoCaptureCamera2.this.mCameraState != CameraState.STOPPED) {
                Logging.w(VideoCaptureCamera2.TAG, "camera client is evicted by other application");
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera device evicted by other application");
                }
                Logging.i(VideoCaptureCamera2.TAG, "Camera device enter state: EVICTED");
                if (VideoCaptureCamera2.this.mCameraDevice != null) {
                    VideoCaptureCamera2.this.mCameraDevice.close();
                    VideoCaptureCamera2.this.mCameraDevice = null;
                }
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.EVICTED);
                return;
            }
        }

        public void onError(CameraDevice cameraDevice, int n2) {
            if (VideoCaptureCamera2.this.mCameraState == CameraState.EVICTED) {
                return;
            }
            if (VideoCaptureCamera2.this.mCameraDevice != null) {
                VideoCaptureCamera2.this.mCameraDevice.close();
                VideoCaptureCamera2.this.mCameraDevice = null;
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            Logging.e(VideoCaptureCamera2.TAG, "CameraDevice Error :" + Integer.toString(n2));
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera device error" + Integer.toString(n2));
            }
        }
    }

    private static enum CameraState {
        OPENING,
        STARTED,
        EVICTED,
        STOPPED;

    }
}

