/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.RectF;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import io.agora.rtc.internal.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class VideoCapture {
    private static final int kVideoI420 = 0;
    private static final int kVideoYV12 = 1;
    private static final int kVideoYUY2 = 2;
    private static final int kVideoNV12 = 11;
    private static final int kVideoNV21 = 12;
    private static final int kVideoUnknown = 99;
    protected int mCameraNativeOrientation;
    protected final Context mContext;
    protected final int mId;
    protected long mNativeVideoCaptureDeviceAndroid;
    private int mLastRotation = -1;
    protected int mPQFirst = -1;
    public static final int kCaptureFpsUnknown = -1;
    public static final int kCaptureFpsDefault = 0;
    public static final int kCaptureFpsLowPower = 1;

    VideoCapture(Context context, int n2, long l2, int n3) {
        this.mContext = context;
        this.mId = n2;
        this.mNativeVideoCaptureDeviceAndroid = l2;
        this.mPQFirst = n3;
    }

    public abstract int allocate();

    public abstract int setCaptureFormat(int var1);

    public abstract int startCapture(int var1, int var2, int var3);

    public abstract int stopCapture();

    public abstract boolean isTorchSupported();

    public abstract boolean isFocusSupported();

    public abstract boolean isZoomSupported();

    public abstract boolean isAutoFaceFocusSupported();

    public abstract int setZoom(float var1);

    public abstract float getMaxZoom();

    public abstract int setTorchMode(boolean var1);

    public abstract int setFocus(float var1, float var2, boolean var3);

    public abstract int setAutoFaceFocus(boolean var1);

    public abstract int setFaceDetection(boolean var1);

    public abstract boolean isExposureSupported();

    public abstract int setExposure(float var1, float var2, boolean var3);

    public abstract int UnRegisterNativeHandle();

    public abstract void deallocate();

    public native void ProvideCameraFrame(byte[] var1, int var2, long var3);

    public native void ProvideCameraTexture(byte[] var1, int var2, long var3);

    public native boolean isAutoFaceFocusEnabled(long var1);

    public native boolean isFaceDetectionEnabled(long var1);

    public native void NotifyCameraFocusAreaChanged(float var1, float var2, float var3, float var4, long var5);

    public native void NotifyCameraExposureAreaChanged(float var1, float var2, float var3, float var4, long var5);

    public native void NotifyFaceDetection(int var1, int var2, RectF[] var3, long var4, long var6);

    public native void onCameraError(long var1, String var3);

    public static String fetchCapability(int n2, Context context, String string) {
        String string2 = "CamCaps2";
        SharedPreferences sharedPreferences = context.getSharedPreferences(string2, 0);
        String string3 = sharedPreferences.getString("CaptureName", null);
        if (string3 == null || !string3.equals(string)) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.clear();
            editor.commit();
            return null;
        }
        return sharedPreferences.getString("Cam_" + n2, null);
    }

    public static void clearCapabilityCache(Context context) {
        String string = "CamCaps2";
        SharedPreferences sharedPreferences = context.getSharedPreferences(string, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear().commit();
    }

    public static void cacheCapability(int n2, Context context, String string, String string2) {
        String string3 = "CamCaps2";
        SharedPreferences sharedPreferences = context.getSharedPreferences(string3, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("Cam_" + n2, string);
        editor.putString("CaptureName", string2);
        editor.commit();
    }

    public static int translateToEngineFormat(int n2) {
        switch (n2) {
            case 17: {
                return 12;
            }
            case 842094169: {
                return 1;
            }
            case 35: {
                return 0;
            }
            case 20: {
                return 2;
            }
        }
        return 99;
    }

    public static int translateToAndroidFormat(int n2) {
        switch (n2) {
            case 12: {
                return 17;
            }
            case 1: {
                return 842094169;
            }
            case 0: {
                return 35;
            }
            case 2: {
                return 20;
            }
        }
        return 0;
    }

    public static boolean isEmulator() {
        if ("nokia".equalsIgnoreCase(Build.MANUFACTURER) && ("Nokia_N1".equalsIgnoreCase(Build.DEVICE) || "N1".equalsIgnoreCase(Build.MODEL))) {
            return false;
        }
        String string = "";
        try {
            String[] stringArray = new String[]{"/system/bin/cat", "/proc/cpuinfo"};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            bufferedReader.close();
            string = stringBuffer.toString().toLowerCase();
        }
        catch (IOException iOException) {
            return false;
        }
        return string.contains("intel") || string.contains("amd");
    }

    private int checkOrientation() {
        Display display;
        if (this.mContext != null && this.mContext.getSystemService("window") != null && (display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay()) != null) {
            try {
                int n2 = display.getRotation();
                return n2;
            }
            catch (RuntimeException runtimeException) {
                Logging.e("VideoCapture", "video capture checkOrientation display getRotation throwout exception");
                return this.mLastRotation;
            }
        }
        return this.mLastRotation;
    }
}

