/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Process;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import io.agora.rtc.internal.Logging;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ViESurfaceRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "ViESurfaceRenderer";
    private Bitmap bitmap = null;
    private ByteBuffer byteBuffer = null;
    private SurfaceHolder surfaceHolder;
    private Rect source = new Rect();
    private Rect dest = new Rect();
    private float topScale = 0.0f;
    private float bottomScale = 1.0f;
    private float leftScale = 0.0f;
    private float rightScale = 1.0f;

    public ViESurfaceRenderer(SurfaceView surfaceView) {
        Logging.i(TAG, "surface view " + surfaceView);
        this.surfaceHolder = surfaceView.getHolder();
        if (this.surfaceHolder == null) {
            return;
        }
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.surfaceCreated(this.surfaceHolder);
    }

    private void changeDestRect(int n2, int n3) {
        this.dest.right = (int)((float)this.dest.left + Math.abs(this.leftScale - this.rightScale) * (float)n2);
        this.dest.bottom = (int)((float)this.dest.top + Math.abs(this.topScale - this.bottomScale) * (float)n3);
        Logging.i(TAG, "ViESurfaceRender::surfaceChanged in_width:" + n2 + " in_height:" + n3 + " source.left:" + this.source.left + " source.top:" + this.source.top + " source.dest:" + this.source.right + " source.bottom:" + this.source.bottom + " dest.left:" + this.dest.left + " dest.top:" + this.dest.top + " dest.dest:" + this.dest.right + " dest.bottom:" + this.dest.bottom + " dest scale " + this.rightScale + " bottom scale " + this.bottomScale);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        this.changeDestRect(n3, n4);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            Rect rect = this.surfaceHolder.getSurfaceFrame();
            if (rect != null) {
                this.changeDestRect(rect.right - rect.left, rect.bottom - rect.top);
                Logging.i(TAG, "ViESurfaceRender::surfaceCreated dst.left:" + rect.left + " dst.top:" + rect.top + " dst.dest:" + rect.right + " dst.bottom:" + rect.bottom + " source.left:" + this.source.left + " source.top:" + this.source.top + " source.dest:" + this.source.right + " source.bottom:" + this.source.bottom + " dest.left:" + this.dest.left + " dest.top:" + this.dest.top + " dest.dest:" + this.dest.right + " dest.bottom:" + this.dest.bottom);
            }
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Logging.d(TAG, "ViESurfaceRenderer::surfaceDestroyed");
        this.bitmap = null;
        this.byteBuffer = null;
    }

    public Bitmap CreateBitmap(int n2, int n3) {
        Logging.d(TAG, "CreateByteBitmap " + n2 + ":" + n3);
        if (this.bitmap == null) {
            try {
                Process.setThreadPriority((int)-4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.changeDestRect(n2, n3);
        this.bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.RGB_565);
        this.source.left = 0;
        this.source.top = 0;
        this.source.bottom = n3;
        this.source.right = n2;
        return this.bitmap;
    }

    public ByteBuffer CreateByteBuffer(int n2, int n3) {
        Logging.i(TAG, "CreateByteBuffer " + n2 + " * " + n3);
        this.bitmap = this.CreateBitmap(n2, n3);
        this.byteBuffer = ByteBuffer.allocateDirect(n2 * n3 * 2);
        return this.byteBuffer;
    }

    public void SetCoordinates(float f2, float f3, float f4, float f5) {
        Logging.i(TAG, "SetCoordinates " + f2 + "," + f3 + " : " + f4 + "," + f5);
        this.leftScale = f2;
        this.topScale = f3;
        this.rightScale = f4;
        this.bottomScale = f5;
    }

    private void saveBitmapToJPEG(int n2, int n3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.format("/sdcard/render_%d.jpg", System.currentTimeMillis()));
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.flush();
            fileOutputStream.close();
            Logging.i(TAG, "saved jpg " + fileOutputStream.toString());
        }
        catch (IOException iOException) {
            Logging.e(TAG, "save jpg failed", iOException);
        }
    }

    public void DrawByteBuffer() {
        if (this.byteBuffer == null) {
            Logging.w(TAG, "DrawByteBuffer null");
            return;
        }
        this.byteBuffer.rewind();
        this.bitmap.copyPixelsFromBuffer((Buffer)this.byteBuffer);
        this.DrawBitmap();
    }

    public void DrawBitmap() {
        if (this.bitmap == null) {
            return;
        }
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            canvas.drawBitmap(this.bitmap, this.source, this.dest, null);
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }
}

