/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import io.agora.rtc.internal.Logging;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;

public class MediaCodecAudioEncoder {
    private MediaCodec mMediaCodec = null;
    private MediaFormat mTrackFormat = null;
    private String mCodecString = null;
    private File outputFile = null;
    private BufferedOutputStream outputStream = null;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private MediaCodec mAACEncoder = null;
    private MediaFormat mAACFormat = null;
    private ByteBuffer[] mAACInputBuffers;
    private ByteBuffer[] mAACOutputBuffers;
    private ByteBuffer mAACEncodedBuffer = ByteBuffer.allocateDirect(1024);
    private String TAG = "MediaCodec Audio Encoder";

    public boolean createStreaming(String string, int n2, int n3, int n4) {
        try {
            Logging.i(this.TAG, "Recording aac with fs = " + n2 + ", ch = " + n3 + ", quality = " + n4);
            String string2 = string.substring(string.length() - 3);
            if (string2.equalsIgnoreCase("3gp") || string2.equalsIgnoreCase("amr")) {
                if (n2 == 8000) {
                    this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/3gpp");
                    this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/3gpp", (int)n2, (int)n3);
                    this.mTrackFormat.setInteger("bitrate", 12200);
                    this.mCodecString = "audio/3gpp";
                } else if (n2 == 16000) {
                    this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/amr-wb");
                    this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/amr-wb", (int)n2, (int)n3);
                    this.mTrackFormat.setInteger("bitrate", 23850);
                    this.mCodecString = "audio/amr-wb";
                }
            } else if (string2.equalsIgnoreCase("aac")) {
                int n5 = 50000;
                switch (n4) {
                    case 0: {
                        n5 = 16000;
                        break;
                    }
                    case 1: {
                        n5 = 25000;
                        break;
                    }
                    default: {
                        n5 = 50000;
                    }
                }
                this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
                this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)n3);
                int[] nArray = new int[]{2, 5, 39};
                this.mTrackFormat.setInteger("aac-profile", 2);
                this.mTrackFormat.setInteger("sample-rate", n2);
                this.mTrackFormat.setInteger("channel-count", n3);
                this.mTrackFormat.setInteger("bitrate", n5);
                this.mCodecString = "audio/mp4a-latm";
            } else {
                return false;
            }
            this.mMediaCodec.configure(this.mTrackFormat, null, null, 1);
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            this.outputFile = new File(string);
            this.touch(this.outputFile);
            try {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputFile));
                Logging.i(this.TAG, "outputStream initialized");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.mCodecString == "audio/3gpp") {
                byte[] byArray = new byte[]{35, 33, 65, 77, 82, 10};
                this.outputStream.write(byArray);
            } else if (this.mCodecString == "audio/amr-wb") {
                byte[] byArray = new byte[]{35, 33, 65, 77, 82, 45, 87, 66, 10};
                this.outputStream.write(byArray);
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when creating aac file encoder");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void setChannelCount(int n2) {
        try {
            this.mTrackFormat.setInteger("channel-count", n2);
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when setting aac file encoder channel count");
            exception.printStackTrace();
        }
    }

    public void setSampleRate(int n2) {
        try {
            this.mTrackFormat.setInteger("sample-rate", n2);
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when setting aac file encoder sample rate");
            exception.printStackTrace();
        }
    }

    public void releaseStreaming() {
        try {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when releasing aac file encoder");
            exception.printStackTrace();
        }
    }

    public void encodeFrame(byte[] byArray) {
        try {
            Object object;
            int n2 = this.mMediaCodec.dequeueInputBuffer(2000L);
            if (n2 != -1) {
                if (Build.VERSION.SDK_INT >= 21) {
                    object = this.mMediaCodec.getInputBuffer(n2);
                } else {
                    this.mInputBuffers = this.mMediaCodec.getInputBuffers();
                    object = this.mInputBuffers[n2];
                }
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray);
                this.mMediaCodec.queueInputBuffer(n2, 0, byArray.length, 0L, 0);
            }
            object = new MediaCodec.BufferInfo();
            int n3 = this.mMediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)object, 0L);
            while (n3 >= 0) {
                byte[] byArray2;
                ByteBuffer byteBuffer;
                int n4 = ((MediaCodec.BufferInfo)object).size;
                if (Build.VERSION.SDK_INT >= 21) {
                    byteBuffer = this.mMediaCodec.getOutputBuffer(n3);
                } else {
                    this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                    byteBuffer = this.mOutputBuffers[n3];
                }
                byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                byteBuffer.limit(((MediaCodec.BufferInfo)object).offset + n4);
                if (this.mCodecString == "audio/mp4a-latm") {
                    int n5 = n4 + 7;
                    byArray2 = new byte[n5];
                    this.addADTStoPacket(byArray2, n5);
                    byteBuffer.get(byArray2, 7, n4);
                    byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                    this.outputStream.write(byArray2, 0, byArray2.length);
                } else if (this.mCodecString == "audio/3gpp" || this.mCodecString == "audio/amr-wb") {
                    byArray2 = new byte[n4];
                    byteBuffer.get(byArray2, 0, n4);
                    byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                    this.outputStream.write(byArray2, 0, byArray2.length);
                }
                this.mMediaCodec.releaseOutputBuffer(n3, false);
                n3 = this.mMediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)object, 0L);
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when encoding aac file");
            exception.printStackTrace();
        }
    }

    private void addADTStoPacket(byte[] byArray, int n2) {
        int n3 = 2;
        int n4 = 5;
        int n5 = 1;
        byArray[0] = -1;
        byArray[1] = -7;
        byArray[2] = (byte)((n3 - 1 << 6) + (n4 << 2) + (n5 >> 2));
        byArray[3] = (byte)(((n5 & 3) << 6) + (n2 >> 11));
        byArray[4] = (byte)((n2 & 0x7FF) >> 3);
        byArray[5] = (byte)(((n2 & 7) << 5) + 31);
        byArray[6] = -4;
    }

    private void touch(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean createAACStreaming(int n2, int n3, int n4) {
        try {
            Logging.i(this.TAG, "Encoding aac with fs = " + n2 + ", bitrate = " + n4);
            this.mAACEncoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
            this.mAACFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)n3);
            int[] nArray = new int[]{2, 5, 39};
            this.mAACFormat.setInteger("aac-profile", 2);
            this.mAACFormat.setInteger("sample-rate", n2);
            this.mAACFormat.setInteger("channel-count", n3);
            this.mAACFormat.setInteger("bitrate", n4);
            this.mAACEncoder.configure(this.mAACFormat, null, null, 1);
            if (this.mAACEncoder != null) {
                this.mAACEncoder.start();
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when creating aac encode stream");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean setAACEncodeBitrate(int n2) {
        Logging.w(this.TAG, "Set hw aac bitrate = " + n2);
        try {
            if (this.mAACEncoder != null) {
                this.mAACEncoder.stop();
                this.mAACFormat.setInteger("bitrate", n2);
                this.mAACEncoder.configure(this.mAACFormat, null, null, 1);
                this.mAACEncoder.start();
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when setting aac encode bitrate");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void releaseAACStreaming() {
        try {
            if (this.mAACEncoder != null) {
                this.mAACEncoder.stop();
                this.mAACEncoder.release();
                this.mAACEncoder = null;
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when releasing aac encode stream");
            exception.printStackTrace();
        }
    }

    public int encodeAACFrame(byte[] byArray) {
        int n2 = 0;
        try {
            int n3;
            Object object;
            int n4 = this.mAACEncoder.dequeueInputBuffer(2000L);
            if (n4 != -1) {
                if (Build.VERSION.SDK_INT >= 21) {
                    object = this.mAACEncoder.getInputBuffer(n4);
                } else {
                    this.mAACInputBuffers = this.mAACEncoder.getInputBuffers();
                    object = this.mAACInputBuffers[n4];
                }
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray);
                this.mAACEncoder.queueInputBuffer(n4, 0, byArray.length, 0L, 0);
            }
            if ((n3 = this.mAACEncoder.dequeueOutputBuffer((MediaCodec.BufferInfo)(object = new MediaCodec.BufferInfo()), 0L)) >= 0) {
                ByteBuffer byteBuffer;
                int n5 = ((MediaCodec.BufferInfo)object).size;
                if (Build.VERSION.SDK_INT >= 21) {
                    byteBuffer = this.mAACEncoder.getOutputBuffer(n3);
                } else {
                    this.mAACOutputBuffers = this.mAACEncoder.getOutputBuffers();
                    byteBuffer = this.mAACOutputBuffers[n3];
                }
                n2 = (((MediaCodec.BufferInfo)object).flags & 2) == 2 ? 0 : ((MediaCodec.BufferInfo)object).size;
                byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                byteBuffer.limit(((MediaCodec.BufferInfo)object).offset + n5);
                this.mAACEncodedBuffer.position(0);
                this.mAACEncodedBuffer.put(byteBuffer);
                this.mAACEncoder.releaseOutputBuffer(n3, false);
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when encoding aac stream");
            exception.printStackTrace();
        }
        return n2;
    }
}

