/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.VideoCapture;
import io.agora.rtc.video.VideoCaptureCamera;
import io.agora.rtc.video.VideoCaptureCamera2;

public class VideoCaptureFactory {
    private static final String TAG = "CAM-FACTORY";

    private static boolean isLReleaseOrLater() {
        if ("ocean".equalsIgnoreCase(Build.DEVICE) && "oe106".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("trident".equalsIgnoreCase(Build.DEVICE) && "de106".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("shark".equalsIgnoreCase(Build.DEVICE) && "skr-a0".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("hnnem-h".equalsIgnoreCase(Build.DEVICE)) {
            return false;
        }
        if ("on7xelte".equals(Build.DEVICE) && "SM-G610F".equals(Build.MODEL)) {
            return false;
        }
        if ("m2c".equals(Build.DEVICE) || "M578CA".equals(Build.MODEL)) {
            return false;
        }
        if ("samsung".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && (Build.MODEL.contains("SM-G930") || Build.MODEL.contains("SM-G935") || Build.MODEL.contains("SM-G950") || Build.MODEL.contains("SM-G955") || "SC-02H".equals(Build.MODEL) || "SCV33".equals(Build.MODEL) || "SC-02J".equals(Build.MODEL) || "SCV36".equals(Build.MODEL) || "SM-G892A".equals(Build.MODEL) || "SM-G892U".equals(Build.MODEL) || "SC-03J".equals(Build.MODEL) || "SCV35".equals(Build.MODEL))) {
            return false;
        }
        if ("oneplus".equalsIgnoreCase(Build.MANUFACTURER)) {
            return false;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    public static VideoCapture createVideoCapture(int n2, Context context, long l2) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(context, n2)) {
            return new VideoCaptureCamera2(context, n2, l2);
        }
        return new VideoCaptureCamera(context, n2, l2);
    }

    public static int getNumberOfCameras(Context context) {
        return AndroidCameraInfo.getNumberOfCameras(context);
    }

    public static String getDeviceName(int n2, Context context) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(context, n2)) {
            return VideoCaptureCamera2.getName(n2, context);
        }
        return VideoCaptureCamera.getName(n2);
    }

    public static int getDeviceOrientation(int n2, Context context) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(context, n2)) {
            return VideoCaptureCamera2.getSensorOrientation(n2, context);
        }
        return VideoCaptureCamera.getSensorOrientation(n2);
    }

    public static String getCapabilities(int n2, Context context) {
        String string = null;
        string = VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(context, n2) ? VideoCapture.fetchCapability(n2, context, VideoCaptureCamera2.getCaptureName()) : VideoCapture.fetchCapability(n2, context, VideoCaptureCamera.getCaptureName());
        if (string == null) {
            Logging.e(TAG, "Capability hasn't been created");
        } else {
            VideoCaptureFactory.printCameraInfo(string);
        }
        return string;
    }

    public static int printCameraInfo(String string) {
        int n2 = 150;
        int n3 = string.length() / n2 + 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            try {
                String string2 = "lines = " + n3 + ":";
                string2 = i2 == n3 - 1 ? string2 + string.substring(i2 * n2, string.length()) : string2 + string.substring(i2 * n2, (i2 + 1) * n2);
                Logging.d("CameraInfo", string2);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
        }
        return 0;
    }

    static class AndroidCameraInfo {
        private static int sNumberOfSystemCameras = -1;

        AndroidCameraInfo() {
        }

        private static int getNumberOfCameras(Context context) {
            if (sNumberOfSystemCameras == -1) {
                if (Build.VERSION.SDK_INT < 23 && context.getPackageManager().checkPermission("android.permission.CAMERA", context.getPackageName()) != 0) {
                    sNumberOfSystemCameras = 0;
                    Log.e((String)VideoCaptureFactory.TAG, (String)"Missing android.permission.CAMERA permission, no system camera available");
                } else {
                    sNumberOfSystemCameras = 0;
                    if (VideoCaptureFactory.isLReleaseOrLater()) {
                        sNumberOfSystemCameras = VideoCaptureCamera2.getNumberOfCameras(context);
                    }
                    if (sNumberOfSystemCameras == 0) {
                        sNumberOfSystemCameras = VideoCaptureCamera.getNumberOfCameras();
                    }
                }
            }
            return sNumberOfSystemCameras;
        }
    }
}

