/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Range;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.EglBase10;
import io.agora.rtc.gl.EglBase14;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGLContext;

@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final boolean ENABLE_VERBOSE_LOG = false;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 3000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static MediaCodecVideoEncoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static String codecOmxName = null;
    private static Set<String> hwEncoderDisabledTypes = new HashSet<String>();
    private MediaCodec mediaCodec;
    @Deprecated
    private ByteBuffer[] outputBuffers;
    private EglBase eglBase;
    private int width;
    private int height;
    private Surface inputSurface;
    private GlRectDrawer drawer;
    private final Matrix rotateMatrix = new Matrix();
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String H265_MIME_TYPE = "video/hevc";
    private long nativeHandle;
    private boolean useAsyncMode = false;
    private MediaCodecEncoderCallback asyncEncoderCallback;
    private HandlerThread asyncHandlerThread;
    private Handler asyncEncoderHandler;
    private boolean isInitialized = false;
    private final Object inputBufferLock = new Object();
    private final LinkedHashSet<Integer> availableInputIndexes = new LinkedHashSet();
    private static final String[] supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Intel."};
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom."};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.MTK.", "OMX.IMG.TOPAZ.", "OMX.hisi.", "OMX.k3.", "OMX.amlogic.", "OMX.rk.", "OMX.MS."};
    private static final String[] H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060"};
    private static final String[] H264_HW_QCOM_EXCEPTION_MODELS = new String[]{"mi note lte", "redmi note 4x", "1605-a01", "aosp on hammerhead", "lm-x210", "oppo r9s"};
    private static final String[] MTK_NO_ADJUSTMENT_MODELS = new String[]{"vivo y83a", "vivo x21i", "vivo X21i A"};
    private static final String[] INTERVAL_HW_EXCEPTION_MODELS = new String[]{"vivo X21A"};
    private static final int INT_SETTING_INTERVAL_VALUE = 10;
    private static final int INT_INTERVAL_UPPER_LIMIT = 100;
    private static final int VIDEO_ControlRateVariable = 1;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
    private static final int[] supportedSurfaceColorList = new int[]{2130708361};
    private VideoCodecType type;
    private ByteBuffer configData = null;
    private long lastKeyFrameTimeMs = 0L;
    private int keyFrameIntervalInMsec = 0;
    private long lastResetForQcomTimeMs = 0L;
    private int converted_bps;
    private int lastSetFps;
    private boolean qcomExceptionModel = false;
    private static final int BASE_FRAME_RATE_FOR_MTK = 30;
    private static final int BASE_FRAME_RATE_FOR_EXYNOS = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_TOPAZ = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_HISI = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_K3 = 30;
    private static final int BASE_FRAME_RATE_FOR_AMLOGIC = 30;
    private static final int KBPS_TO_BPS_FACTOR = 900;
    private static final int KBPS_TO_BPS_FACTOR_QCOM = 950;
    private String codecName;
    private int colorFormat;
    private int profile = 66;
    private int supportCodecs = 0;
    private int maxSupportedWidth = 32768;
    private int maxSupportedHeight = 32768;
    private int minSupportedWidth = 2;
    private int minSupportedHeight = 2;
    private int maxSupportedBitrate = 0;
    private int minSupportedBitrate = 0;
    private int widthAlignment = 16;
    private int heightAlignment = 4;
    private int memoryType = 0;
    private int bitrateMode = 2;
    private int bitrateAdjustmentType;
    private int SDKVer;
    private String deviceModel;
    private String cpuModel;
    private static int mWidthAlign = 16;
    private static int mHeightAlign = 4;
    private int settingCodecParameterForExynos = -1;
    private ChipProperties chipProperties = null;
    private FileOutputStream fos = null;

    public static boolean isAsyncModeSupported() {
        return false;
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isH264HwSupported() {
        try {
            return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedColorList) != null;
        }
        catch (Exception exception) {
            Logging.e(TAG, "isH264HwSupported failed!");
            return false;
        }
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        try {
            return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedSurfaceColorList) != null;
        }
        catch (Exception exception) {
            Logging.e(TAG, "isH264HwSupportedUsingTextures failed!");
            return false;
        }
    }

    public static boolean isQcomHWEncoder() {
        if (codecOmxName != null && !codecOmxName.startsWith("OMX.qcom.")) {
            Logging.i(TAG, "Qualcomm HW encoder false");
            return false;
        }
        Logging.i(TAG, "Qualcomm HW encoder true");
        return true;
    }

    private static boolean isA50OrHigher() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static int getWidthAlign() {
        return mWidthAlign;
    }

    public static int getHeightAlign() {
        return mHeightAlign;
    }

    private static EncoderProperties findHwEncoder(String string, String[] stringArray, int[] nArray) {
        try {
            return MediaCodecVideoEncoder.do_findHwEncoder(string, stringArray, nArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static EncoderProperties do_findHwEncoder(String string, String[] codecCapabilities, int[] nArray) {
        List<String> list;
        boolean bl;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        boolean bl2 = bl = nArray[0] == 2130708361;
        if (string.equals(H264_MIME_TYPE) && (list = Arrays.asList(H264_HW_EXCEPTION_MODELS)).contains(Build.MODEL)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return null;
        }
        Logging.i(TAG, "Model: " + Build.MODEL);
        Logging.i(TAG, "hardware: " + Build.HARDWARE);
        if (Build.HARDWARE.equalsIgnoreCase("kirin970") && !bl) {
            return null;
        }
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            String string2 = null;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (!string3.equals(string)) continue;
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            if (!MediaCodecVideoEncoder.checkMinSDKVersion(string2, bl)) {
                Logging.e(TAG, "Check min sdk version failed, " + string2);
                continue;
            }
            Logging.i(TAG, "Found candidate encoder " + string2);
            boolean bl3 = false;
            for (String string4 : codecCapabilities) {
                if (!string2.startsWith(string4)) continue;
                bl3 = true;
                break;
            }
            if (!bl3 && !bl) continue;
            codecOmxName = string2;
            if (string2.startsWith("OMX.amlogic.")) {
                if (bl) {
                    return new EncoderProperties(string2, 2130708361, true);
                }
                return new EncoderProperties(string2, 19, true);
            }
            MediaCodecInfo.CodecCapabilities codecCapabilities2 = mediaCodecInfo.getCapabilitiesForType(string);
            if (MediaCodecVideoEncoder.isA50OrHigher()) {
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities2.getVideoCapabilities();
                mWidthAlign = videoCapabilities.getWidthAlignment();
                mHeightAlign = videoCapabilities.getHeightAlignment();
                Logging.w(TAG, "alignment:" + mWidthAlign + "x" + mHeightAlign);
            }
            int n2 = 0;
            for (int n3 : codecCapabilities2.colorFormats) {
                if (21 == n3) {
                    n2 = 1;
                }
                Logging.d(TAG, "   Color: 0x" + Integer.toHexString(n3));
            }
            for (int n3 : nArray) {
                for (int n4 : codecCapabilities2.colorFormats) {
                    if (n4 != n3) continue;
                    if (n4 == 19 && n2 == 1 && (string2.startsWith("OMX.IMG.TOPAZ.") || string2.startsWith("OMX.hisi.") || string2.startsWith("OMX.k3."))) {
                        Logging.i(TAG, "TOPAZ,force use COLOR_FormatYUV420SemiPlanar");
                        Logging.i(TAG, "Found target encoder for mime " + string + " : " + string2 + ". Color: 0x" + Integer.toHexString(21));
                        return new EncoderProperties(string2, 21, bl3);
                    }
                    Logging.i(TAG, "Found target encoder for mime " + string + " : " + string2 + ". Color: 0x" + Integer.toHexString(n4));
                    return new EncoderProperties(string2, n4, bl3);
                }
            }
        }
        return null;
    }

    private void getEncoderProperties(int n2) {
        String[] stringArray = new String[]{VP8_MIME_TYPE, VP9_MIME_TYPE, H264_MIME_TYPE, H265_MIME_TYPE};
        String string = null;
        this.supportCodecs = 0;
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                if (string2.equals(VP8_MIME_TYPE)) {
                    this.supportCodecs |= 1;
                } else if (string2.equals(H264_MIME_TYPE)) {
                    this.supportCodecs |= 2;
                } else if (string2.equals(H265_MIME_TYPE)) {
                    this.supportCodecs |= 4;
                }
                if (string != null || !string2.equals(stringArray[n2])) continue;
                string = mediaCodecInfo.getName();
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(stringArray[n2]);
                if (!MediaCodecVideoEncoder.isA50OrHigher()) continue;
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                Range range = videoCapabilities.getSupportedWidths();
                Range range2 = videoCapabilities.getSupportedHeights();
                this.maxSupportedWidth = (Integer)range.getUpper();
                this.maxSupportedHeight = (Integer)range2.getUpper();
                this.minSupportedWidth = (Integer)range.getLower();
                this.minSupportedHeight = (Integer)range2.getLower();
                this.widthAlignment = videoCapabilities.getWidthAlignment();
                this.heightAlignment = videoCapabilities.getHeightAlignment();
                Range range3 = videoCapabilities.getBitrateRange();
                this.maxSupportedBitrate = (Integer)range3.getUpper();
                this.minSupportedBitrate = (Integer)range3.getLower();
                Logging.i(TAG, "max supported size:" + this.maxSupportedWidth + "x" + this.maxSupportedHeight + " min supported size:" + this.minSupportedWidth + "x" + this.minSupportedHeight + " align size: " + this.widthAlignment + "x" + this.heightAlignment + " bitrate range: " + this.maxSupportedBitrate + " -> " + this.minSupportedBitrate);
            }
        }
        this.SDKVer = Build.VERSION.SDK_INT;
        this.deviceModel = Build.MODEL;
        this.cpuModel = Build.HARDWARE;
    }

    static MediaCodec createByCodecName(String string) {
        try {
            return MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            Logging.e(TAG, "create media encoder failed, ", exception);
            return null;
        }
    }

    void nativeCreate(long l2) {
        this.nativeHandle = l2;
        Logging.i(TAG, "nativeCreate handle: " + l2);
    }

    void nativeDestroy() {
        Logging.i(TAG, "nativeDestroy");
        if (this.asyncHandlerThread != null) {
            this.asyncHandlerThread.quit();
            this.asyncHandlerThread = null;
        }
        this.asyncEncoderHandler = null;
        this.nativeHandle = 0L;
    }

    private boolean isOnAsyncHandlerThread() {
        return this.asyncHandlerThread != null && this.asyncHandlerThread.getId() == Thread.currentThread().getId();
    }

    boolean initEncoder(final InitParameters initParameters) {
        this.useAsyncMode = initParameters.useAsyncMode;
        if (!this.useAsyncMode) {
            Logging.i(TAG, "Init encoder start, in caller thread");
            return this.initEncoderWithRetryIfNeeded(initParameters);
        }
        if (this.asyncHandlerThread == null) {
            this.asyncHandlerThread = new HandlerThread("encoderAsyncHandler");
            this.asyncHandlerThread.start();
        }
        this.asyncEncoderHandler = new Handler(this.asyncHandlerThread.getLooper());
        this.asyncEncoderHandler.post(new Runnable(){

            @Override
            public void run() {
                Logging.i(MediaCodecVideoEncoder.TAG, "Init encoder start, in async thread");
                boolean bl = MediaCodecVideoEncoder.this.initEncoderWithRetryIfNeeded(initParameters);
                MediaCodecVideoEncoder.this.onAsyncInitEncoderResult(MediaCodecVideoEncoder.this.nativeHandle, bl);
            }
        });
        return true;
    }

    private boolean initEncoderWithRetryIfNeeded(InitParameters initParameters) {
        boolean bl = this.initEncoderTask(initParameters);
        if (!bl && initParameters.fallbackToBaselineProfile) {
            initParameters.profile = 66;
            Logging.w(TAG, "Init encoder: retry with baseline profile");
            bl = this.initEncoderTask(initParameters);
        }
        Logging.i(TAG, "Init encoder done: " + (bl ? "success" : "failed"));
        return bl;
    }

    private boolean initEncoderTask(InitParameters initParameters) {
        if (this.isInitialized) {
            Logging.w(TAG, "already initialized!");
            return true;
        }
        try {
            if (!this.createEncoder(initParameters)) {
                Logging.e(TAG, "failed to create hardware encoder!!");
                return false;
            }
            this.initEglForEncoderIfNeeded(initParameters);
            this.mediaCodec.start();
            if (!this.useAsyncMode) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                Logging.d(TAG, "Output buffers: " + this.outputBuffers.length);
            }
            this.isInitialized = true;
            return true;
        }
        catch (Exception exception) {
            Logging.e(TAG, "failed to start hardware encoder,", exception);
            this.release();
            return false;
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean createEncoder(InitParameters initParameters) throws RuntimeException {
        Logging.i(TAG, "Java initEncode: " + initParameters.toString());
        if (initParameters.fps < 1) {
            initParameters.fps = 1;
        }
        if (initParameters.keyInterval < 1) {
            initParameters.keyInterval = 1;
        }
        this.width = initParameters.width;
        this.height = initParameters.height;
        this.lastSetFps = initParameters.fps;
        this.keyFrameIntervalInMsec = initParameters.keyInterval * 1000;
        this.lastKeyFrameTimeMs = 0L;
        this.lastResetForQcomTimeMs = SystemClock.elapsedRealtime();
        this.type = VideoCodecType.values()[initParameters.codec];
        EncoderProperties encoderProperties = null;
        String string = null;
        if (this.type == VideoCodecType.VIDEO_CODEC_VP8) {
            string = VP8_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, initParameters.useSurface() ? supportedSurfaceColorList : supportedColorList);
        } else if (this.type == VideoCodecType.VIDEO_CODEC_VP9) {
            string = VP9_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedH264HwCodecPrefixes, initParameters.useSurface() ? supportedSurfaceColorList : supportedColorList);
        } else if (this.type == VideoCodecType.VIDEO_CODEC_H264) {
            string = H264_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, initParameters.useSurface() ? supportedSurfaceColorList : supportedColorList);
        }
        if (encoderProperties == null) {
            throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)this.type));
        }
        this.colorFormat = encoderProperties.colorFormat;
        this.chipProperties = this.getChipProperties(encoderProperties.codecName, initParameters.fps);
        Logging.i(TAG, "Color format: " + this.colorFormat);
        this.converted_bps = this.convertBitRate(initParameters.bitrateKbps, initParameters.fps);
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)this.width, (int)this.height);
        if (Build.VERSION.SDK_INT >= this.chipProperties.highProfileMinSdkVersion && initParameters.profile == 100) {
            Logging.i(TAG, "Set high profile and level");
            mediaFormat.setInteger("profile", 8);
            mediaFormat.setInteger("level", 512);
        }
        mediaFormat.setInteger("bitrate", this.converted_bps);
        if (encoderProperties.codecName.startsWith("OMX.rk.")) {
            mediaFormat.setInteger("bitrate-mode", 2);
        } else if (!this.qcomExceptionModel) {
            mediaFormat.setInteger("bitrate-mode", 1);
        }
        mediaFormat.setInteger("color-format", encoderProperties.colorFormat);
        if (this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.NO_ADJUSTMENT) {
            mediaFormat.setInteger("frame-rate", initParameters.init_fps);
        } else {
            mediaFormat.setInteger("frame-rate", this.chipProperties.initFrameRate);
        }
        List<String> list = Arrays.asList(INTERVAL_HW_EXCEPTION_MODELS);
        if (list.contains(Build.MODEL) && initParameters.keyInterval >= 100) {
            Logging.i(TAG, "keyInterval: " + initParameters.keyInterval);
            Logging.i(TAG, "Model: " + Build.MODEL + " ,need to modify interval.");
            initParameters.keyInterval = 10;
        }
        if (this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT) {
            mediaFormat.setInteger("i-frame-interval", initParameters.keyInterval);
        } else {
            mediaFormat.setInteger("i-frame-interval", initParameters.keyInterval + 1);
        }
        Logging.d(TAG, "  Format: " + mediaFormat);
        this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(encoderProperties.codecName);
        if (this.mediaCodec == null) {
            throw new RuntimeException("Can not create media encoder");
        }
        if (this.useAsyncMode) {
            this.asyncEncoderCallback = new MediaCodecEncoderCallback();
            this.mediaCodec.setCallback((MediaCodec.Callback)this.asyncEncoderCallback, new Handler(this.asyncHandlerThread.getLooper()));
        }
        this.mediaCodec.configure(mediaFormat, null, null, 1);
        return true;
    }

    private void initEglForEncoderIfNeeded(InitParameters initParameters) {
        if (!initParameters.useSurface()) {
            return;
        }
        if (initParameters.sharedEgl14Context != null) {
            EglBase14.Context context = new EglBase14.Context(initParameters.sharedEgl14Context);
            this.eglBase = new EglBase14(context, EglBase.CONFIG_RECORDABLE);
        } else if (initParameters.sharedEgl10Context != null) {
            EglBase10.Context context = new EglBase10.Context(initParameters.sharedEgl10Context);
            this.eglBase = new EglBase10(context, EglBase.CONFIG_RECORDABLE);
        }
        if (this.eglBase != null) {
            this.inputSurface = this.mediaCodec.createInputSurface();
            this.eglBase.createSurface(this.inputSurface);
            this.drawer = new GlRectDrawer();
        }
    }

    @Deprecated
    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = this.mediaCodec.getInputBuffers();
        Logging.d(TAG, "Input buffers: " + byteBufferArray.length);
        return byteBufferArray;
    }

    boolean encodeBuffer(final boolean bl, final int n2, final int n3, final long l2) {
        if (this.useAsyncMode && !this.isOnAsyncHandlerThread()) {
            if (this.asyncEncoderHandler == null) {
                Logging.e(TAG, "encodeBuffer: null async handler, not initialized?");
                return false;
            }
            this.asyncEncoderHandler.post(new Runnable(){

                @Override
                public void run() {
                    boolean bl2 = MediaCodecVideoEncoder.this.encodeBuffer(bl, n2, n3, l2);
                    if (!bl2) {
                        MediaCodecVideoEncoder.this.onAsyncEncodeFrameResult(MediaCodecVideoEncoder.this.nativeHandle, false, null);
                    }
                }
            });
            return true;
        }
        if (!this.isInitialized) {
            Logging.e(TAG, "encodeBuffer: encoder is not initialized!");
            return false;
        }
        long l3 = SystemClock.elapsedRealtime();
        if (this.lastKeyFrameTimeMs == 0L) {
            this.lastKeyFrameTimeMs = l3;
        }
        try {
            if (bl || this.chipProperties.bitrateAdjustmentType != BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT && l3 - this.lastKeyFrameTimeMs >= (long)this.keyFrameIntervalInMsec) {
                if (bl) {
                    Logging.i(TAG, "Sync frame request");
                }
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                this.mediaCodec.setParameters(bundle);
                this.lastKeyFrameTimeMs = l3;
            }
            this.mediaCodec.queueInputBuffer(n2, 0, n3, l2, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "encodeBuffer failed", illegalStateException);
            return false;
        }
    }

    boolean encodeTexture(final boolean bl, final int n2, final int n3, final float[] fArray, final int n4, final int n5, final int n6, final int n7, final int n8, final long l2) {
        if (this.useAsyncMode && !this.isOnAsyncHandlerThread()) {
            if (this.asyncEncoderHandler == null) {
                Logging.e(TAG, "encodeTexture: null async handler, not initialized?");
                return false;
            }
            this.asyncEncoderHandler.post(new Runnable(){

                @Override
                public void run() {
                    boolean bl2 = MediaCodecVideoEncoder.this.encodeTexture(bl, n2, n3, fArray, n4, n5, n6, n7, n8, l2);
                    if (!bl2) {
                        MediaCodecVideoEncoder.this.onAsyncEncodeFrameResult(MediaCodecVideoEncoder.this.nativeHandle, false, null);
                    }
                }
            });
            return true;
        }
        if (!this.isInitialized) {
            Logging.e(TAG, "encodeTexture: encoder is not initialized!");
            return false;
        }
        long l3 = SystemClock.elapsedRealtime();
        if (this.lastKeyFrameTimeMs == 0L) {
            this.lastKeyFrameTimeMs = l3;
        }
        try {
            int n9;
            int n10;
            if (bl || this.chipProperties.bitrateAdjustmentType != BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT && l3 - this.lastKeyFrameTimeMs >= (long)this.keyFrameIntervalInMsec) {
                if (bl) {
                    Logging.i(TAG, "Sync frame request");
                }
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                this.mediaCodec.setParameters(bundle);
                this.lastKeyFrameTimeMs = l3;
            }
            Logging.d(TAG, "enter encodeTexture:" + n4 + "x" + n5 + "->" + this.width + "x" + this.height);
            this.eglBase.makeCurrent();
            GLES20.glClear((int)16384);
            if (n8 == 90 || n8 == 270) {
                n10 = n5;
                n9 = n4;
            } else {
                n10 = n4;
                n9 = n5;
            }
            this.rotateMatrix.reset();
            this.rotateMatrix.preTranslate(0.5f, 0.5f);
            this.rotateMatrix.preRotate((float)n8);
            this.rotateMatrix.preTranslate(-0.5f, -0.5f);
            Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
            matrix.preConcat(this.rotateMatrix);
            float[] fArray2 = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix);
            if (n3 == 10) {
                this.drawer.drawRgb(n2, fArray2, n10, n9, 0, 0, this.width, this.height, n6, n7);
            } else {
                this.drawer.drawOes(n2, fArray2, n10, n9, 0, 0, this.width, this.height, n6, n7);
            }
            this.eglBase.swapBuffers();
            this.eglBase.detachCurrent();
            return true;
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeTexture failed", runtimeException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Logging.i(TAG, "Java releaseEncoder");
        if (!this.useAsyncMode) {
            this.releaseEncoderTask();
        } else {
            Object object = this.inputBufferLock;
            synchronized (object) {
                this.availableInputIndexes.clear();
                if (this.asyncEncoderCallback != null) {
                    this.asyncEncoderCallback.stale = true;
                }
            }
            if (this.asyncEncoderHandler == null) {
                Logging.e(TAG, "release: null async handler, not initialized?");
                return;
            }
            this.asyncEncoderHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecVideoEncoder.this.releaseEncoderTask();
                }
            });
        }
    }

    private void releaseEncoderTask() {
        Object object;
        if (!this.isInitialized) {
            Logging.e(TAG, "releaseEncoderTask: encoder is not initialized!");
            return;
        }
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        final CaughtException caughtException = new CaughtException();
        boolean bl = false;
        if (this.mediaCodec != null) {
            object = new CountDownLatch(1);
            Runnable runnable = new Runnable((CountDownLatch)object){
                final /* synthetic */ CountDownLatch val$releaseDone;
                {
                    this.val$releaseDone = countDownLatch;
                }

                @Override
                public void run() {
                    Logging.i(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread");
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.stop();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder stop failed", exception);
                    }
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.release();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder release failed", exception);
                        caughtException.e = exception;
                    }
                    Logging.i(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread done");
                    this.val$releaseDone.countDown();
                }
            };
            new Thread(runnable).start();
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)object, 3000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                bl = true;
            }
            this.mediaCodec = null;
        }
        this.isInitialized = false;
        if (this.drawer != null) {
            this.drawer.release();
            this.drawer = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
        if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        if (bl) {
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        if (caughtException.e != null) {
            object = new RuntimeException(caughtException.e);
            ((Throwable)object).setStackTrace(ThreadUtils.concatStackTraces(caughtException.e.getStackTrace(), ((Throwable)object).getStackTrace()));
            throw object;
        }
        Logging.i(TAG, "Java releaseEncoder done");
    }

    private static boolean checkMinSDKVersion(String string, boolean bl) {
        if (bl) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (string.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (string.startsWith("OMX.MTK.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (string.startsWith("OMX.Exynos.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (string.startsWith("OMX.IMG.TOPAZ.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (string.startsWith("OMX.k3.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    private ChipProperties getChipProperties(String string, int n2) {
        if (string.startsWith("OMX.qcom.")) {
            List<String> list = Arrays.asList(H264_HW_QCOM_EXCEPTION_MODELS);
            if (list.contains(Build.MODEL.toLowerCase())) {
                Logging.w(TAG, "Qcom Exception Model: " + Build.MODEL);
                this.qcomExceptionModel = true;
                return new ChipProperties(string, BitrateAdjustmentType.NO_ADJUSTMENT, true, n2, n2, 21);
            }
            this.qcomExceptionModel = false;
            return new ChipProperties(string, BitrateAdjustmentType.NO_ADJUSTMENT, false, n2, n2, 21);
        }
        if (string.startsWith("OMX.MTK.")) {
            String string2 = Build.HARDWARE;
            Logging.i(TAG, "MTK hardware: " + string2);
            if (string2.equalsIgnoreCase("mt6763") || string2.equalsIgnoreCase("mt6763t")) {
                return new ChipProperties(string, BitrateAdjustmentType.NO_ADJUSTMENT, false, n2, n2, 21);
            }
            List<String> list = Arrays.asList(MTK_NO_ADJUSTMENT_MODELS);
            if (list.contains(Build.MODEL)) {
                return new ChipProperties(string, BitrateAdjustmentType.NO_ADJUSTMENT, false, n2, n2, 21);
            }
            if (string2.equalsIgnoreCase("mt6735")) {
                return new ChipProperties(string, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n2, n2, Integer.MAX_VALUE);
            }
            return new ChipProperties(string, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n2, n2, 21);
        }
        if (string.startsWith("OMX.Exynos.")) {
            if (Build.MODEL.equalsIgnoreCase("MX4 Pro")) {
                return new ChipProperties(string, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n2, n2, Integer.MAX_VALUE);
            }
            if (this.settingCodecParameterForExynos > 0 && Build.VERSION.SDK_INT > 28) {
                return new ChipProperties(string, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n2, n2, 21);
            }
            return new ChipProperties(string, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, 21);
        }
        if (string.startsWith("OMX.IMG.TOPAZ.")) {
            if (Build.HARDWARE.equalsIgnoreCase("hi6250")) {
                return new ChipProperties(string, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n2, n2, Integer.MAX_VALUE);
            }
            return new ChipProperties(string, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        if (string.startsWith("OMX.hisi.")) {
            return new ChipProperties(string, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n2, n2, Integer.MAX_VALUE);
        }
        if (string.startsWith("OMX.k3.")) {
            return new ChipProperties(string, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, 21);
        }
        if (string.startsWith("OMX.amlogic.")) {
            Logging.i(TAG, "getChipProperties for amlogic");
            return new ChipProperties(string, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        if (string.startsWith("OMX.rk.")) {
            return new ChipProperties(string, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        Logging.i(TAG, "getChipProperties from unsupported chip list");
        return new ChipProperties(string, BitrateAdjustmentType.NO_ADJUSTMENT, false, n2, n2, 23);
    }

    private int convertBitRate(int n2, int n3) {
        if (this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT) {
            if (this.chipProperties.chipName.startsWith("OMX.rk.")) {
                return 1000 * n2 * this.chipProperties.baseFrameRate / n3;
            }
            return 900 * n2 * this.chipProperties.baseFrameRate / n3;
        }
        if (this.chipProperties.chipName.startsWith("OMX.qcom.")) {
            return 950 * n2;
        }
        return 900 * n2;
    }

    private int setRates(final int n2, final int n3) {
        Logging.d(TAG, "Bwe setRates: " + n2 + " Kbps");
        if (this.useAsyncMode && !this.isOnAsyncHandlerThread()) {
            if (this.asyncEncoderHandler == null) {
                Logging.e(TAG, "setRates: null async handler, not initialized?");
                return 0;
            }
            this.asyncEncoderHandler.post(new Runnable(){

                @Override
                public void run() {
                    int n22 = MediaCodecVideoEncoder.this.setRates(n2, n3);
                    Logging.i(MediaCodecVideoEncoder.TAG, "setRates async, ret: " + n22);
                    MediaCodecVideoEncoder.this.onAsyncSetRatesResult(MediaCodecVideoEncoder.this.nativeHandle, n22);
                }
            });
            return 1;
        }
        if (!this.isInitialized) {
            Logging.e(TAG, "setRates: encoder is not initialized!");
            return 0;
        }
        boolean bl = n3 > 0 && n3 != this.lastSetFps;
        this.lastSetFps = n3 > 0 ? n3 : this.lastSetFps;
        int n4 = this.convertBitRate(n2, this.lastSetFps);
        try {
            if (bl && this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT) {
                this.converted_bps = n4;
                return 0;
            }
            if (n4 > this.converted_bps) {
                this.converted_bps = n4;
                Bundle bundle = new Bundle();
                bundle.putInt("video-bitrate", this.converted_bps);
                this.mediaCodec.setParameters(bundle);
                Logging.i(TAG, "setRates up to : " + this.converted_bps + " bps(converted) " + this.lastSetFps + " fps");
                return 1;
            }
            int n5 = 0;
            if (this.chipProperties.chipName.startsWith("OMX.qcom.")) {
                if (this.qcomExceptionModel) {
                    n5 = 25000;
                } else {
                    int n6 = n5 = this.converted_bps > 200000 ? 25000 : 15000;
                }
            }
            if (n4 < this.converted_bps - n5) {
                this.converted_bps = n4;
                if (this.chipProperties.isNeedResetWhenDownBps) {
                    long l2 = SystemClock.elapsedRealtime();
                    if (l2 - this.lastResetForQcomTimeMs >= 2000L) {
                        this.lastResetForQcomTimeMs = l2;
                        return 0;
                    }
                    return 2;
                }
                Bundle bundle = new Bundle();
                bundle.putInt("video-bitrate", this.converted_bps);
                this.mediaCodec.setParameters(bundle);
                Logging.i(TAG, "setRates down to : " + this.converted_bps + " bps(converted) " + this.lastSetFps + " fps");
            }
            return 1;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "setRates failed", illegalStateException);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    InputBufferInfo dequeueInputBufferAvailable() {
        InputBufferInfo inputBufferInfo;
        Object object = this.inputBufferLock;
        synchronized (object) {
            Iterator iterator = this.availableInputIndexes.iterator();
            if (!iterator.hasNext()) {
                Logging.e(TAG, "no input buffer available");
                inputBufferInfo = new InputBufferInfo(-1, null);
            } else {
                try {
                    int n2 = (Integer)iterator.next();
                    iterator.remove();
                    ByteBuffer byteBuffer = this.mediaCodec.getInputBuffer(n2);
                    inputBufferInfo = new InputBufferInfo(n2, byteBuffer);
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(TAG, "codec exception: " + illegalStateException.getMessage());
                    inputBufferInfo = new InputBufferInfo(-2, null);
                }
            }
        }
        return inputBufferInfo;
    }

    @Deprecated
    int dequeueInputBuffer() {
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    @Deprecated
    OutputBufferInfo dequeueOutputBuffer() {
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            if (n2 >= 0) {
                boolean bl;
                boolean bl2 = bl = (bufferInfo.flags & 2) != 0;
                if (bl) {
                    Logging.d(TAG, "Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size);
                    this.configData = ByteBuffer.allocateDirect(bufferInfo.size);
                    this.outputBuffers[n2].position(bufferInfo.offset);
                    this.outputBuffers[n2].limit(bufferInfo.offset + bufferInfo.size);
                    this.configData.put(this.outputBuffers[n2]);
                    this.mediaCodec.releaseOutputBuffer(n2, false);
                    n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                }
            }
            if (n2 >= 0) {
                return this.createOutputBufferInfo(bufferInfo, n2, this.outputBuffers[n2].duplicate());
            }
            if (n2 == -3) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                return this.dequeueOutputBuffer();
            }
            if (n2 == -2) {
                return this.dequeueOutputBuffer();
            }
            if (n2 == -1) {
                return null;
            }
            throw new RuntimeException("dequeueOutputBuffer: " + n2);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueOutputBuffer failed", illegalStateException);
            return new OutputBufferInfo(-1, null, false, -1L, 0);
        }
    }

    private OutputBufferInfo createOutputBufferInfo(MediaCodec.BufferInfo bufferInfo, int n2, ByteBuffer byteBuffer) {
        boolean bl;
        byteBuffer.position(bufferInfo.offset);
        byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
        boolean bl2 = bl = (bufferInfo.flags & 1) != 0;
        if (bl) {
            Logging.d(TAG, "Sync frame generated");
        }
        if (bl && this.type == VideoCodecType.VIDEO_CODEC_H264) {
            Logging.d(TAG, "Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + bufferInfo.offset + ", size " + bufferInfo.size);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.configData.capacity() + bufferInfo.size);
            this.configData.rewind();
            byteBuffer2.put(this.configData);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.position(0);
            OutputBufferInfo outputBufferInfo = new OutputBufferInfo(n2, byteBuffer2, bl, bufferInfo.presentationTimeUs, bufferInfo.size + this.configData.capacity());
            return outputBufferInfo;
        }
        OutputBufferInfo outputBufferInfo = new OutputBufferInfo(n2, byteBuffer.slice(), bl, bufferInfo.presentationTimeUs, bufferInfo.size);
        return outputBufferInfo;
    }

    @Deprecated
    boolean releaseOutputBuffer(int n2) {
        try {
            this.mediaCodec.releaseOutputBuffer(n2, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "releaseOutputBuffer failed", illegalStateException);
            return false;
        }
    }

    void dumpIntoFile(OutputBufferInfo outputBufferInfo) {
        Object object;
        if (this.fos == null) {
            try {
                object = String.format("/sdcard/java_dump_video_%d_%d.h264", this.width, this.height);
                this.fos = new FileOutputStream((String)object, true);
            }
            catch (Exception exception) {
                Logging.i(TAG, "dumpIntoFile: failed to open java_dump_video.h264");
                return;
            }
        }
        if (outputBufferInfo != null && outputBufferInfo.index >= 0) {
            Logging.i(TAG, "Dump nal: " + outputBufferInfo.buffer);
            try {
                object = new byte[outputBufferInfo.buffer.remaining()];
                outputBufferInfo.buffer.get((byte[])object);
                this.fos.write((byte[])object, 0, outputBufferInfo.size);
            }
            catch (Exception exception) {
                Logging.e(TAG, "Run: 4.1 Exception ", exception);
            }
        }
    }

    private native void onAsyncInitEncoderResult(long var1, boolean var3);

    private native void onAsyncEncodeFrameResult(long var1, boolean var3, OutputBufferInfo var4);

    private native void onAsyncSetRatesResult(long var1, int var3);

    @TargetApi(value=21)
    private class MediaCodecEncoderCallback
    extends MediaCodec.Callback {
        boolean stale = false;

        private MediaCodecEncoderCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInputBufferAvailable(MediaCodec mediaCodec, int n2) {
            if (!MediaCodecVideoEncoder.this.isInitialized) {
                return;
            }
            Object object = MediaCodecVideoEncoder.this.inputBufferLock;
            synchronized (object) {
                if (!this.stale) {
                    MediaCodecVideoEncoder.this.availableInputIndexes.add(n2);
                }
            }
        }

        public void onOutputBufferAvailable(MediaCodec mediaCodec, int n2, MediaCodec.BufferInfo bufferInfo) {
            ByteBuffer byteBuffer;
            if (!MediaCodecVideoEncoder.this.isInitialized) {
                Logging.w(MediaCodecVideoEncoder.TAG, "discarding output since encoder is released!");
                return;
            }
            try {
                byteBuffer = MediaCodecVideoEncoder.this.mediaCodec.getOutputBuffer(n2);
                if (byteBuffer == null) {
                    Logging.e(MediaCodecVideoEncoder.TAG, "failed to get output buffer, index: " + n2);
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(MediaCodecVideoEncoder.TAG, "getOutputBuffer exception, index: " + n2, illegalStateException);
                return;
            }
            try {
                boolean bl;
                boolean bl2 = bl = (bufferInfo.flags & 2) != 0;
                if (bl) {
                    Logging.d(MediaCodecVideoEncoder.TAG, "[async] Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size);
                    MediaCodecVideoEncoder.this.configData = ByteBuffer.allocateDirect(bufferInfo.size);
                    MediaCodecVideoEncoder.this.configData.put(byteBuffer);
                } else {
                    OutputBufferInfo outputBufferInfo = MediaCodecVideoEncoder.this.createOutputBufferInfo(bufferInfo, n2, byteBuffer);
                    MediaCodecVideoEncoder.this.onAsyncEncodeFrameResult(MediaCodecVideoEncoder.this.nativeHandle, true, outputBufferInfo);
                }
            }
            catch (Exception exception) {
                Logging.e(MediaCodecVideoEncoder.TAG, "handle output buffer error", exception);
            }
            MediaCodecVideoEncoder.this.mediaCodec.releaseOutputBuffer(n2, false);
        }

        public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
            Logging.e(MediaCodecVideoEncoder.TAG, "onError " + codecException);
        }

        public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
            Logging.w(MediaCodecVideoEncoder.TAG, "onOutputFormatChanged " + mediaFormat);
        }
    }

    static class OutputBufferInfo {
        public final int size;
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n2, ByteBuffer byteBuffer, boolean bl, long l2, int n3) {
            this.index = n2;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l2;
            this.size = n3;
        }
    }

    static class InputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;

        public InputBufferInfo(int n2, ByteBuffer byteBuffer) {
            this.index = n2;
            this.buffer = byteBuffer;
        }
    }

    public static class InitParameters {
        int codec;
        int width;
        int height;
        int bitrateKbps;
        int fps;
        int init_fps;
        int keyInterval;
        int profile;
        boolean fallbackToBaselineProfile;
        boolean useAsyncMode;
        android.opengl.EGLContext sharedEgl14Context;
        EGLContext sharedEgl10Context;

        public InitParameters(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, android.opengl.EGLContext eGLContext, EGLContext eGLContext2) {
            this.codec = n2;
            this.width = n3;
            this.height = n4;
            this.bitrateKbps = n5;
            this.fps = n6;
            this.init_fps = n7;
            this.keyInterval = n8;
            this.fallbackToBaselineProfile = bl;
            this.profile = n9;
            this.useAsyncMode = bl2;
            this.sharedEgl14Context = eGLContext;
            this.sharedEgl10Context = eGLContext2;
        }

        final boolean useSurface() {
            return this.sharedEgl14Context != null || this.sharedEgl10Context != null;
        }

        public String toString() {
            return (Object)((Object)VideoCodecType.values()[this.codec]) + (" : " + this.width + " x " + this.height) + (" @ " + this.bitrateKbps + " Kbps,") + " Fps: " + (this.fps + ",") + (" Key interval: " + this.keyInterval + "s,") + (" Encode from texture : " + this.useSurface() + ",") + (" Async mode: " + this.useAsyncMode + ".");
        }
    }

    private static class ChipProperties {
        public final String chipName;
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final boolean isNeedResetWhenDownBps;
        public final int baseFrameRate;
        public final int initFrameRate;
        public final int highProfileMinSdkVersion;

        ChipProperties(String string, BitrateAdjustmentType bitrateAdjustmentType, boolean bl, int n2, int n3, int n4) {
            this.chipName = string;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
            this.isNeedResetWhenDownBps = bl;
            this.baseFrameRate = n2;
            this.initFrameRate = n3;
            this.highProfileMinSdkVersion = n4;
        }
    }

    public static enum BitrateAdjustmentType {
        NO_ADJUSTMENT,
        FRAMERATE_ADJUSTMENT,
        ACTUAL_FRAMERATE_ADJUSTMENT,
        DYNAMIC_ADJUSTMENT;

    }

    private static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final boolean supportedList;

        public EncoderProperties(String string, int n2, boolean bl) {
            this.codecName = string;
            this.colorFormat = n2;
            this.supportedList = bl;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;

    }
}

