/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Surface;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.MediaCodecVideoEncoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MediaCodecVideoDecoder {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final long MAX_DECODE_TIME_MS = 2000L;
    private static final int DEQUEUE_INPUT_TIMEOUT = 100000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance = null;
    private static MediaCodecVideoDecoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static Set<String> hwDecoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    @Deprecated
    ByteBuffer[] inputBuffers;
    @Deprecated
    ByteBuffer[] outputBuffers;
    private boolean useAsyncMode = false;
    private long nativeHandle;
    private MediaCodecDecoderCallback decoderCallback;
    private HandlerThread asyncHandlerThread;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Nvidia.", "OMX.Exynos.", "OMX.Intel."};
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos."};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.rk.", "OMX.sprd.", "OMX.amlogic.", "OMX.IMG.TOPAZ.", "OMX.IMG.MSVDX.", "OMX.hisi.", "OMX.k3.", "OMX.allwinner.", "OMX.MTK.", "OMX.Nvidia.", "OMX.Intel.", "OMX.MS."};
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391876);
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private int cropWidth;
    private int cropHeight;
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> decodeStartTimeMs = new LinkedList<TimeStamps>();
    private boolean useSurface;
    private int droppedFrames;
    private Surface surface = null;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new LinkedList<DecodedOutputBuffer>();

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static boolean isAsyncModeSupported() {
        return false;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes) != null;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    private static DecoderProperties findDecoder(String string, String[] codecCapabilities) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Logging.i(TAG, "Trying to find HW decoder for mime " + string);
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            String string2 = null;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (!string3.equals(string)) continue;
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            Logging.i(TAG, "Found candidate decoder " + string2);
            boolean bl = false;
            for (String string4 : codecCapabilities) {
                if (!string2.startsWith(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            MediaCodecInfo.CodecCapabilities codecCapabilities2 = mediaCodecInfo.getCapabilitiesForType(string);
            for (int n2 : codecCapabilities2.colorFormats) {
                Logging.d(TAG, "   Color: 0x" + Integer.toHexString(n2));
            }
            if (string2.startsWith("OMX.rk.")) {
                return new DecoderProperties(string2, 21);
            }
            Object object = supportedColorList.iterator();
            while (object.hasNext()) {
                int n2;
                int n3 = (Integer)object.next();
                int[] nArray = codecCapabilities2.colorFormats;
                n2 = nArray.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n4 = nArray[i3];
                    if (n4 != n3) continue;
                    Logging.d(TAG, "Found target decoder " + string2 + ". Color: 0x" + Integer.toHexString(n4));
                    return new DecoderProperties(string2, n4);
                }
            }
        }
        Logging.d(TAG, "No HW decoder found for mime " + string);
        return null;
    }

    private void checkOnMediaCodecThread() throws IllegalStateException {
    }

    @SuppressLint(value={"NewApi"})
    private boolean initDecode(int n2, int n3, int n4, SurfaceTextureHelper surfaceTextureHelper, boolean bl, Looper looper, long l2) {
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        String string = null;
        this.useSurface = surfaceTextureHelper != null;
        String[] stringArray = null;
        VideoCodecType videoCodecType = VideoCodecType.values()[n2];
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
            string = VP8_MIME_TYPE;
            stringArray = supportedVp8HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
            string = VP9_MIME_TYPE;
            stringArray = supportedVp9HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264) {
            string = H264_MIME_TYPE;
            stringArray = supportedH264HwCodecPrefixes;
        } else {
            throw new RuntimeException("initDecode: Non-supported codec " + (Object)((Object)videoCodecType));
        }
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder(string, stringArray);
        if (decoderProperties == null) {
            throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        }
        Logging.d(TAG, "Java initDecode: " + (Object)((Object)videoCodecType) + " : " + n3 + " x " + n4 + ". Color: 0x" + Integer.toHexString(decoderProperties.colorFormat) + ". Use Surface: " + this.useSurface + ". Use async mode: " + bl + ". nativeHandle: " + l2);
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            this.width = n3;
            this.height = n4;
            this.stride = n3;
            this.sliceHeight = n4;
            this.cropWidth = n3;
            this.cropHeight = n4;
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n3, (int)n4);
            if (!this.useSurface) {
                mediaFormat.setInteger("color-format", decoderProperties.colorFormat);
            }
            Logging.d(TAG, "  Format: " + mediaFormat);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            this.nativeHandle = l2;
            this.useAsyncMode = bl;
            if (bl) {
                this.decoderCallback = new MediaCodecDecoderCallback();
                Looper looper2 = looper;
                if (looper2 == null) {
                    this.asyncHandlerThread = new HandlerThread("decoderAsyncHandler");
                    this.asyncHandlerThread.start();
                    looper2 = this.asyncHandlerThread.getLooper();
                }
                this.mediaCodec.setCallback((MediaCodec.Callback)this.decoderCallback, new Handler(looper2));
            }
            this.mediaCodec.configure(mediaFormat, this.surface, null, 0);
            this.mediaCodec.start();
            Logging.d(TAG, "MediaCodec started");
            this.colorFormat = decoderProperties.colorFormat;
            if (!bl) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                this.inputBuffers = this.mediaCodec.getInputBuffers();
                Logging.i(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            }
            this.decodeStartTimeMs.clear();
            this.hasDecodedFirstFrame = false;
            this.dequeuedSurfaceOutputBuffers.clear();
            this.droppedFrames = 0;
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(int n2, int n3) {
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Logging.i(TAG, "Java reset: " + n2 + " x " + n3);
        if (this.useAsyncMode) {
            this.mediaCodec.flush();
            LinkedHashSet<Integer> linkedHashSet = this.decoderCallback.availableInputIndexes;
            synchronized (linkedHashSet) {
                this.decoderCallback.availableInputIndexes.clear();
            }
            this.mediaCodec.start();
            Logging.d(TAG, "MediaCodec restarted");
        } else {
            this.mediaCodec.flush();
        }
        this.width = n2;
        this.height = n3;
        this.decodeStartTimeMs.clear();
        this.dequeuedSurfaceOutputBuffers.clear();
        this.hasDecodedFirstFrame = false;
        this.droppedFrames = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void release() {
        Object object;
        Logging.i(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        this.checkOnMediaCodecThread();
        if (this.useAsyncMode) {
            if (this.asyncHandlerThread != null) {
                this.asyncHandlerThread.quit();
                this.asyncHandlerThread = null;
            }
            object = this.decoderCallback;
            synchronized (object) {
                this.decoderCallback.isObsolete = true;
            }
            this.decoderCallback = null;
        }
        object = new CountDownLatch(1);
        Runnable runnable = new Runnable((CountDownLatch)object){
            final /* synthetic */ CountDownLatch val$releaseDone;
            {
                this.val$releaseDone = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    Logging.i(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    MediaCodecVideoDecoder.this.mediaCodec.stop();
                    MediaCodecVideoDecoder.this.mediaCodec.release();
                    Logging.i(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                this.val$releaseDone.countDown();
            }
        };
        new Thread(runnable).start();
        if (!ThreadUtils.awaitUninterruptibly(object, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        Logging.d(TAG, "Java releaseDecoder done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    private InputBufferInfo dequeueInputBufferAvailable() {
        InputBufferInfo inputBufferInfo;
        LinkedHashSet<Integer> linkedHashSet = this.decoderCallback.availableInputIndexes;
        synchronized (linkedHashSet) {
            Iterator iterator = this.decoderCallback.availableInputIndexes.iterator();
            if (!iterator.hasNext()) {
                Logging.e(TAG, "no input buffer available");
                inputBufferInfo = new InputBufferInfo(-1, null);
            } else {
                int n2 = (Integer)iterator.next();
                iterator.remove();
                try {
                    ByteBuffer byteBuffer = this.mediaCodec.getInputBuffer(n2);
                    inputBufferInfo = new InputBufferInfo(n2, byteBuffer);
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(TAG, "codec exception: " + illegalStateException.getMessage());
                    inputBufferInfo = new InputBufferInfo(-2, null);
                }
            }
        }
        return inputBufferInfo;
    }

    @Deprecated
    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(100000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    private boolean queueInputBuffer(int n2, int n3, long l2, long l3, long l4) {
        this.checkOnMediaCodecThread();
        try {
            if (!this.useAsyncMode) {
                this.inputBuffers[n2].position(0);
                this.inputBuffers[n2].limit(n3);
            }
            this.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), l3, l4));
            this.mediaCodec.queueInputBuffer(n2, 0, n3, l2, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
    }

    private DecodedOutputBuffer dequeueOutputBuffer(int n2) {
        int n3;
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n3 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(n2));
            switch (n3) {
                case -3: {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Logging.i(TAG, "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    this.handleOutputFormatChanged(mediaFormat);
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        this.hasDecodedFirstFrame = true;
        TimeStamps timeStamps = this.decodeStartTimeMs.remove();
        long l2 = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (l2 > 2000L) {
            Logging.w(TAG, "Very high decode time: " + l2 + "ms.");
            l2 = 2000L;
        }
        return new DecodedOutputBuffer(n3, this.outputBuffers[n3], bufferInfo.offset, bufferInfo.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l2, SystemClock.elapsedRealtime());
    }

    private void handleOutputFormatChanged(MediaFormat mediaFormat) {
        Logging.i(TAG, "Decoder format changed: " + mediaFormat.toString());
        int n2 = mediaFormat.getInteger("width");
        int n3 = mediaFormat.getInteger("height");
        if (this.hasDecodedFirstFrame && (n2 != this.width || n3 != this.height)) {
            Logging.w(TAG, "Decoder format changed. Configured " + this.width + "*" + this.height + ". New " + n2 + "*" + n3);
        }
        this.width = mediaFormat.getInteger("width");
        this.height = mediaFormat.getInteger("height");
        if (mediaFormat.containsKey("stride")) {
            this.stride = mediaFormat.getInteger("stride");
        }
        if (mediaFormat.containsKey("slice-height")) {
            this.sliceHeight = mediaFormat.getInteger("slice-height");
        }
        this.cropWidth = mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-right") ? mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left") + 1 : this.width;
        this.cropHeight = mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top") ? mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top") + 1 : this.height;
        Logging.i(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
        Logging.i(TAG, "Crop width and height: " + this.cropWidth + " x " + this.cropHeight);
        this.stride = Math.max(this.width, this.stride);
        this.sliceHeight = Math.max(this.height, this.sliceHeight);
    }

    private void returnDecodedOutputBuffer(int n2) throws IllegalStateException, MediaCodec.CodecException {
        this.checkOnMediaCodecThread();
        if (this.useSurface) {
            throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
        }
        this.mediaCodec.releaseOutputBuffer(n2, false);
    }

    private native void deliverOutputBufferReady(DecodedOutputBuffer var1, long var2);

    @TargetApi(value=21)
    class MediaCodecDecoderCallback
    extends MediaCodec.Callback {
        boolean isObsolete = false;
        final LinkedHashSet<Integer> availableInputIndexes = new LinkedHashSet();

        MediaCodecDecoderCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInputBufferAvailable(MediaCodec mediaCodec, int n2) {
            LinkedHashSet<Integer> linkedHashSet = this.availableInputIndexes;
            synchronized (linkedHashSet) {
                this.availableInputIndexes.add(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOutputBufferAvailable(MediaCodec mediaCodec, int n2, MediaCodec.BufferInfo bufferInfo) {
            MediaCodecDecoderCallback mediaCodecDecoderCallback = this;
            synchronized (mediaCodecDecoderCallback) {
                ByteBuffer byteBuffer;
                if (this.isObsolete) {
                    Logging.w(MediaCodecVideoDecoder.TAG, "discarding output as this callback is obsolete.");
                    return;
                }
                try {
                    byteBuffer = MediaCodecVideoDecoder.this.mediaCodec.getOutputBuffer(n2);
                    if (byteBuffer == null) {
                        Logging.e(MediaCodecVideoDecoder.TAG, "failed to get output buffer, index: " + n2);
                        return;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "getOutputBuffer exception, index: " + n2, illegalStateException);
                    return;
                }
                if (MediaCodecVideoDecoder.this.decodeStartTimeMs.isEmpty()) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "decodeStartTimeMs empty, dropping decoded output");
                } else {
                    TimeStamps timeStamps = (TimeStamps)MediaCodecVideoDecoder.this.decodeStartTimeMs.remove();
                    MediaCodecVideoDecoder.this.hasDecodedFirstFrame = true;
                    long l2 = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
                    if (l2 > 2000L) {
                        Logging.w(MediaCodecVideoDecoder.TAG, "Very high decode time: " + l2 + "ms.");
                        l2 = 2000L;
                    }
                    DecodedOutputBuffer decodedOutputBuffer = new DecodedOutputBuffer(n2, byteBuffer, bufferInfo.offset, bufferInfo.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l2, SystemClock.elapsedRealtime());
                    MediaCodecVideoDecoder.this.deliverOutputBufferReady(decodedOutputBuffer, MediaCodecVideoDecoder.this.nativeHandle);
                }
                MediaCodecVideoDecoder.this.mediaCodec.releaseOutputBuffer(n2, false);
            }
        }

        public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
            Logging.e(MediaCodecVideoDecoder.TAG, "onError " + codecException);
        }

        public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
            Logging.w(MediaCodecVideoDecoder.TAG, "onOutputFormatChanged " + mediaFormat);
            MediaCodecVideoDecoder.this.handleOutputFormatChanged(mediaFormat);
        }
    }

    private static class DecodedTextureBuffer {
        private final int textureID;
        private final float[] transformMatrix;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;

        public DecodedTextureBuffer(int n2, float[] fArray, long l2, long l3, long l4, long l5, long l6) {
            this.textureID = n2;
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
            this.decodeTimeMs = l5;
            this.frameDelayMs = l6;
        }
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        public final ByteBuffer buffer;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;

        public DecodedOutputBuffer(int n2, ByteBuffer byteBuffer, int n3, int n4, long l2, long l3, long l4, long l5, long l6) {
            this.index = n2;
            this.offset = n3;
            this.size = n4;
            this.buffer = byteBuffer;
            this.presentationTimeStampMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
            this.decodeTimeMs = l5;
            this.endDecodeTimeMs = l6;
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;

        public TimeStamps(long l2, long l3, long l4) {
            this.decodeStartTimeMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
        }
    }

    static class InputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;

        public InputBufferInfo(int n2, ByteBuffer byteBuffer) {
            this.index = n2;
            this.buffer = byteBuffer;
        }
    }

    class SurfaceTextureHelper {
        SurfaceTextureHelper() {
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string, int n2) {
            this.codecName = string;
            this.colorFormat = n2;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;

    }
}

