/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLDebugHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
View.OnLayoutChangeListener {
    private static final String TAG = "GLTextureView";
    private static final boolean LOG_ATTACH_DETACH = true;
    private static final boolean LOG_THREADS = true;
    private static final boolean LOG_PAUSE_RESUME = true;
    private static final boolean LOG_SURFACE = true;
    private static final boolean LOG_RENDERER = true;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_EGL = true;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();
    private final WeakReference<GLTextureView> mThisWeakRef = new WeakReference<GLTextureView>(this);
    private GLThread mGLThread;
    private Renderer mRenderer;
    private boolean mDetached;
    private EGLConfigChooser mEGLConfigChooser;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLWrapper mGLWrapper;
    private int mDebugFlags;
    private int mEGLContextClientVersion;
    private boolean mPreserveEGLContextOnPause;

    public GLTextureView(Context context) {
        super(context);
        this.init();
    }

    public GLTextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void init() {
        this.setSurfaceTextureListener(this);
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        this.mGLWrapper = gLWrapper;
    }

    public void setDebugFlags(int n2) {
        this.mDebugFlags = n2;
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        this.mPreserveEGLContextOnPause = bl;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    public void setRenderer(Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new SimpleEGLConfigChooser(true);
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory();
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        this.mRenderer = renderer;
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
    }

    public void setEGLContextFactory(EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setEGLConfigChooser(EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = eGLConfigChooser;
    }

    public void setEGLConfigChooser(boolean bl) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(bl));
    }

    public void setEGLConfigChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setEGLConfigChooser(new ComponentSizeChooser(n2, n3, n4, n5, n6, n7));
    }

    public void setEGLContextClientVersion(int n2) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = n2;
    }

    public void setRenderMode(int n2) {
        this.mGLThread.setRenderMode(n2);
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void surfaceCreated(SurfaceTexture surfaceTexture) {
        this.mGLThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceTexture surfaceTexture) {
        this.mGLThread.surfaceDestroyed();
    }

    public void surfaceChanged(SurfaceTexture surfaceTexture, int n2, int n3, int n4) {
        this.mGLThread.onWindowResize(n3, n4);
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable runnable) {
        this.mGLThread.queueEvent(runnable);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.d((String)TAG, (String)("onAttachedToWindow reattach =" + this.mDetached));
        if (this.mDetached && this.mRenderer != null) {
            int n2 = 1;
            if (this.mGLThread != null) {
                n2 = this.mGLThread.getRenderMode();
            }
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (n2 != 1) {
                this.mGLThread.setRenderMode(n2);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    protected void onDetachedFromWindow() {
        Log.d((String)TAG, (String)"onDetachedFromWindow");
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        this.mDetached = true;
        super.onDetachedFromWindow();
    }

    public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.surfaceChanged(this.getSurfaceTexture(), 0, n4 - n2, n5 - n3);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        this.surfaceCreated(surfaceTexture);
        this.surfaceChanged(surfaceTexture, 0, n2, n3);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        this.surfaceChanged(surfaceTexture, 0, n2, n3);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.surfaceDestroyed(surfaceTexture);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    private void checkRenderThreadState() {
        if (this.mGLThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    static /* synthetic */ boolean access$900(GLTextureView gLTextureView) {
        return gLTextureView.mPreserveEGLContextOnPause;
    }

    static /* synthetic */ Renderer access$1000(GLTextureView gLTextureView) {
        return gLTextureView.mRenderer;
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";
        private boolean mGLESVersionCheckComplete;
        private int mGLESVersion;
        private boolean mGLESDriverCheckComplete;
        private boolean mMultipleGLESContextsAllowed;
        private boolean mLimitedGLESContexts;
        private static final int kGLES_20 = 131072;
        private static final String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private GLThread mEglOwner;

        private GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread gLThread) {
            Log.i((String)"GLThread", (String)("exiting tid=" + gLThread.getId()));
            gLThread.mExited = true;
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean tryAcquireEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread || this.mEglOwner == null) {
                this.mEglOwner = gLThread;
                this.notifyAll();
                return true;
            }
            this.checkGLESVersion();
            if (this.mMultipleGLESContextsAllowed) {
                return true;
            }
            if (this.mEglOwner != null) {
                this.mEglOwner.requestReleaseEglContextLocked();
            }
            return false;
        }

        public void releaseEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public synchronized boolean shouldReleaseEGLContextWhenPausing() {
            return this.mLimitedGLESContexts;
        }

        public synchronized boolean shouldTerminateEGLWhenPausing() {
            this.checkGLESVersion();
            return !this.mMultipleGLESContextsAllowed;
        }

        public synchronized void checkGLDriver(GL10 gL10) {
            if (!this.mGLESDriverCheckComplete) {
                this.checkGLESVersion();
                String string = gL10.glGetString(7937);
                if (this.mGLESVersion < 131072) {
                    this.mMultipleGLESContextsAllowed = !string.startsWith(kMSM7K_RENDERER_PREFIX);
                    this.notifyAll();
                }
                this.mLimitedGLESContexts = !this.mMultipleGLESContextsAllowed;
                Log.w((String)TAG, (String)("checkGLDriver renderer = \"" + string + "\" multipleContextsAllowed = " + this.mMultipleGLESContextsAllowed + " mLimitedGLESContexts = " + this.mLimitedGLESContexts));
                this.mGLESDriverCheckComplete = true;
            }
        }

        private void checkGLESVersion() {
            if (!this.mGLESVersionCheckComplete) {
                this.mGLESVersionCheckComplete = true;
            }
        }
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = cArray[n2 + i2];
                if (c2 == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c2);
            }
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v((String)GLTextureView.TAG, (String)this.mBuilder.toString());
                this.mBuilder.delete(0, this.mBuilder.length());
            }
        }
    }

    static class GLThread
    extends Thread {
        private boolean mShouldExit;
        private boolean mExited;
        private boolean mRequestPaused;
        private boolean mPaused;
        private boolean mHasSurface;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private boolean mShouldReleaseEglContext;
        private int mWidth = 0;
        private int mHeight = 0;
        private int mRenderMode = 1;
        private boolean mRequestRender = true;
        private boolean mRenderComplete;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private boolean mSizeChanged = true;
        private EglHelper mEglHelper;
        private WeakReference<GLTextureView> mGLSurfaceViewWeakRef;

        GLThread(WeakReference<GLTextureView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        @Override
        public void run() {
            this.setName("GLThread " + this.getId());
            Log.i((String)"GLThread", (String)("starting tid=" + this.getId()));
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                sGLThreadManager.threadExiting(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper(this.mGLSurfaceViewWeakRef);
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            try {
                var1_1 = null;
                var2_2 = false;
                var3_3 = false;
                var4_4 = false;
                var5_5 = false;
                var6_6 = false;
                var7_7 = false;
                var8_8 = false;
                var9_9 = false;
                var10_10 = 0;
                var11_11 = 0;
                var12_12 = null;
                while (true) {
                    var13_13 /* !! */  = GLTextureView.access$800();
                    synchronized (var13_13 /* !! */ ) {
                        while (true) {
                            if (this.mShouldExit) {
                                return;
                            }
                            if (!this.mEventQueue.isEmpty()) {
                                var12_12 = this.mEventQueue.remove(0);
                                break;
                            }
                            var14_16 = false;
                            if (this.mPaused != this.mRequestPaused) {
                                var14_16 = this.mRequestPaused;
                                this.mPaused = this.mRequestPaused;
                                GLTextureView.access$800().notifyAll();
                                Log.i((String)"GLThread", (String)("mPaused is now " + this.mPaused + " tid=" + this.getId()));
                            }
                            if (this.mShouldReleaseEglContext) {
                                Log.i((String)"GLThread", (String)("releasing EGL context because asked to tid=" + this.getId()));
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                this.mShouldReleaseEglContext = false;
                                var9_9 = true;
                            }
                            if (var5_5) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                var5_5 = false;
                            }
                            if (var14_16 && this.mHaveEglSurface) {
                                Log.i((String)"GLThread", (String)("releasing EGL surface because paused tid=" + this.getId()));
                                this.stopEglSurfaceLocked();
                            }
                            if (var14_16 && this.mHaveEglContext) {
                                var15_18 = (GLTextureView)this.mGLSurfaceViewWeakRef.get();
                                v0 = var16_20 = var15_18 == null ? false : GLTextureView.access$900(var15_18);
                                if (!var16_20 || GLTextureView.access$800().shouldReleaseEGLContextWhenPausing()) {
                                    this.stopEglContextLocked();
                                    Log.i((String)"GLThread", (String)("releasing EGL context because paused tid=" + this.getId()));
                                }
                            }
                            if (var14_16 && GLTextureView.access$800().shouldTerminateEGLWhenPausing()) {
                                this.mEglHelper.finish();
                                Log.i((String)"GLThread", (String)("terminating EGL because paused tid=" + this.getId()));
                            }
                            if (!this.mHasSurface && !this.mWaitingForSurface) {
                                Log.i((String)"GLThread", (String)("noticed surfaceView surface lost tid=" + this.getId()));
                                if (this.mHaveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                this.mWaitingForSurface = true;
                                this.mSurfaceIsBad = false;
                                GLTextureView.access$800().notifyAll();
                            }
                            if (this.mHasSurface && this.mWaitingForSurface) {
                                Log.i((String)"GLThread", (String)("noticed surfaceView surface acquired tid=" + this.getId()));
                                this.mWaitingForSurface = false;
                                GLTextureView.access$800().notifyAll();
                            }
                            if (var8_8) {
                                Log.i((String)"GLThread", (String)("sending render notification tid=" + this.getId()));
                                var7_7 = false;
                                var8_8 = false;
                                this.mRenderComplete = true;
                                GLTextureView.access$800().notifyAll();
                            }
                            if (this.readyToDraw()) {
                                if (!this.mHaveEglContext) {
                                    if (var9_9) {
                                        var9_9 = false;
                                    } else if (GLTextureView.access$800().tryAcquireEglContextLocked(this)) {
                                        try {
                                            this.mEglHelper.start();
                                        }
                                        catch (RuntimeException var15_19) {
                                            GLTextureView.access$800().releaseEglContextLocked(this);
                                            throw var15_19;
                                        }
                                        this.mHaveEglContext = true;
                                        var2_2 = true;
                                        GLTextureView.access$800().notifyAll();
                                    }
                                }
                                if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                    this.mHaveEglSurface = true;
                                    var3_3 = true;
                                    var4_4 = true;
                                    var6_6 = true;
                                }
                                if (this.mHaveEglSurface) {
                                    if (this.mSizeChanged) {
                                        var6_6 = true;
                                        var10_10 = this.mWidth;
                                        var11_11 = this.mHeight;
                                        var7_7 = true;
                                        Log.i((String)"GLThread", (String)("noticing that we want render notification tid=" + this.getId()));
                                        var3_3 = true;
                                        this.mSizeChanged = false;
                                    }
                                    this.mRequestRender = false;
                                    GLTextureView.access$800().notifyAll();
                                    break;
                                }
                            }
                            Log.i((String)"GLThread", (String)("waiting tid=" + this.getId() + " mHaveEglContext: " + this.mHaveEglContext + " mHaveEglSurface: " + this.mHaveEglSurface + " mPaused: " + this.mPaused + " mHasSurface: " + this.mHasSurface + " mSurfaceIsBad: " + this.mSurfaceIsBad + " mWaitingForSurface: " + this.mWaitingForSurface + " mWidth: " + this.mWidth + " mHeight: " + this.mHeight + " mRequestRender: " + this.mRequestRender + " mRenderMode: " + this.mRenderMode));
                            GLTextureView.access$800().wait();
                        }
                        ** if (var12_12 == null) goto lbl120
                    }
lbl-1000:
                    // 1 sources

                    {
                        var12_12.run();
                        var12_12 = null;
                        continue;
                    }
lbl120:
                    // 1 sources

                    if (var3_3) {
                        Log.w((String)"GLThread", (String)"egl createSurface");
                        if (!this.mEglHelper.createSurface()) {
                            var13_13 /* !! */  = GLTextureView.access$800();
                            synchronized (var13_13 /* !! */ ) {
                                this.mSurfaceIsBad = true;
                                GLTextureView.access$800().notifyAll();
                                continue;
                            }
                        }
                        var3_3 = false;
                    }
                    if (var4_4) {
                        var1_1 = (GL10)this.mEglHelper.createGL();
                        GLTextureView.access$800().checkGLDriver(var1_1);
                        var4_4 = false;
                    }
                    if (var2_2) {
                        Log.w((String)"GLThread", (String)"onSurfaceCreated");
                        var13_13 /* !! */  = (GLTextureView)this.mGLSurfaceViewWeakRef.get();
                        if (var13_13 /* !! */  != null) {
                            GLTextureView.access$1000((GLTextureView)var13_13 /* !! */ ).onSurfaceCreated(var1_1, this.mEglHelper.mEglConfig);
                        }
                        var2_2 = false;
                    }
                    if (var6_6) {
                        Log.w((String)"GLThread", (String)("onSurfaceChanged(" + var10_10 + ", " + var11_11 + ")"));
                        var13_13 /* !! */  = (GLTextureView)this.mGLSurfaceViewWeakRef.get();
                        if (var13_13 /* !! */  != null) {
                            GLTextureView.access$1000((GLTextureView)var13_13 /* !! */ ).onSurfaceChanged(var1_1, var10_10, var11_11);
                        }
                        var6_6 = false;
                    }
                    if ((var13_13 /* !! */  = (GLTextureView)this.mGLSurfaceViewWeakRef.get()) != null) {
                        GLTextureView.access$1000((GLTextureView)var13_13 /* !! */ ).onDrawFrame(var1_1);
                    }
                    var13_14 = this.mEglHelper.swap();
                    switch (var13_14) {
                        case 12288: {
                            break;
                        }
                        case 12302: {
                            Log.i((String)"GLThread", (String)("egl context lost tid=" + this.getId()));
                            var5_5 = true;
                            break;
                        }
                        default: {
                            EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", var13_14);
                            var14_17 = GLTextureView.access$800();
                            synchronized (var14_17) {
                                this.mSurfaceIsBad = true;
                                GLTextureView.access$800().notifyAll();
                                break;
                            }
                        }
                    }
                    if (!var7_7) continue;
                    var8_8 = true;
                }
            }
            finally {
                var14_15 = GLTextureView.access$800();
                synchronized (var14_15) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                }
            }
        }

        public boolean ableToDraw() {
            return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
        }

        private boolean readyToDraw() {
            return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int n2) {
            if (0 > n2 || n2 > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = n2;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                Log.i((String)"GLThread", (String)("surfaceCreated tid=" + this.getId()));
                this.mHasSurface = true;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                Log.i((String)"GLThread", (String)("surfaceDestroyed tid=" + this.getId()));
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                Log.i((String)"GLThread", (String)("onPause tid=" + this.getId()));
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused) {
                    Log.i((String)"Main thread", (String)"onPause waiting for mPaused.");
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                Log.i((String)"GLThread", (String)("onResume tid=" + this.getId()));
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && this.mPaused && !this.mRenderComplete) {
                    Log.i((String)"Main thread", (String)"onResume waiting for !mPaused.");
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int n2, int n3) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = n2;
                this.mHeight = n3;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                    Log.i((String)"Main thread", (String)("onWindowResize waiting for render complete from tid=" + this.getId()));
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEventQueue.add(runnable);
                sGLThreadManager.notifyAll();
            }
        }
    }

    private static class EglHelper {
        private WeakReference<GLTextureView> mGLSurfaceViewWeakRef;
        EGL10 mEgl;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;

        public EglHelper(WeakReference<GLTextureView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        public void start() {
            Log.w((String)"EglHelper", (String)("start() tid=" + Thread.currentThread().getId()));
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] nArray = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, nArray)) {
                throw new RuntimeException("eglInitialize failed");
            }
            GLTextureView gLTextureView = (GLTextureView)((Object)this.mGLSurfaceViewWeakRef.get());
            if (gLTextureView == null) {
                this.mEglConfig = null;
                this.mEglContext = null;
            } else {
                this.mEglConfig = gLTextureView.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                this.mEglContext = gLTextureView.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
            }
            if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                this.mEglContext = null;
                this.throwEglException("createContext");
            }
            Log.w((String)"EglHelper", (String)("createContext " + this.mEglContext + " tid=" + Thread.currentThread().getId()));
            this.mEglSurface = null;
        }

        public boolean createSurface() {
            Log.w((String)"EglHelper", (String)("createSurface()  tid=" + Thread.currentThread().getId()));
            if (this.mEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.mEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.mEglConfig == null) {
                throw new RuntimeException("mEglConfig not initialized");
            }
            this.destroySurfaceImp();
            GLTextureView gLTextureView = (GLTextureView)((Object)this.mGLSurfaceViewWeakRef.get());
            this.mEglSurface = gLTextureView != null ? gLTextureView.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, gLTextureView.getSurfaceTexture()) : null;
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int n2 = this.mEgl.eglGetError();
                if (n2 == 12299) {
                    Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                return false;
            }
            return true;
        }

        GL createGL() {
            GL gL = this.mEglContext.getGL();
            GLTextureView gLTextureView = (GLTextureView)((Object)this.mGLSurfaceViewWeakRef.get());
            if (gLTextureView != null) {
                if (gLTextureView.mGLWrapper != null) {
                    gL = gLTextureView.mGLWrapper.wrap(gL);
                }
                if ((gLTextureView.mDebugFlags & 3) != 0) {
                    int n2 = 0;
                    LogWriter logWriter = null;
                    if ((gLTextureView.mDebugFlags & 1) != 0) {
                        n2 |= 1;
                    }
                    if ((gLTextureView.mDebugFlags & 2) != 0) {
                        logWriter = new LogWriter();
                    }
                    gL = GLDebugHelper.wrap((GL)gL, (int)n2, (Writer)logWriter);
                }
            }
            return gL;
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }

        public void destroySurface() {
            Log.w((String)"EglHelper", (String)("destroySurface()  tid=" + Thread.currentThread().getId()));
            this.destroySurfaceImp();
        }

        private void destroySurfaceImp() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLTextureView gLTextureView = (GLTextureView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (gLTextureView != null) {
                    gLTextureView.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public void finish() {
            Log.w((String)"EglHelper", (String)("finish() tid=" + Thread.currentThread().getId()));
            if (this.mEglContext != null) {
                GLTextureView gLTextureView = (GLTextureView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (gLTextureView != null) {
                    gLTextureView.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        private void throwEglException(String string) {
            EglHelper.throwEglException(string, this.mEgl.eglGetError());
        }

        public static void throwEglException(String string, int n2) {
            String string2 = EglHelper.formatEglError(string, n2);
            Log.e((String)"EglHelper", (String)("throwEglException tid=" + Thread.currentThread().getId() + " " + string2));
            throw new RuntimeException(string2);
        }

        public static void logEglErrorAsWarning(String string, String string2, int n2) {
            Log.w((String)string, (String)EglHelper.formatEglError(string2, n2));
        }

        public static String formatEglError(String string, int n2) {
            return string + " failed: " + n2;
        }
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean bl) {
            super(8, 8, 8, 0, bl ? 16 : 0, 0);
        }
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue;
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;

        public ComponentSizeChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
            super(new int[]{12324, n2, 12323, n3, 12322, n4, 12321, n5, 12325, n6, 12326, n7, 12344});
            this.mValue = new int[1];
            this.mRedSize = n2;
            this.mGreenSize = n3;
            this.mBlueSize = n4;
            this.mAlphaSize = n5;
            this.mDepthSize = n6;
            this.mStencilSize = n7;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n2 < this.mDepthSize || n3 < this.mStencilSize) continue;
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n4 != this.mRedSize || n5 != this.mGreenSize || n6 != this.mBlueSize || n7 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2, int n3) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n2, this.mValue)) {
                return this.mValue[0];
            }
            return n3;
        }
    }

    private abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] nArray) {
            this.mConfigSpec = this.filterConfigSpec(nArray);
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            if (!eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, null, 0, nArray)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int n2 = nArray[0];
            if (n2 <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n2];
            if (!eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, eGLConfigArray, n2, nArray)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig eGLConfig = this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
            if (eGLConfig == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return eGLConfig;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] nArray) {
            if (GLTextureView.this.mEGLContextClientVersion != 2) {
                return nArray;
            }
            int n2 = nArray.length;
            int[] nArray2 = new int[n2 + 2];
            System.arraycopy(nArray, 0, nArray2, 0, n2 - 1);
            nArray2[n2 - 1] = 12352;
            nArray2[n2] = 4;
            nArray2[n2 + 1] = 12344;
            return nArray2;
        }
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            EGLSurface eGLSurface = null;
            try {
                eGLSurface = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)GLTextureView.TAG, (String)"eglCreateWindowSurface", (Throwable)illegalArgumentException);
            }
            return eGLSurface;
        }

        @Override
        public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        @Override
        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, GLTextureView.this.mEGLContextClientVersion, 12344};
            return eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, (int[])(GLTextureView.this.mEGLContextClientVersion != 0 ? nArray : null));
        }

        @Override
        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            if (!eGL10.eglDestroyContext(eGLDisplay, eGLContext)) {
                Log.e((String)"DefaultContextFactory", (String)("display:" + eGLDisplay + " context: " + eGLContext));
                Log.i((String)"DefaultContextFactory", (String)("tid=" + Thread.currentThread().getId()));
                EglHelper.throwEglException("eglDestroyContex", eGL10.eglGetError());
            }
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);

        public void onSurfaceDestroyed(GL10 var1);
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }
}

