/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import io.agora.rtc.internal.ConnectionChangeBroadcastReceiver;
import io.agora.rtc.internal.Connectivity;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.internal.PowerConnectionReceiver;
import io.agora.rtc.internal.RtcEngineMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

class CommonUtility {
    private static final String TAG = CommonUtility.class.getSimpleName();
    private WeakReference<Context> mContext;
    private static WeakReference<Application> mApplication;
    private volatile boolean mAccessible = false;
    private AgoraPhoneStateListener mPhoneStateListener = null;
    private ConnectionChangeBroadcastReceiver mConnectionBroadcastReceiver = null;
    private BroadcastReceiver mOrientationObserver = null;
    private PowerConnectionReceiver mPowerConnectionReceiver = null;
    private long mBridgeHandle = 0L;
    private int mMobileType = -1;
    private int batteryPercentage = 255;
    private int mOrientation = -1;
    private boolean mLocalVideoEnabled = false;
    private static final int VIDEO_SOURCE_TYPE_NULL = 0;
    private static final int VIDEO_SOURCE_TYPE_DEFAULT = 1;
    private static final int VIDEO_SOURCE_TYPE_CUSTOMIZED = 2;
    private static final int VIDEO_SOURCE_TYPE_EXTERNAL_DEPRECATED = 3;
    private int mVideoSourceType = 1;
    private OrientationEventListener mOrientationListener = null;

    public CommonUtility(Context context, long l2) {
        this.mContext = new WeakReference<Context>(context);
        this.mBridgeHandle = l2;
        try {
            this.mPhoneStateListener = new AgoraPhoneStateListener();
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 288);
        }
        catch (Exception exception) {
            Logging.e(TAG, "Unable to create PhoneStateListener, ", exception);
        }
        this.monitorConnectionEvent(true);
        this.monitorPowerChange(true);
        this.monitorOrientationChange(context, true);
        this.mAccessible = true;
        Logging.i(TAG, "[init] done!");
    }

    public void destroy() {
        this.mAccessible = false;
        Context context = (Context)this.mContext.get();
        if (this.mPhoneStateListener != null && context != null) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 0);
            this.mPhoneStateListener = null;
        }
        this.monitorConnectionEvent(false);
        this.monitorPowerChange(false);
        this.monitorOrientationChange(context, false);
        this.mContext.clear();
        Logging.i(TAG, "[destroy] done!");
    }

    public int getNetworkType() {
        Context context = (Context)this.mContext.get();
        if (context == null || !this.mAccessible) {
            return -1;
        }
        if (CommonUtility.checkAccessNetworkState(context)) {
            return Connectivity.getNetworkType(context);
        }
        return -1;
    }

    public byte[] getNetworkInfo() {
        Context context = (Context)this.mContext.get();
        if (context == null || !this.mAccessible) {
            return null;
        }
        RtcEngineMessage.MediaNetworkInfo mediaNetworkInfo = this.doGetNetworkInfo(context);
        if (mediaNetworkInfo != null) {
            return mediaNetworkInfo.marshall();
        }
        return null;
    }

    public int getBatteryLifePercent() {
        Context context = (Context)this.mContext.get();
        if (context != null && this.mAccessible) {
            return this.batteryPercentage;
        }
        return 255;
    }

    public void onPhoneStateChanged(boolean bl, int n2, int n3) {
        if (this.mBridgeHandle == 0L || !this.mAccessible) {
            return;
        }
        this.nativeAudioRoutingPhoneChanged(this.mBridgeHandle, bl, n2, n3);
    }

    public void monitorConnectionEvent(boolean bl) {
        if (bl) {
            if (this.mConnectionBroadcastReceiver == null) {
                try {
                    this.mConnectionBroadcastReceiver = new ConnectionChangeBroadcastReceiver(this);
                    Context context = (Context)this.mContext.get();
                    if (context != null && this.mConnectionBroadcastReceiver != null) {
                        context.registerReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                    }
                }
                catch (Exception exception) {
                    Logging.e(TAG, "Unable to create ConnectionChangeBroadcastReceiver, ", exception);
                }
            }
        } else {
            try {
                Context context = (Context)this.mContext.get();
                if (context != null && this.mConnectionBroadcastReceiver != null) {
                    context.unregisterReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mConnectionBroadcastReceiver = null;
        }
    }

    public void monitorPowerChange(boolean bl) {
        if (bl) {
            if (this.mPowerConnectionReceiver == null) {
                try {
                    this.mPowerConnectionReceiver = new PowerConnectionReceiver(this);
                    Context context = (Context)this.mContext.get();
                    if (context != null && this.mPowerConnectionReceiver != null) {
                        IntentFilter intentFilter = new IntentFilter();
                        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
                        context.registerReceiver((BroadcastReceiver)this.mPowerConnectionReceiver, intentFilter);
                    }
                }
                catch (Exception exception) {
                    Logging.e(TAG, "Unable to create PowerConnectionReceiver, ", exception);
                }
            }
        } else {
            try {
                Context context = (Context)this.mContext.get();
                if (context != null && this.mPowerConnectionReceiver != null) {
                    context.unregisterReceiver((BroadcastReceiver)this.mPowerConnectionReceiver);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mPowerConnectionReceiver = null;
        }
    }

    public void notifyNetworkChange() {
        Context context = (Context)this.mContext.get();
        if (context == null || !this.mAccessible) {
            return;
        }
        byte[] byArray = this.getNetworkInfo();
        if (byArray == null || !this.mAccessible) {
            return;
        }
        this.nativeNotifyNetworkChange(this.mBridgeHandle, byArray);
    }

    public void onPowerChange(int n2) {
        Context context = (Context)this.mContext.get();
        if (context == null || !this.mAccessible) {
            return;
        }
        this.batteryPercentage = n2;
    }

    public int getFrontCameraIndex() {
        return DeviceUtils.selectFrontCamera();
    }

    public int getNumberOfCameras() {
        return DeviceUtils.getNumberOfCameras();
    }

    public int isSimulator() {
        int n2 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            if (Build.VERSION.SDK_INT < 26) {
                string2 = Build.SERIAL;
            } else if (Build.VERSION.SDK_INT <= 28) {
                string2 = Build.getSerial();
            }
            if (string2.toLowerCase().equals("unknown")) {
                Logging.i(TAG, "serial = " + string2 + ", suspectCount = " + ++n2);
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "get serial info fail.");
        }
        try {
            string3 = Build.MANUFACTURER;
            if (string3.toLowerCase().contains("netease")) {
                ++n2;
            }
            Logging.i(TAG, "manufacturer = " + string3);
        }
        catch (Exception exception) {
            Logging.e(TAG, "get manufacturer info fail.");
        }
        if (this.isSimulatorProperty()) {
            ++n2;
        }
        if (Build.VERSION.SDK_INT > 28) {
            if ("nokia".equalsIgnoreCase(string3) && ("Nokia_N1".equalsIgnoreCase(Build.DEVICE) || "N1".equalsIgnoreCase(Build.MODEL))) {
                return 0;
            }
            if (n2 > 0 && !string3.toLowerCase().contains("welldo")) {
                return 1;
            }
        } else if ((string2.toLowerCase().equals("unknown") || n2 > 0) && !string3.toLowerCase().contains("welldo")) {
            return 1;
        }
        return 0;
    }

    public int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    public int isSpeakerphoneEnabled(Context context) {
        if (context == null) {
            return 0;
        }
        AudioManager audioManager = this.getAudioManager(context);
        return audioManager.isSpeakerphoneOn() ? 1 : 0;
    }

    public static boolean canGetDefaultContext() {
        boolean bl = false;
        if (Looper.myLooper() == Looper.getMainLooper() || Build.VERSION.SDK_INT >= 18) {
            bl = true;
        }
        return bl;
    }

    private static String getAppPrivateStorageDir(Context context) {
        File file;
        if ("mounted".equals(Environment.getExternalStorageState()) && (file = context.getExternalFilesDir(null)) != null) {
            return file.getAbsolutePath();
        }
        return context.getFilesDir().getAbsolutePath();
    }

    public static byte[] getContextInfo(Context context) {
        if (context == null) {
            return null;
        }
        RtcEngineMessage.PAndroidContextInfo pAndroidContextInfo = new RtcEngineMessage.PAndroidContextInfo();
        pAndroidContextInfo.device = DeviceUtils.getDeviceId();
        pAndroidContextInfo.deviceInfo = DeviceUtils.getDeviceInfo();
        pAndroidContextInfo.systemInfo = DeviceUtils.getSystemInfo();
        pAndroidContextInfo.configDir = CommonUtility.getAppPrivateStorageDir(context);
        pAndroidContextInfo.dataDir = context.getCacheDir().getAbsolutePath();
        pAndroidContextInfo.pluginDir = context.getApplicationInfo().nativeLibraryDir;
        pAndroidContextInfo.androidID = "";
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo.device)) {
            pAndroidContextInfo.device = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo.deviceInfo)) {
            pAndroidContextInfo.deviceInfo = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo.systemInfo)) {
            pAndroidContextInfo.systemInfo = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo.configDir)) {
            pAndroidContextInfo.configDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo.dataDir)) {
            pAndroidContextInfo.dataDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo.pluginDir)) {
            pAndroidContextInfo.pluginDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)pAndroidContextInfo.androidID)) {
            pAndroidContextInfo.androidID = "";
        }
        return pAndroidContextInfo.marshall();
    }

    private static String getAndroidID(Context context) {
        return "";
    }

    public static String[] getLocalHostList() {
        try {
            Object object;
            Object object2;
            ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (NetworkInterface networkInterface : arrayList) {
                if (networkInterface.getName().startsWith("usb")) continue;
                object2 = Collections.list(networkInterface.getInetAddresses());
                object = object2.iterator();
                while (object.hasNext()) {
                    InetAddress inetAddress = (InetAddress)object.next();
                    String string = CommonUtility.inetAddressToIpAddress(inetAddress);
                    if (string == null) continue;
                    arrayList2.add(string);
                }
            }
            if (!arrayList2.isEmpty()) {
                String[] stringArray = new String[arrayList2.size()];
                int n2 = 0;
                object2 = arrayList2.iterator();
                while (object2.hasNext()) {
                    stringArray[n2] = object = (String)object2.next();
                    ++n2;
                }
                return stringArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getLocalHost() {
        try {
            ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : arrayList) {
                if (networkInterface.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> arrayList2 = Collections.list(networkInterface.getInetAddresses());
                for (InetAddress inetAddress : arrayList2) {
                    String string = CommonUtility.inetAddressToIpAddress(inetAddress);
                    if (string == null || string.isEmpty()) continue;
                    return string;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    private boolean isSimulatorProperty() {
        int n2 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = Build.MANUFACTURER;
        try {
            string = CommonUtility.getSystemProperty("ro.hardware");
            if (null == string || string.toLowerCase().equals("intel")) {
                ++n2;
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "get property hardware fail.");
        }
        Logging.i(TAG, "hardware = " + string + ", suspectCount = " + n2);
        try {
            string2 = System.getProperty("os.arch");
            if (null == string2 || string2.toLowerCase().equals("i686") && !string7.toLowerCase().contains("asus")) {
                Logging.i(TAG, "arch = " + string2 + ", suspectCount = " + ++n2);
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "get property arch fail.");
        }
        if (Build.VERSION.SDK_INT > 28) {
            if (string.toLowerCase().contains("ttvm")) {
                n2 += 10;
            } else if (string.toLowerCase().contains("nox")) {
                n2 += 10;
            }
            try {
                string4 = CommonUtility.getSystemProperty("ro.build.flavor");
                if (null == string4 || string4.contains("vbox") || string4.contains("sdk_gphone")) {
                    Logging.i(TAG, "buildFlavor = " + string4 + ", suspectCount = " + ++n2);
                }
            }
            catch (Exception exception) {
                Logging.e(TAG, "get property buildFlavor fail.");
            }
            try {
                string5 = CommonUtility.getSystemProperty("ro.product.board");
                if (null == string5 || string5.contains("android") | string5.contains("goldfish")) {
                    Logging.i(TAG, "productBoard = " + string5 + ", suspectCount = " + ++n2);
                }
            }
            catch (Exception exception) {
                Logging.e(TAG, "get property productBoard fail.");
            }
            try {
                string6 = CommonUtility.getSystemProperty("ro.board.platform");
                if (null == string6 || string6.contains("android")) {
                    Logging.i(TAG, "boardPlatform = " + string6 + ", suspectCount = " + ++n2);
                }
            }
            catch (Exception exception) {
                Logging.e(TAG, "get property boardPlatform fail.");
            }
        }
        return n2 > 0;
    }

    private void updateViewOrientation() {
        if (this.mContext.get() == null || !this.mAccessible) {
            Logging.e(TAG, "[updateViewOrientation] mContext is null or mAccessible is false!");
            return;
        }
        Display display = ((WindowManager)((Context)this.mContext.get()).getSystemService("window")).getDefaultDisplay();
        if (display == null) {
            Logging.e(TAG, "[updateViewOrientation] display is null!");
            return;
        }
        int n2 = display.getRotation();
        if (n2 == this.mOrientation) {
            return;
        }
        switch (n2) {
            case 0: {
                this.mOrientation = 0;
                this.nativeNotifyOrientationChange(this.mBridgeHandle, this.mOrientation);
                break;
            }
            case 1: {
                this.mOrientation = 1;
                this.nativeNotifyOrientationChange(this.mBridgeHandle, this.mOrientation);
                break;
            }
            case 2: {
                this.mOrientation = 2;
                this.nativeNotifyOrientationChange(this.mBridgeHandle, this.mOrientation);
                break;
            }
            case 3: {
                this.mOrientation = 3;
                this.nativeNotifyOrientationChange(this.mBridgeHandle, this.mOrientation);
            }
        }
    }

    private void checkOrientation(int n2) {
        if (n2 == -1 || !this.mAccessible) {
            return;
        }
        if (n2 > 340 || n2 < 20 || n2 > 70 && n2 < 110 || n2 > 160 && n2 < 200 || n2 > 250 && n2 < 290) {
            this.updateViewOrientation();
        }
    }

    private void monitorOrientationChange(Context context, boolean bl) {
        if (bl) {
            this.enableOrientationListener(context);
            this.regiseterBroadcaster(context);
        } else {
            this.disableOrientationListener();
            this.unregisterBroadcaster(context);
        }
    }

    private void enableOrientationListener(Context context) {
        try {
            if (this.mOrientationListener == null) {
                this.mOrientationListener = new OrientationEventListener(context, 2){

                    public void onOrientationChanged(int n2) {
                        if (n2 == -1) {
                            return;
                        }
                        CommonUtility.this.checkOrientation(n2);
                    }
                };
            }
            this.mOrientationListener.enable();
            Logging.i(TAG, "[enableOrientationListener] done!");
        }
        catch (Exception exception) {
            Logging.e(TAG, "Unable to create OrientationEventListener, ", exception);
        }
    }

    private void disableOrientationListener() {
        if (this.mOrientationListener != null) {
            this.mOrientationListener.disable();
            this.mOrientationListener = null;
            Logging.i(TAG, "[disableOrientationListener] done!");
        } else {
            Logging.e(TAG, "[disableOrientationListener] mOrientationListener is null!");
        }
    }

    private void regiseterBroadcaster(Context context) {
        if (context == null) {
            return;
        }
        this.mOrientationObserver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String string = intent.getAction();
                if (string.equals("android.intent.action.CONFIGURATION_CHANGED") && CommonUtility.this.mAccessible) {
                    CommonUtility.this.updateViewOrientation();
                }
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        context.registerReceiver(this.mOrientationObserver, intentFilter);
        Logging.i(TAG, "[regiseterBroadcaster] done!");
    }

    private void unregisterBroadcaster(Context context) {
        if (context == null || this.mOrientationObserver == null) {
            return;
        }
        context.unregisterReceiver(this.mOrientationObserver);
        Logging.i(TAG, "[unregisterBroadcaster] done!");
    }

    private AudioManager getAudioManager(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager;
    }

    private static String getSystemProperty(String string) throws Exception {
        Class<?> clazz = Class.forName("android.os.SystemProperties");
        return (String)clazz.getMethod("get", String.class).invoke(clazz, string);
    }

    private static boolean checkAccessNetworkState(Context context) {
        if (context == null) {
            return false;
        }
        int n2 = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        return n2 == 0;
    }

    private RtcEngineMessage.MediaNetworkInfo doGetNetworkInfo(Context context) {
        if (context == null || !this.mAccessible) {
            return null;
        }
        RtcEngineMessage.MediaNetworkInfo mediaNetworkInfo = new RtcEngineMessage.MediaNetworkInfo();
        if (!CommonUtility.checkAccessNetworkState(context)) {
            mediaNetworkInfo.ssid = "";
            mediaNetworkInfo.bssid = "";
            mediaNetworkInfo.rssi = 0;
            mediaNetworkInfo.signalLevel = 0;
            mediaNetworkInfo.frequency = 0;
            mediaNetworkInfo.linkspeed = 0;
            return mediaNetworkInfo;
        }
        String string = CommonUtility.getLocalHost();
        if (string != null) {
            mediaNetworkInfo.localIp4 = string;
        }
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        mediaNetworkInfo.networkType = Connectivity.getNetworkType(networkInfo);
        if (networkInfo != null) {
            mediaNetworkInfo.networkSubtype = networkInfo.getSubtype();
        }
        mediaNetworkInfo.dnsList = Connectivity.getDnsList();
        if (mediaNetworkInfo.networkType == 2) {
            Object object;
            if (!CommonUtility.checkAccessWifiState(context)) {
                mediaNetworkInfo.ssid = "";
                mediaNetworkInfo.bssid = "";
                mediaNetworkInfo.rssi = 0;
                mediaNetworkInfo.signalLevel = 0;
                mediaNetworkInfo.frequency = 0;
                mediaNetworkInfo.linkspeed = 0;
                return mediaNetworkInfo;
            }
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            if (dhcpInfo != null && (object = CommonUtility.intToInetAddress(dhcpInfo.gateway)) != null) {
                mediaNetworkInfo.gatewayIp4 = ((InetAddress)object).getHostAddress();
            }
            if ((object = wifiManager.getConnectionInfo()) != null) {
                mediaNetworkInfo.ssid = "";
                mediaNetworkInfo.bssid = "";
                mediaNetworkInfo.rssi = object.getRssi();
                mediaNetworkInfo.signalLevel = WifiManager.calculateSignalLevel((int)mediaNetworkInfo.rssi, (int)5);
                mediaNetworkInfo.linkspeed = object.getLinkSpeed();
                if (Build.VERSION.SDK_INT >= 21) {
                    int n2;
                    mediaNetworkInfo.frequency = n2 = object.getFrequency();
                    if (n2 >= 5000) {
                        mediaNetworkInfo.networkSubtype = 101;
                    } else if (n2 >= 2400) {
                        mediaNetworkInfo.networkSubtype = 100;
                    }
                }
            }
        } else if (this.mPhoneStateListener != null) {
            mediaNetworkInfo.rssi = this.mPhoneStateListener.getRssi();
            mediaNetworkInfo.signalLevel = this.mPhoneStateListener.getLevel();
            mediaNetworkInfo.asu = this.mPhoneStateListener.getAsuLevel();
        } else {
            String string2 = "android.permission.ACCESS_COARSE_LOCATION";
            if (Build.VERSION.SDK_INT >= 29) {
                string2 = "android.permission.ACCESS_FINE_LOCATION";
            }
            if (context.checkCallingOrSelfPermission(string2) == 0) {
                this.getSignalStrength(context, mediaNetworkInfo);
            }
        }
        return mediaNetworkInfo;
    }

    private static String inetAddressToIpAddress(InetAddress inetAddress) {
        if (!inetAddress.isLoopbackAddress()) {
            if (inetAddress instanceof Inet4Address) {
                Inet4Address inet4Address = (Inet4Address)inetAddress;
                return inet4Address.getHostAddress();
            }
            if (inetAddress instanceof Inet6Address) {
                // empty if block
            }
        }
        return null;
    }

    private static boolean checkAccessWifiState(Context context) {
        if (context == null) {
            return false;
        }
        int n2 = context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE");
        return n2 == 0;
    }

    private static InetAddress intToInetAddress(int n2) {
        byte[] byArray = new byte[]{(byte)(0xFF & n2), (byte)(0xFF & n2 >> 8), (byte)(0xFF & n2 >> 16), (byte)(0xFF & n2 >> 24)};
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @TargetApi(value=17)
    private boolean getSignalStrength(Context context, RtcEngineMessage.MediaNetworkInfo mediaNetworkInfo) {
        CellSignalStrengthGsm cellSignalStrengthGsm;
        if (context == null || Build.VERSION.SDK_INT < 17) {
            this.mMobileType = -1;
            return false;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        List list = telephonyManager.getAllCellInfo();
        if (list == null || list.isEmpty()) {
            return false;
        }
        CellInfo cellInfo = (CellInfo)list.get(0);
        if (cellInfo == null) {
            return false;
        }
        try {
            if ((this.mMobileType == -1 || this.mMobileType == 0) && (cellSignalStrengthGsm = ((CellInfoGsm)cellInfo).getCellSignalStrength()) != null) {
                this.mMobileType = 0;
                mediaNetworkInfo.rssi = cellSignalStrengthGsm.getDbm();
                mediaNetworkInfo.signalLevel = cellSignalStrengthGsm.getLevel();
                mediaNetworkInfo.asu = cellSignalStrengthGsm.getAsuLevel();
                return true;
            }
        }
        catch (Exception exception) {
            this.mMobileType = -1;
        }
        try {
            if ((this.mMobileType == -1 || this.mMobileType == 1) && (cellSignalStrengthGsm = ((CellInfoCdma)cellInfo).getCellSignalStrength()) != null) {
                this.mMobileType = 1;
                mediaNetworkInfo.rssi = cellSignalStrengthGsm.getDbm();
                mediaNetworkInfo.signalLevel = cellSignalStrengthGsm.getLevel();
                mediaNetworkInfo.asu = cellSignalStrengthGsm.getAsuLevel();
                return true;
            }
        }
        catch (Exception exception) {
            this.mMobileType = -1;
        }
        try {
            if (this.mMobileType == -1 || this.mMobileType == 2) {
                if (Build.VERSION.SDK_INT < 18) {
                    return false;
                }
                cellSignalStrengthGsm = ((CellInfoWcdma)cellInfo).getCellSignalStrength();
                if (cellSignalStrengthGsm != null) {
                    this.mMobileType = 2;
                    mediaNetworkInfo.rssi = cellSignalStrengthGsm.getDbm();
                    mediaNetworkInfo.signalLevel = cellSignalStrengthGsm.getLevel();
                    mediaNetworkInfo.asu = cellSignalStrengthGsm.getAsuLevel();
                    return true;
                }
            }
        }
        catch (Exception exception) {
            this.mMobileType = -1;
        }
        try {
            if ((this.mMobileType == -1 || this.mMobileType == 3) && (cellSignalStrengthGsm = ((CellInfoLte)cellInfo).getCellSignalStrength()) != null) {
                this.mMobileType = 3;
                mediaNetworkInfo.rssi = cellSignalStrengthGsm.getDbm();
                mediaNetworkInfo.signalLevel = cellSignalStrengthGsm.getLevel();
                mediaNetworkInfo.asu = cellSignalStrengthGsm.getAsuLevel();
                return true;
            }
        }
        catch (Exception exception) {
            this.mMobileType = -1;
        }
        return false;
    }

    private static String getAppStorageDir(Context context) {
        if (context != null) {
            int n2 = context.checkCallingOrSelfPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (n2 == 0) {
                return "/sdcard/" + context.getApplicationInfo().packageName;
            }
            Logging.w(TAG, "read external storage is not granted");
        }
        return null;
    }

    private void checkVoipPermissions(Context context, String string) throws SecurityException {
        if (context == null || context.checkCallingOrSelfPermission(string) != 0) {
            throw new SecurityException(string + " is not granted");
        }
    }

    private void checkVoipPermissions(Context context) throws SecurityException {
        this.checkVoipPermissions(context, "android.permission.INTERNET");
        this.checkVoipPermissions(context, "android.permission.RECORD_AUDIO");
        this.checkVoipPermissions(context, "android.permission.MODIFY_AUDIO_SETTINGS");
        if (this.mVideoSourceType == 1 && this.mLocalVideoEnabled) {
            this.checkVoipPermissions(context, "android.permission.CAMERA");
        }
    }

    private int checkVoipPermissions(Context context, int n2) {
        switch (n2) {
            case 1: {
                try {
                    this.checkVoipPermissions(context);
                    break;
                }
                catch (SecurityException securityException) {
                    Logging.e(TAG, "Do not have enough permission! ", securityException);
                    return -9;
                }
            }
            case 2: {
                try {
                    this.checkVoipPermissions(context, "android.permission.INTERNET");
                    break;
                }
                catch (SecurityException securityException) {
                    Logging.e(TAG, "Do not have Internet permission!");
                    return -9;
                }
            }
            default: {
                return -2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssetsCacheFile(Context context, String string) {
        Logging.i(TAG, "getAssetsCacheFile filePath: " + string);
        try {
            String string2 = "wm_" + string.replace(File.separator, "_");
            File file = new File(context.getCacheDir(), string2);
            if (file.exists()) {
                file.delete();
            }
            try (InputStream inputStream = context.getAssets().open(string);
                 FileOutputStream fileOutputStream = new FileOutputStream(file);){
                int n2;
                byte[] byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
            }
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void updateLocalVideoEnableState(boolean bl) {
        Logging.d(TAG, "updateLocalVideoEnableState: " + bl);
        this.mLocalVideoEnabled = bl;
    }

    public void updateVideoSourceType(int n2) {
        Logging.d(TAG, "updateVideoSourceType: " + n2);
        this.mVideoSourceType = n2;
    }

    private native void nativeAudioRoutingPhoneChanged(long var1, boolean var3, int var4, int var5);

    private native int nativeNotifyNetworkChange(long var1, byte[] var3);

    private native int nativeNotifyOrientationChange(long var1, int var3);

    private class AgoraPhoneStateListener
    extends PhoneStateListener {
        private SignalStrength mSignalStrenth;
        private boolean phoneStatusNeedResume = false;

        public int getRssi() {
            int n2 = 0;
            if (Build.VERSION.SDK_INT <= 28) {
                n2 = this.invokeMethod("getDbm");
            }
            return n2;
        }

        public int getLevel() {
            return this.invokeMethod("getLevel");
        }

        public int getAsuLevel() {
            int n2 = 0;
            if (Build.VERSION.SDK_INT <= 28) {
                n2 = this.invokeMethod("getAsuLevel");
            }
            return n2;
        }

        private int invokeMethod(String string) {
            try {
                Method method;
                if (this.mSignalStrenth != null && (method = this.mSignalStrenth.getClass().getDeclaredMethod(string, new Class[0])) != null) {
                    return (Integer)method.invoke((Object)this.mSignalStrenth, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            Context context = (Context)CommonUtility.this.mContext.get();
            if (context == null || !CommonUtility.this.mAccessible) {
                return;
            }
            super.onSignalStrengthsChanged(signalStrength);
            this.mSignalStrenth = signalStrength;
        }

        public void onCallStateChanged(int n2, String string) {
            Context context = (Context)CommonUtility.this.mContext.get();
            if (context == null || !CommonUtility.this.mAccessible) {
                return;
            }
            super.onCallStateChanged(n2, string);
            switch (n2) {
                case 0: {
                    if (!this.phoneStatusNeedResume) break;
                    this.phoneStatusNeedResume = false;
                    Logging.i(TAG, "system phone call end delay 1000ms");
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CommonUtility.this.onPhoneStateChanged(true, 22, 0);
                            }
                            catch (Exception exception) {
                                Logging.e(TAG, "fail to resume ", exception);
                            }
                        }
                    }, 1000L);
                    break;
                }
                case 1: {
                    Logging.i(TAG, "system phone call ring");
                    this.phoneStatusNeedResume = true;
                    CommonUtility.this.onPhoneStateChanged(false, 22, 1);
                    break;
                }
                case 2: {
                    Logging.i(TAG, "system phone call start");
                    this.phoneStatusNeedResume = true;
                    CommonUtility.this.onPhoneStateChanged(false, 22, 2);
                    break;
                }
            }
        }
    }

    public static class MobileType {
        public static final int Unknown = -1;
        public static final int Gsm = 0;
        public static final int Cdma = 1;
        public static final int Wcdma = 2;
        public static final int Lte = 3;
    }
}

