/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.mediaio.SurfaceTextureHelper;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;

    public TextureBufferImpl(int n2, int n3, VideoFrame.TextureBuffer.Type type, int n4, Matrix matrix, SurfaceTextureHelper surfaceTextureHelper, Runnable runnable) {
        this.width = n2;
        this.height = n3;
        this.type = type;
        this.id = n4;
        this.transformMatrix = matrix;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.releaseCallback = runnable;
        this.refCount = 1;
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return this.surfaceTextureHelper.textureToYuv(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.retain();
        Matrix matrix = new Matrix(this.transformMatrix);
        matrix.postScale((float)n4 / (float)this.width, (float)n5 / (float)this.height);
        matrix.postTranslate((float)n2 / (float)this.width, (float)n3 / (float)this.height);
        return new TextureBufferImpl(n6, n7, this.type, this.id, matrix, this.surfaceTextureHelper, new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        });
    }
}

