/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.impl;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.ScreenCaptureParameters;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.ss.aidl.INotification;
import io.agora.rtc.ss.aidl.IScreenSharing;
import io.agora.rtc.ss.impl.NotificationHelper;
import io.agora.rtc.ss.impl.ScreenSharing;

public class ScreenSharingService
extends Service {
    private static final String LOG_TAG = ScreenSharingService.class.getSimpleName();
    private ScreenSharing mScreenSharing;
    private RtcEngine mRtcEngine;
    private RemoteCallbackList<INotification> mCallbacks = new RemoteCallbackList();
    private final IScreenSharing.Stub mBinder = new IScreenSharing.Stub(){

        @Override
        public void registerCallback(INotification cb) {
            Log.d((String)LOG_TAG, (String)"registerCallback: ");
            if (cb != null) {
                ScreenSharingService.this.mCallbacks.register((IInterface)cb);
            }
        }

        @Override
        public void unregisterCallback(INotification cb) {
            if (cb != null) {
                ScreenSharingService.this.mCallbacks.unregister((IInterface)cb);
            }
        }

        @Override
        public void startShare() {
            if (ScreenSharingService.this.screenCaptureParameters == null) {
                Logging.e((String)"cannot find screen capture parameters in intent");
                throw new IllegalArgumentException("cannot find screen capture parameters in intent");
            }
            ScreenSharingService.this.mScreenSharing.init(ScreenSharingService.this.screenCaptureParameters);
            ScreenSharingService.this.startCapture();
        }

        @Override
        public void stopShare() {
            ScreenSharingService.this.stopCapture();
        }

        @Override
        public void renewToken(String token) {
        }

        @Override
        public void enableScreenCapture(boolean enable) throws RemoteException {
            if (ScreenSharingService.this.mScreenSharing != null) {
                ScreenSharingService.this.mScreenSharing.enableScreenCapture(enable);
            }
        }

        @Override
        public void enableAudioCapture(boolean enable) throws RemoteException {
            if (ScreenSharingService.this.mScreenSharing != null) {
                ScreenSharingService.this.mScreenSharing.enableAudioCapture(enable);
            }
        }
    };
    private ScreenCaptureParameters screenCaptureParameters;

    public void onConfigurationChanged(Configuration newConfig) {
        Log.d((String)LOG_TAG, (String)"onConfigurationChanged");
    }

    private void startCapture() {
        Log.i((String)"xzm", (String)"startCapture");
        this.mScreenSharing.startCapture();
        this.startForeground(55431, this.getForeNotification());
    }

    public Notification getForeNotification() {
        String eventTitle = "Title";
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, NotificationHelper.generateChannelId((Context)this.getApplication(), 55431)).setContentTitle((CharSequence)eventTitle).setContentText((CharSequence)eventTitle);
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setColor(this.getResources().getColor(17170444));
        }
        Notification notification = builder.build();
        notification.flags |= 2;
        return notification;
    }

    private void stopCapture() {
        this.stopForeground(true);
        this.mScreenSharing.stopCapture();
    }

    public void onCreate() {
        this.mScreenSharing = new ScreenSharing(this.getApplicationContext(), this.mRtcEngine);
        this.mScreenSharing.setResultCallback(new ScreenSharing.ResultCallback(){

            @Override
            public void onResult(int event, int errorcode) {
                Log.d((String)LOG_TAG, (String)"onResult: begine called ");
                int N = ScreenSharingService.this.mCallbacks.beginBroadcast();
                for (int i = 0; i < N; ++i) {
                    try {
                        Log.d((String)LOG_TAG, (String)"onResult: for callback ");
                        ((INotification)ScreenSharingService.this.mCallbacks.getBroadcastItem(i)).onEvent(event, errorcode);
                        continue;
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
                ScreenSharingService.this.mCallbacks.finishBroadcast();
            }
        });
    }

    public IBinder onBind(Intent intent) {
        Log.i((String)"xzm", (String)"onBind");
        this.screenCaptureParameters = (ScreenCaptureParameters)intent.getSerializableExtra("capture_params");
        return this.mBinder;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mScreenSharing.destroy();
    }
}

