/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.impl;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.ScreenCaptureParameters;
import io.agora.rtc.internal.ExternalScreenSharingCallback;
import io.agora.rtc.ss.R;
import io.agora.rtc.ss.impl.NotificationHelper;
import io.agora.rtc.ss.impl.ScreenSharing;

public class LocalScreenSharingService
extends Service {
    private static final String LOG_TAG = "LocalScreenService";
    private ScreenSharing mScreenSharing;
    private RtcEngine mRtcEngine;
    private ExternalScreenSharingCallback externalScreenSharingCallback;
    private ScreenCaptureParameters screenCaptureParameters;

    public void onConfigurationChanged(Configuration newConfig) {
        Log.d((String)LOG_TAG, (String)"onConfigurationChanged");
    }

    public void updateVideoCaptureParameters(ScreenCaptureParameters.VideoCaptureParameters videoCaptureParameters) {
        this.mScreenSharing.updateVideoCaptureParameters(videoCaptureParameters);
    }

    public void setExternalScreenSharingCallback(ExternalScreenSharingCallback externalScreenSharingCallback) {
        this.externalScreenSharingCallback = externalScreenSharingCallback;
    }

    public void setRtcEngine(RtcEngine mRtcEngine) {
        this.mRtcEngine = mRtcEngine;
        this.mScreenSharing.setRtcEngine(mRtcEngine);
    }

    public void startCapture() {
        Log.i((String)LOG_TAG, (String)("startCapture + " + Thread.currentThread().getName()));
        if (this.screenCaptureParameters != null) {
            this.mScreenSharing.init(this.screenCaptureParameters);
            this.mScreenSharing.startCapture();
        } else {
            Log.i((String)LOG_TAG, (String)"startCapture: screenCaptureParameters is null");
        }
        Notification notification = this.getForeNotification();
        this.startForeground(55431, notification);
    }

    public void enableScreenCapture(boolean enable) {
        if (this.mScreenSharing != null) {
            this.mScreenSharing.enableScreenCapture(enable);
        }
    }

    public void enableAudioCapture(boolean enable) {
        if (this.mScreenSharing != null) {
            this.mScreenSharing.enableAudioCapture(enable);
        }
    }

    public Notification getForeNotification() {
        Notification.Builder builder = Build.VERSION.SDK_INT >= 26 ? new Notification.Builder((Context)this, NotificationHelper.generateChannelId((Context)this.getApplication(), 55431)) : new Notification.Builder((Context)this);
        builder.setCategory("service").setSmallIcon(R.drawable.small_icon).setAutoCancel(false).setVisibility(1);
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setColor(this.getResources().getColor(17170444));
        }
        Notification notification = builder.build();
        notification.flags |= 2;
        notification.flags |= 0x40;
        return notification;
    }

    public void stopCapture() {
        this.stopForeground(true);
        this.mScreenSharing.stopCapture();
    }

    public void refreshToken(String token) {
        if (this.mRtcEngine != null) {
            this.mRtcEngine.renewToken(token);
        } else {
            Log.e((String)LOG_TAG, (String)"rtc engine is null");
        }
    }

    public void onCreate() {
        this.mScreenSharing = new ScreenSharing(this.getApplicationContext(), this.mRtcEngine);
        this.mScreenSharing.setResultCallback(new ScreenSharing.ResultCallback(){

            @Override
            public void onResult(int event, int errorcode) {
                if (LocalScreenSharingService.this.externalScreenSharingCallback != null) {
                    LocalScreenSharingService.this.externalScreenSharingCallback.onExtenalScreenCaptureEvent(event, errorcode);
                }
            }
        });
    }

    public IBinder onBind(Intent intent) {
        Log.i((String)LOG_TAG, (String)"onBind");
        this.screenCaptureParameters = (ScreenCaptureParameters)intent.getSerializableExtra("capture_params");
        return new LocalBinder();
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)LOG_TAG, (String)"onDestroy: ");
        this.mScreenSharing.destroy();
    }

    public class LocalBinder
    extends Binder {
        public LocalScreenSharingService getService() {
            return LocalScreenSharingService.this;
        }
    }
}

