/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.gles;

import android.view.Surface;
import io.agora.rtc.ss.gles.SinkConnector;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class SrcConnector<T> {
    private LinkedList<SinkConnector<T>> plugList = new LinkedList();
    private Object mFormat;

    public synchronized boolean isConnected() {
        return !this.plugList.isEmpty();
    }

    public synchronized void connect(SinkConnector<T> sink) {
        if (!this.plugList.contains(sink)) {
            this.plugList.add(sink);
            sink.onConnected();
            if (this.mFormat != null) {
                sink.onFormatChanged(this.mFormat);
            }
        }
    }

    public synchronized void onFormatChanged(Object format) {
        this.mFormat = format;
        for (SinkConnector sinkConnector : this.plugList) {
            sinkConnector.onFormatChanged(format);
        }
    }

    public synchronized void onFrameAvailable(T frame, ByteBuffer byteBuffer) {
        for (SinkConnector sinkConnector : this.plugList) {
            sinkConnector.onFrameAvailable(frame, byteBuffer);
        }
    }

    public synchronized void setSurface(Surface surface) {
        for (SinkConnector sinkConnector : this.plugList) {
            sinkConnector.setSurface(surface);
        }
    }

    public synchronized void disconnect() {
        this.disconnect(null);
    }

    public synchronized void disconnect(SinkConnector<T> sink) {
        if (sink != null) {
            sink.onDisconnect();
            this.plugList.remove(sink);
        } else {
            for (SinkConnector sinkConnector : this.plugList) {
                sinkConnector.onDisconnect();
            }
            this.plugList.clear();
        }
    }
}

