/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.gles;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import android.view.TextureView;
import io.agora.rtc.ss.gles.EglCore;
import io.agora.rtc.ss.gles.WindowSurface;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLRender {
    private static final String TAG = "GLRender";
    private static final boolean DEBUG_ENABLED = true;
    public static final int STATE_IDLE = 0;
    public static final int STATE_READY = 1;
    public static final int STATE_RELEASED = 2;
    private static final int MSG_TYPE_SURFACE_CREATED = 0;
    private static final int MSG_TYPE_SURFACE_CHANGED = 1;
    private static final int MSG_TYPE_DRAW_FRAME = 2;
    private static final int MSG_TYPE_QUIT = 3;
    private HandlerThread mGLHandlerThread;
    private Handler mGLHandler;
    private TextureView mTextureView;
    private EglCore mEglCore;
    private WindowSurface mWindowSurface;
    private EGLContext mEGLContext;
    private GLSurfaceView mGLSurfaceView;
    private AtomicInteger mState;
    private long mThreadId;
    private LinkedList<GLRenderListener> mGLRenderListenerList;
    private final Object mRenderListenerLock = new Object();
    private LinkedList<Runnable> mEventTaskList;
    private final Object mEventLock = new Object();
    private LinkedList<Runnable> mGLDrawTaskList;
    private final Object mDrawLock = new Object();
    private Runnable runnableDrawFrame = new Runnable(){

        @Override
        public void run() {
            GLRender.this.doDrawFrame();
        }
    };
    private GLSurfaceView.Renderer mGLRenderer = new GLSurfaceView.Renderer(){

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            GLRender.this.surfaceCreated(true);
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            GLRender.this.surfaceChanged(width, height);
        }

        public void onDrawFrame(GL10 gl) {
            GLRender.this.drawFrame();
        }
    };
    private TextureView.SurfaceTextureListener mTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            Log.d((String)GLRender.TAG, (String)("onSurfaceTextureAvailable " + surface + " " + width + " " + height));
            GLRender.this.initHandlerThread();
            Message msg = Message.obtain((Handler)GLRender.this.mGLHandler, (int)0, (Object)surface);
            GLRender.this.mGLHandler.sendMessage(msg);
            msg = Message.obtain((Handler)GLRender.this.mGLHandler, (int)1, (int)width, (int)height);
            GLRender.this.mGLHandler.sendMessage(msg);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            Log.d((String)GLRender.TAG, (String)("onSurfaceTextureSizeChanged " + surface + " " + width + " " + height));
            Message msg = Message.obtain((Handler)GLRender.this.mGLHandler, (int)1, (int)width, (int)height);
            GLRender.this.mGLHandler.sendMessage(msg);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture st) {
            Log.d((String)GLRender.TAG, (String)("onSurfaceTextureDestroyed " + st));
            GLRender.this.quit(st);
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture st) {
        }
    };

    public GLRender() {
        this.doInit(EGL14.EGL_NO_CONTEXT);
    }

    public GLRender(EGLContext ctx) {
        this.doInit(ctx);
    }

    private void doInit(EGLContext ctx) {
        this.mState = new AtomicInteger(2);
        this.mGLRenderListenerList = new LinkedList();
        this.mEventTaskList = new LinkedList();
        this.mGLDrawTaskList = new LinkedList();
        this.mEGLContext = ctx;
    }

    public void init(int width, int height) {
        this.mState.set(0);
        this.initHandlerThread();
        Message msg = Message.obtain((Handler)this.mGLHandler, (int)0, (int)width, (int)height);
        this.mGLHandler.sendMessage(msg);
        msg = Message.obtain((Handler)this.mGLHandler, (int)1, (int)width, (int)height);
        this.mGLHandler.sendMessage(msg);
    }

    public void init(GLSurfaceView sv) {
        this.mState.set(0);
        sv.setEGLContextClientVersion(2);
        sv.setRenderer(this.mGLRenderer);
        sv.setRenderMode(0);
        this.mGLSurfaceView = sv;
    }

    public void init(TextureView tv) {
        this.mState.set(0);
        tv.setSurfaceTextureListener(this.mTextureListener);
        this.mTextureView = tv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(GLRenderListener listener) {
        Object object = this.mRenderListenerLock;
        synchronized (object) {
            if (!this.mGLRenderListenerList.contains(listener)) {
                this.mGLRenderListenerList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(GLRenderListener listener) {
        Object object = this.mRenderListenerLock;
        synchronized (object) {
            this.mGLRenderListenerList.remove(listener);
        }
    }

    public int getState() {
        return this.mState.get();
    }

    public EGLContext getEGLContext() {
        return this.mEGLContext;
    }

    public boolean isGLRenderThread() {
        return this.mThreadId == Thread.currentThread().getId();
    }

    public void onPause() {
        if (this.mGLSurfaceView != null) {
            this.mState.set(2);
            this.mGLSurfaceView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    GLRender.this.quit();
                }
            });
            this.mGLSurfaceView.onPause();
        }
    }

    public void onResume() {
        if (this.mState.get() == 2) {
            this.mState.set(0);
        }
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.onResume();
        }
    }

    public void requestRender() {
        if (this.mGLSurfaceView != null) {
            // empty if block
        }
        if (this.mGLHandler != null) {
            this.mGLHandler.sendEmptyMessage(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(Runnable runnable) {
        if (this.mState.get() == 0) {
            Log.d((String)TAG, (String)("glContext not ready, queue event: " + runnable));
            Object object = this.mEventLock;
            synchronized (object) {
                this.mEventTaskList.add(runnable);
            }
        } else if (this.mState.get() == 1) {
            if (this.mGLSurfaceView != null) {
                this.mGLSurfaceView.queueEvent(runnable);
                this.mGLSurfaceView.queueEvent(this.runnableDrawFrame);
            } else if (this.mGLHandler != null) {
                this.mGLHandler.post(runnable);
                this.mGLHandler.post(this.runnableDrawFrame);
            }
        } else {
            Log.d((String)TAG, (String)("glContext lost, drop event: " + runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueDrawFrameAppends(Runnable runnable) {
        if (this.mState.get() == 1) {
            Object object = this.mDrawLock;
            synchronized (object) {
                this.mGLDrawTaskList.add(runnable);
            }
        }
    }

    public void quit() {
        if (this.mTextureView == null && this.mGLSurfaceView == null && this.mGLHandlerThread != null) {
            this.mState.set(2);
            this.quit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void surfaceCreated(boolean reInitCtx) {
        this.mState.set(1);
        this.mThreadId = Thread.currentThread().getId();
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        if (reInitCtx && Build.VERSION.SDK_INT >= 17) {
            this.mEGLContext = EGL14.eglGetCurrentContext();
        }
        Object object = this.mRenderListenerLock;
        synchronized (object) {
            for (GLRenderListener listener : this.mGLRenderListenerList) {
                listener.onReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void surfaceChanged(int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        Object object = this.mRenderListenerLock;
        synchronized (object) {
            for (GLRenderListener listener : this.mGLRenderListenerList) {
                listener.onSizeChanged(width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFrame() {
        Object object = this.mEventLock;
        synchronized (object) {
            Iterator it = this.mEventTaskList.iterator();
            while (true) {
                if (!it.hasNext()) break;
                Runnable runnable = (Runnable)it.next();
                runnable.run();
            }
            this.mEventTaskList.clear();
        }
        object = this.mRenderListenerLock;
        synchronized (object) {
            for (GLRenderListener listener : this.mGLRenderListenerList) {
                listener.onDrawFrame();
            }
        }
        this.doDrawFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        if (Build.VERSION.SDK_INT >= 17) {
            this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        }
        this.mState.set(2);
        Object object = this.mRenderListenerLock;
        synchronized (object) {
            for (GLRenderListener listener : this.mGLRenderListenerList) {
                listener.onReleased();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDrawFrame() {
        while (true) {
            Runnable runnable;
            Object object = this.mDrawLock;
            synchronized (object) {
                if (this.mGLDrawTaskList.isEmpty()) {
                    return;
                }
                runnable = this.mGLDrawTaskList.getFirst();
                this.mGLDrawTaskList.removeFirst();
            }
            runnable.run();
        }
    }

    private void prepareGlSurface(SurfaceTexture st, int width, int height) {
        this.mEglCore = new EglCore(this.mEGLContext, 0);
        this.mWindowSurface = st != null ? new WindowSurface(this.mEglCore, st) : new WindowSurface(this.mEglCore, width, height);
        this.mWindowSurface.makeCurrent();
        GLES20.glViewport((int)0, (int)0, (int)this.mWindowSurface.getWidth(), (int)this.mWindowSurface.getHeight());
    }

    private void releaseGlSurface(SurfaceTexture st) {
        if (st != null) {
            st.release();
        }
        if (this.mWindowSurface != null) {
            this.mWindowSurface.release();
            this.mWindowSurface = null;
        }
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    private void initHandlerThread() {
        if (this.mGLHandlerThread == null) {
            this.mGLHandlerThread = new HandlerThread("MyGLThread");
            this.mGLHandlerThread.start();
            this.mGLHandler = new Handler(this.mGLHandlerThread.getLooper(), new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            GLRender.this.prepareGlSurface((SurfaceTexture)msg.obj, msg.arg1, msg.arg2);
                            GLRender.this.surfaceCreated(true);
                            break;
                        }
                        case 1: {
                            GLRender.this.surfaceChanged(msg.arg1, msg.arg2);
                            break;
                        }
                        case 2: {
                            GLRender.this.drawFrame();
                            GLRender.this.mWindowSurface.swapBuffers();
                            break;
                        }
                        case 3: {
                            GLRender.this.release();
                            GLRender.this.releaseGlSurface((SurfaceTexture)msg.obj);
                            GLRender.this.mGLHandlerThread.quit();
                        }
                    }
                    return true;
                }
            });
        }
    }

    public void update(int width, int height) {
        Message msg = Message.obtain((Handler)this.mGLHandler, (int)1, (int)width, (int)height);
        if (this.mGLHandler != null) {
            this.mGLHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quit(SurfaceTexture st) {
        if (this.mGLHandlerThread != null) {
            this.mGLHandler.removeCallbacksAndMessages(null);
            Message msg = Message.obtain((Handler)this.mGLHandler, (int)3, (Object)st);
            this.mGLHandler.sendMessage(msg);
            try {
                this.mGLHandlerThread.join();
            }
            catch (InterruptedException e) {
                Log.d((String)TAG, (String)("quit " + Log.getStackTraceString((Throwable)e)));
            }
            finally {
                this.mGLHandlerThread = null;
                this.mGLHandler = null;
            }
        }
    }

    public static interface GLRenderListener {
        public void onReady();

        public void onSizeChanged(int var1, int var2);

        public void onDrawFrame();

        public void onReleased();
    }

    public static interface ScreenshotListener {
        public void onBitmapAvailable(Bitmap var1);
    }
}

