/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.ATrace;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.GLRendererController;
import io.agora.rtc.video.TextureRenderer;

public class TextureRendererHelper {
    private static String TAG = "TextureRendererHelper";
    private static final boolean VERBOSE = false;
    private EglBase eglBase = null;
    private boolean eglAttached = false;
    private GlRectDrawer drawer = null;
    private int oesTextureId = -1;
    private SurfaceTexture surfaceTexture = null;
    private boolean surfaceTextureRecreated = false;
    private TextureRenderer textureRenderer = null;
    private TextureFrame textureFrame = null;
    private Surface surface = null;
    private int oldWidth = -1;
    private int oldHeight = -1;
    private Object localRealEglContext = null;
    private int localEglType = -1;
    private volatile boolean textureSourceIncoming = false;

    public boolean isTextureSourceIncoming() {
        return this.textureSourceIncoming;
    }

    public void setTextureSourceIncoming(boolean bl) {
        this.textureSourceIncoming = bl;
    }

    public boolean useJavaRender() {
        return false;
    }

    public TextureFrame getTextureFrame() {
        if (this.textureFrame != null) {
            this.textureFrame.texId = this.oesTextureId;
            this.textureFrame.textureType = 1;
        }
        return this.textureFrame;
    }

    public void onTextureFrameArrived(VideoFrame.TextureBuffer textureBuffer, int n2, long l2, long l3, boolean bl) {
        if (textureBuffer == null) {
            Logging.e(TAG, "texture buffer is null.");
            return;
        }
        textureBuffer.retain();
        if (this.surfaceTexture == null || this.surface == null) {
            Logging.w(TAG, "frame is ready, but the gl renderer thread is not ready yet.");
            this.releaseProducerResourceIfNotYet();
            textureBuffer.release();
            return;
        }
        if (!textureBuffer.getRealEglContext().equals(this.localRealEglContext) || textureBuffer.getEglType() != this.localEglType) {
            this.localRealEglContext = textureBuffer.getRealEglContext();
            this.localEglType = textureBuffer.getEglType();
            this.releaseProducerResourceIfNotYet();
        }
        if (this.oldWidth != textureBuffer.getWidth() || this.oldHeight != textureBuffer.getHeight()) {
            this.oldWidth = textureBuffer.getWidth();
            this.oldHeight = textureBuffer.getHeight();
            this.surfaceTexture.setDefaultBufferSize(textureBuffer.getWidth(), textureBuffer.getHeight());
            this.releaseProducerResourceIfNotYet();
        }
        if (this.surfaceTextureRecreated) {
            this.releaseProducerResourceIfNotYet();
            this.surfaceTextureRecreated = false;
        }
        ATrace.beginSection("prepare@render");
        this.createProducerResourceIfNeeded(textureBuffer.getEglBaseContext());
        ATrace.endSection();
        if (this.textureFrame == null) {
            this.textureFrame = new TextureFrame();
        }
        int n3 = textureBuffer.getTextureId();
        VideoFrame.TextureBuffer.Type type = textureBuffer.getType();
        int n4 = textureBuffer.getWidth();
        int n5 = textureBuffer.getHeight();
        Matrix matrix = textureBuffer.getTransformMatrix();
        float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix);
        this.textureFrame.frameWidth = textureBuffer.getWidth();
        this.textureFrame.frameHeight = textureBuffer.getHeight();
        this.textureFrame.rotation = n2;
        this.textureFrame.renderMs = l2;
        this.textureFrame.firstRecvTimestamp = l3;
        this.textureFrame.isDummy = bl;
        try {
            ATrace.beginSection("makeCurrent@render");
            if (!this.eglAttached) {
                Logging.i(TAG, "attaching egl context, this: " + this.hashCode() + ", thread id: " + Thread.currentThread().getId());
                this.eglBase.makeCurrent();
                this.eglAttached = true;
            }
            ATrace.endSection();
            ATrace.beginSection("glClear@render");
            GLES20.glClear((int)16384);
            ATrace.endSection();
            ATrace.beginSection("draw@render");
            if (type == VideoFrame.TextureBuffer.Type.RGB) {
                this.drawer.drawRgb(n3, fArray, n4, n5, 0, 0, n4, n5);
            } else {
                this.drawer.drawOes(n3, fArray, n4, n5, 0, 0, n4, n5);
            }
            ATrace.endSection();
            ATrace.beginSection("swapBuffers@render");
            this.eglBase.swapBuffers();
            ATrace.endSection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        textureBuffer.release();
    }

    public void createProducerResourceIfNeeded(EglBase.Context context) {
        if (this.eglBase == null) {
            try {
                this.eglBase = EglBase.create(context);
                this.eglBase.createSurface(this.surface);
            }
            catch (Exception exception) {
                Logging.e(TAG, "got exception when create eglbase:" + exception.toString());
            }
            this.drawer = new GlRectDrawer();
        }
    }

    public void releaseProducerResourceIfNotYet() {
        if (this.eglBase == null) {
            return;
        }
        try {
            Logging.i(TAG, "release gl resource, this: " + this.hashCode() + ", thread id: " + Thread.currentThread().getId());
            if (!this.eglAttached) {
                this.eglBase.makeCurrent();
            }
            if (this.drawer != null) {
                this.drawer.release();
                this.drawer = null;
            }
            this.eglBase.release();
            this.eglBase = null;
            this.eglAttached = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setupSurfaceTexture(GLRendererController gLRendererController) {
        if (this.surfaceTexture == null && gLRendererController != null) {
            this.oesTextureId = GlUtil.generateTexture(36197, false);
            this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
            this.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)gLRendererController);
            this.surface = new Surface(this.surfaceTexture);
            this.surfaceTextureRecreated = true;
        }
    }

    public void releaseSurfaceTexture() {
        Logging.d(TAG, "release surface texture, this: " + this.hashCode());
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        if (this.surfaceTexture != null) {
            this.surfaceTexture.release();
            this.surfaceTexture = null;
        }
        if (this.oesTextureId >= 0) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
            this.oesTextureId = -1;
        }
    }

    public void onSurfaceChanged(GLRendererController gLRendererController, int n2, int n3) {
        Logging.i(TAG, "onSurfaceChanged, w: " + n2 + " h: " + n3 + " this: " + this.hashCode());
        this.releaseSurfaceTexture();
        this.oldWidth = -1;
        this.oldHeight = -1;
        this.setupSurfaceTexture(gLRendererController);
        if (this.useJavaRender()) {
            GLES20.glViewport((int)0, (int)0, (int)n2, (int)n3);
        }
    }

    public void onDrawFrame(GLRendererController gLRendererController) throws Exception {
        ATrace.beginSection("setupSurfaceTexture");
        this.setupSurfaceTexture(gLRendererController);
        ATrace.endSection();
        if (this.useJavaRender()) {
            GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GLES20.glClear((int)16640);
        }
        if (this.surfaceTexture != null && this.surface != null) {
            this.surfaceTexture.updateTexImage();
        }
        if (this.useJavaRender()) {
            if (this.textureRenderer == null) {
                this.textureRenderer = new TextureRenderer(true);
            }
            this.textureRenderer.draw(this.oesTextureId);
        }
    }

    public void onFrameAvailable(GLRendererController gLRendererController) {
        if (gLRendererController != null) {
            gLRendererController.ReDraw();
        }
    }

    public class TextureFrame {
        public EglBase.Context context;
        public int texId;
        public int textureType;
        public int frameWidth;
        public int frameHeight;
        public int rotation;
        public long renderMs;
        public long firstRecvTimestamp;
        public boolean isDummy;

        public String toString() {
            return "TextureFrame{context=" + this.context + ", texId=" + this.texId + ", textureType=" + this.textureType + ", frameWidth=" + this.frameWidth + ", frameHeight=" + this.frameHeight + ", rotation=" + this.rotation + ", renderMs=" + this.renderMs + ", firstRecvTimestamp=" + this.firstRecvTimestamp + ", isDummy=" + this.isDummy + '}';
        }
    }
}

