/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import io.agora.rtc.internal.AudioRoutingController;
import io.agora.rtc.internal.Logging;
import java.util.HashMap;

@TargetApi(value=23)
public class AudioDeviceInventoryMorHigher
implements AudioRoutingController.AudioDeviceInventory {
    private static final String TAG = "AudioRoute";
    private AudioManager mAm;
    private AudioRoutingController.AudioDeviceChangedCallback mAudioDeviceChangedCb = null;
    private AudioDeviceCallbackImpl mDevCb;
    private static final HashMap<Integer, Integer> DEVICE_TYPE_TO_ROUTE = new HashMap();
    private static final HashMap<Integer, Integer> DEVICE_TYPE_MAP;

    public AudioDeviceInventoryMorHigher(Context context) {
        this.mAm = (AudioManager)context.getSystemService("audio");
    }

    @Override
    public void initialize() {
        this.mDevCb = new AudioDeviceCallbackImpl();
        this.mAm.registerAudioDeviceCallback((AudioDeviceCallback)this.mDevCb, null);
    }

    @Override
    public void dispose() {
        this.mAm.unregisterAudioDeviceCallback((AudioDeviceCallback)this.mDevCb);
    }

    @Override
    public boolean isDeviceAvaliable(int n2) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = this.mAm.getDevices(2)) {
            int n3 = audioDeviceInfo.getType();
            if (!DEVICE_TYPE_MAP.containsKey(n3) || DEVICE_TYPE_MAP.get(n3) != n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setAudioDeviceChangeCallback(AudioRoutingController.AudioDeviceChangedCallback audioDeviceChangedCallback) {
        this.mAudioDeviceChangedCb = audioDeviceChangedCallback;
    }

    private void onAudioDeviceChanged(int n2, boolean bl) {
        if (this.mAudioDeviceChangedCb != null) {
            this.mAudioDeviceChangedCb.onAudioDeviceChanged(n2, bl);
        }
    }

    private void processDevicesChanged(AudioDeviceInfo[] audioDeviceInfoArray, boolean bl) {
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray) {
            boolean bl2 = audioDeviceInfo.isSource();
            int n2 = audioDeviceInfo.getType();
            if (bl2 || !DEVICE_TYPE_MAP.containsKey(audioDeviceInfo.getType())) {
                Logging.i(TAG, "not process " + (bl ? "connect" : "disconnect") + (bl2 ? " input " : " output ") + "device type: " + n2);
                continue;
            }
            int n3 = DEVICE_TYPE_MAP.get(n2);
            this.onAudioDeviceChanged(n3, bl);
            Logging.i(TAG, "processDevicesChanged : " + n3 + " " + (bl ? "connect" : "disconnect"));
        }
    }

    static {
        DEVICE_TYPE_TO_ROUTE.put(1, 1);
        DEVICE_TYPE_TO_ROUTE.put(2, 3);
        DEVICE_TYPE_TO_ROUTE.put(3, 0);
        DEVICE_TYPE_TO_ROUTE.put(4, 2);
        DEVICE_TYPE_TO_ROUTE.put(7, 5);
        DEVICE_TYPE_MAP = new HashMap();
        DEVICE_TYPE_MAP.put(3, 1);
        DEVICE_TYPE_MAP.put(4, 2);
        DEVICE_TYPE_MAP.put(7, 3);
        DEVICE_TYPE_MAP.put(8, 4);
    }

    private class AudioDeviceCallbackImpl
    extends AudioDeviceCallback {
        public AudioDeviceCallbackImpl() {
            Logging.i(AudioDeviceInventoryMorHigher.TAG, "AudioDeviceCallbackImpl ctor!");
        }

        public void onAudioDevicesAdded(AudioDeviceInfo[] audioDeviceInfoArray) {
            AudioDeviceInventoryMorHigher.this.processDevicesChanged(audioDeviceInfoArray, true);
        }

        public void onAudioDevicesRemoved(AudioDeviceInfo[] audioDeviceInfoArray) {
            AudioDeviceInventoryMorHigher.this.processDevicesChanged(audioDeviceInfoArray, false);
        }
    }
}

