/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.text.TextUtils;
import io.agora.rtc.internal.AudioRoutingController;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;
import java.util.List;

public class AudioDeviceInventoryLowerThanM
implements AudioRoutingController.AudioDeviceInventory {
    private static final String TAG = "AudioRoute";
    private static final String PERMISSION_BLUETOOTH_CONNECT = "android.permission.BLUETOOTH_CONNECT";
    private final int STATE_DISCONNECT = -1;
    private final int STATE_CONNECT = 1;
    private final String HEADSET_EXTRA_STATE = "state";
    private final WeakReference<Context> mContext;
    private HeadsetBroadcastReceiver mHeadsetReceiver = null;
    private BTHeadsetBroadcastReceiver mBTHeadsetReceiver = null;
    private BluetoothAdapter mBTAdapter;
    private BluetoothHeadset mBTHeadset;
    private BluetoothProfile.ServiceListener mBTHeadsetListener;
    private AudioRoutingController.AudioDeviceChangedCallback mAudioDeviceChangedCb;
    private AudioManager mAm;
    private int mHeadsetType = -1;
    private static final int ANDROID_SNOW_CONE = 31;

    public AudioDeviceInventoryLowerThanM(Context context) {
        this.mContext = new WeakReference<Context>(context);
        this.mAm = (AudioManager)context.getSystemService("audio");
        Logging.i(TAG, "AudioDeviceInventoryLowerThanM ctor!");
    }

    @Override
    public void initialize() {
        Context context = (Context)this.mContext.get();
        Logging.i(TAG, "AudioDeviceInventoryLowerThanM initialize +");
        this.initHeadsetBroadcastReceiver(context);
        this.initBtBroadcastReceiver(context);
    }

    @Override
    public void dispose() {
        try {
            this.clearBTResource();
            Context context = (Context)this.mContext.get();
            if (context != null) {
                if (this.mHeadsetReceiver != null && this.mHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
                    this.mHeadsetReceiver.setRegistered(false);
                }
                if (this.mBTHeadsetReceiver != null && this.mBTHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mBTHeadsetReceiver);
                    this.mBTHeadsetReceiver.setRegistered(false);
                }
            }
            this.mHeadsetReceiver = null;
            this.mBTHeadsetReceiver = null;
        }
        catch (Exception exception) {
            Logging.e(TAG, "AudioRoutingController dispose fail: ", exception);
        }
    }

    @Override
    public boolean isDeviceAvaliable(int n2) {
        boolean bl = false;
        if (n2 == 3) {
            if (this.mBTAdapter != null && 2 == this.mBTAdapter.getProfileConnectionState(1)) {
                bl = true;
            }
        } else if (n2 == 4) {
            bl = this.mAm.isBluetoothA2dpOn();
        } else if (n2 == 2 || n2 == 1) {
            bl = this.mAm.isWiredHeadsetOn();
        }
        return bl;
    }

    @Override
    public void setAudioDeviceChangeCallback(AudioRoutingController.AudioDeviceChangedCallback audioDeviceChangedCallback) {
        this.mAudioDeviceChangedCb = audioDeviceChangedCallback;
    }

    protected boolean hasPermission(Context context, String string) {
        return context.checkCallingOrSelfPermission(string) == 0;
    }

    private void initHeadsetBroadcastReceiver(Context context) {
        if (this.mHeadsetReceiver == null) {
            this.mHeadsetReceiver = new HeadsetBroadcastReceiver();
        }
        if (!this.mHeadsetReceiver.getRegistered()) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
            Intent intent = context.registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, intentFilter);
            if (intent != null && TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.intent.action.HEADSET_PLUG")) {
                this.processHeadsetIntent(intent);
            }
            this.mHeadsetReceiver.setRegistered(true);
        }
    }

    private void initBtBroadcastReceiver(Context context) {
        if (Build.VERSION.SDK_INT >= 31 && !this.hasPermission(context, PERMISSION_BLUETOOTH_CONNECT) || Build.VERSION.SDK_INT < 31 && !this.hasPermission(context, "android.permission.BLUETOOTH")) {
            Logging.w(TAG, "do not support BT monitoring on this device");
            return;
        }
        this.initBluetoothProfileListener();
        try {
            if (this.mBTHeadsetReceiver == null) {
                this.mBTHeadsetReceiver = new BTHeadsetBroadcastReceiver();
            }
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBTAdapter == null) {
                Logging.e(TAG, "initialize: failed to get bluetooth adapter!!");
                return;
            }
            this.mBTAdapter.getProfileProxy(context, this.mBTHeadsetListener, 1);
            IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
            if (!this.mBTHeadsetReceiver.getRegistered()) {
                context.registerReceiver((BroadcastReceiver)this.mBTHeadsetReceiver, intentFilter);
                this.mBTHeadsetReceiver.setRegistered(true);
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "unable to create BluetoothHeadsetBroadcastReceiver, err:" + exception.getMessage());
        }
    }

    private void initBluetoothProfileListener() {
        try {
            this.mBTHeadsetListener = new BluetoothProfile.ServiceListener(){

                public void onServiceConnected(int n2, BluetoothProfile bluetoothProfile) {
                    Logging.i(AudioDeviceInventoryLowerThanM.TAG, "onServiceConnected " + n2 + " =? headset(" + 1 + ")");
                    if (n2 == 1) {
                        Logging.i(AudioDeviceInventoryLowerThanM.TAG, "on BT service connected: " + n2 + " " + bluetoothProfile);
                        AudioDeviceInventoryLowerThanM.this.mBTHeadset = (BluetoothHeadset)bluetoothProfile;
                    }
                }

                public void onServiceDisconnected(int n2) {
                    Logging.i(AudioDeviceInventoryLowerThanM.TAG, "onServiceDisconnected " + n2 + " =? headset(" + 1 + ")");
                    if (n2 == 1) {
                        Logging.i(AudioDeviceInventoryLowerThanM.TAG, "on BT service disconnected: " + n2);
                        AudioDeviceInventoryLowerThanM.this.onAudioDeviceEvent(0);
                        AudioDeviceInventoryLowerThanM.this.mBTHeadset = null;
                    }
                }
            };
        }
        catch (Exception exception) {
            Logging.e(TAG, "initialize failed: unable to create BluetoothProfile.ServiceListener, err=" + exception.getMessage());
        }
    }

    private void onAudioDeviceChanged(int n2, boolean bl) {
        Logging.i(TAG, "onAudioDeviceChanged route :" + n2 + " status: " + (bl ? "connect" : "disconnect"));
        if (this.mAudioDeviceChangedCb != null) {
            this.mAudioDeviceChangedCb.onAudioDeviceChanged(n2, bl);
        }
    }

    private void onAudioDeviceEvent(int n2) {
        if (this.mAudioDeviceChangedCb != null) {
            this.mAudioDeviceChangedCb.onAudioDeviceEvent(n2);
        }
    }

    private int getBtConnectedDevicesSize() {
        if (this.mBTHeadset == null) {
            return 0;
        }
        int n2 = 0;
        try {
            List list = this.mBTHeadset.getConnectedDevices();
            for (BluetoothDevice bluetoothDevice : list) {
                Logging.i(TAG, "connected device name: " + bluetoothDevice.getName());
            }
            n2 = list.size();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    private void clearBTResource() {
        if (this.mBTAdapter != null) {
            this.mBTAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBTHeadset);
            this.mBTAdapter = null;
        }
        if (this.mBTHeadsetListener != null) {
            this.mBTHeadsetListener = null;
        }
    }

    private boolean processHeadsetIntent(Intent intent) {
        int n2 = intent.getIntExtra("state", -1);
        int n3 = intent.getIntExtra("microphone", -1);
        if (n2 == 1) {
            this.mHeadsetType = n3 == 1 ? 0 : 2;
        }
        return n2 == 1;
    }

    private void processBluetoothIntent(Intent intent) {
        String string = intent.getAction();
        try {
            if (string.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int n2 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                int n3 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String string2 = bluetoothDevice != null ? bluetoothDevice.getName() : "null name";
                Logging.d(TAG, "BT " + string2 + " hfp connect state : " + n3 + ", " + n2);
                switch (n2) {
                    case 2: {
                        Logging.i(TAG, "Bluetooth device " + bluetoothDevice + " connected");
                        this.onAudioDeviceChanged(3, true);
                        break;
                    }
                    case 0: {
                        Logging.i(TAG, "Bluetooth device " + bluetoothDevice + " disconnected");
                        if (this.getBtConnectedDevicesSize() == 0) {
                            this.onAudioDeviceChanged(3, false);
                            break;
                        }
                        this.onAudioDeviceEvent(1);
                        break;
                    }
                    default: {
                        Logging.i(TAG, bluetoothDevice + " unknown event, state=" + n2);
                        break;
                    }
                }
            } else if (string.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int n4 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                int n5 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String string3 = bluetoothDevice != null ? bluetoothDevice.getName() : "null name";
                Logging.i(TAG, "BT " + string3 + " audio state: " + n5 + "," + n4);
                switch (n4) {
                    case 12: {
                        Logging.i(TAG, "Bluetooth " + bluetoothDevice + " audio state connected");
                        break;
                    }
                    case 10: {
                        Logging.i(TAG, "Bluetooth " + bluetoothDevice + " audio state disconnected");
                        break;
                    }
                    default: {
                        Logging.i(TAG, bluetoothDevice + " audio state event, state=" + n4);
                        break;
                    }
                }
            } else if (string.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int n6 = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -99);
                int n7 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -99);
                Logging.d(TAG, "BluetoothAdapter.ACTION_STATE_CHANGED prev " + n7 + ", " + n6);
                switch (n6) {
                    case 10: {
                        this.onAudioDeviceChanged(3, false);
                        this.onAudioDeviceChanged(4, false);
                        break;
                    }
                }
            } else if (string.equals("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED")) {
                int n8 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                int n9 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String string4 = bluetoothDevice != null ? bluetoothDevice.getName() : "null name";
                Logging.i(TAG, "BT a2dp " + string4 + " audio state: " + n9 + "," + n8);
                switch (n8) {
                    case 2: {
                        this.onAudioDeviceChanged(4, true);
                        break;
                    }
                    case 0: {
                        this.onAudioDeviceChanged(4, false);
                        break;
                    }
                    default: {
                        Logging.i(TAG, "Receive a2dp Event Bluetooth device " + bluetoothDevice + " unknown event, state=" + n8);
                    }
                }
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "BT broadcast receiver onReceive fail ", exception);
        }
    }

    private class BTHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private BTHeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }

        public void onReceive(Context context, Intent intent) {
            AudioDeviceInventoryLowerThanM.this.processBluetoothIntent(intent);
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private HeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equalsIgnoreCase("android.intent.action.HEADSET_PLUG") || !intent.hasExtra("state")) {
                return;
            }
            boolean bl = AudioDeviceInventoryLowerThanM.this.processHeadsetIntent(intent);
            int n2 = AudioDeviceInventoryLowerThanM.this.mHeadsetType == 2 ? 2 : 1;
            AudioDeviceInventoryLowerThanM.this.onAudioDeviceChanged(n2, bl);
        }
    }
}

