/*
 * Decompiled with CFR 0.152.
 */
package io.agora.notification.core;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import io.agora.CallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.PushManager;
import io.agora.notification.EMNotificationMessage;
import io.agora.util.EMLog;
import java.util.Iterator;
import org.json.JSONObject;

public class EMNotificationIntentReceiver
extends BroadcastReceiver {
    private static final String TAG = "em_notification";

    public final void onReceive(Context context, Intent intent) {
        EMLog.d(TAG, "onReceive");
        if (intent == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                int n = bundle.getInt("event_type");
                String string = bundle.getString("task_id");
                EMNotificationMessage eMNotificationMessage = (EMNotificationMessage)bundle.getParcelable("message");
                if (n == 0) {
                    this.onNotifyMessageArrived(context, eMNotificationMessage);
                }
                if (n == 1) {
                    JSONObject jSONObject = new JSONObject();
                    if (!string.isEmpty()) {
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put("task_id", (Object)string);
                        jSONObject.put("report", (Object)jSONObject2);
                    }
                    jSONObject.put("provider", (Object)"EASEMOB");
                    ChatClient.getInstance().pushManager().reportPushAction(jSONObject, PushManager.EMPushAction.CLICK, new CallBack(){

                        @Override
                        public void onSuccess() {
                            EMLog.d(EMNotificationIntentReceiver.TAG, "report success");
                        }

                        @Override
                        public void onError(int code, String error) {
                            EMLog.d(EMNotificationIntentReceiver.TAG, "report failed: " + code + " : " + error);
                        }

                        @Override
                        public void onProgress(int progress, String status) {
                        }
                    });
                    this.onNotificationClick(context, eMNotificationMessage);
                }
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.getMessage());
        }
    }

    public void onNotifyMessageArrived(Context context, EMNotificationMessage notificationMessage) {
        EMLog.d(TAG, "onNotifyMessageArrived");
    }

    public void onNotificationClick(Context context, EMNotificationMessage notificationMessage) {
        try {
            Intent intent = null;
            if (notificationMessage.getOpenType() == 1) {
                if (!TextUtils.isEmpty((CharSequence)notificationMessage.getOpenUrl()) && (notificationMessage.getOpenUrl().startsWith("http:") || notificationMessage.getOpenUrl().startsWith("https:"))) {
                    intent = new Intent("android.intent.action.VIEW", Uri.parse((String)notificationMessage.getOpenUrl()));
                }
            } else if (notificationMessage.getOpenType() == 2) {
                if (!TextUtils.isEmpty((CharSequence)notificationMessage.getOpenAction())) {
                    intent = notificationMessage.getOpenAction().contains("://") ? new Intent("android.intent.action.VIEW", Uri.parse((String)notificationMessage.getOpenAction())) : new Intent(notificationMessage.getOpenAction());
                } else if (!TextUtils.isEmpty((CharSequence)notificationMessage.getOpenActivity())) {
                    intent = new Intent();
                    intent.setComponent(new ComponentName(context, notificationMessage.getOpenActivity()));
                }
            } else {
                intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            }
            if (!TextUtils.isEmpty((CharSequence)notificationMessage.getExtras()) && intent != null) {
                JSONObject jSONObject = new JSONObject(notificationMessage.getExtras());
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    intent.putExtra(string, jSONObject.getString(string));
                }
            }
            if (intent != null) {
                intent.setFlags(337641472);
                context.startActivity(intent);
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, "onNotificationClick:" + exception.getMessage());
        }
    }
}

