/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import io.agora.chat.FileMessageBody;
import io.agora.chat.adapter.message.EMAFileMessageBody;
import io.agora.chat.adapter.message.EMAVideoMessageBody;
import io.agora.util.EMLog;
import io.agora.util.FileHelper;

public class VideoMessageBody
extends FileMessageBody
implements Parcelable {
    private static final String TAG = VideoMessageBody.class.getSimpleName();
    public static final Parcelable.Creator<VideoMessageBody> CREATOR = new Parcelable.Creator<VideoMessageBody>(){

        public VideoMessageBody[] newArray(int size) {
            return new VideoMessageBody[size];
        }

        public VideoMessageBody createFromParcel(Parcel in) {
            return new VideoMessageBody(in);
        }
    };

    public VideoMessageBody() {
        super("", 2);
    }

    public VideoMessageBody(EMAVideoMessageBody body) {
        super(body);
    }

    public VideoMessageBody(String videoFilePath, String thumbPath, int duration, long filelength) {
        this(FileHelper.getInstance().formatInUri(videoFilePath), FileHelper.getInstance().formatInUri(thumbPath), duration, filelength);
        EMLog.d("ChatClient", "VideoMessageBody thumbPath = " + thumbPath);
    }

    public VideoMessageBody(Uri videoFilePath, Uri thumbPath, int duration, long filelength) {
        super(videoFilePath, 2);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(FileHelper.getInstance().formatInUriToString(thumbPath));
        ((EMAVideoMessageBody)this.emaObject).setDuration(duration);
        ((EMAVideoMessageBody)this.emaObject).setDisplayName(FileHelper.getInstance().getFilename(videoFilePath));
        ((EMAVideoMessageBody)this.emaObject).setFileLength(filelength);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailFileLength(FileHelper.getInstance().getFileLength(thumbPath));
        EMLog.d("videomsg", "create video, message body for:" + videoFilePath + " filename = " + FileHelper.getInstance().getFilename(videoFilePath));
        EMLog.d("ChatClient", "VideoMessageBody thumbPath = " + thumbPath);
    }

    VideoMessageBody(String fileName, String remoteUrl, String thumbnailUrl, int length) {
        super(fileName, 2);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(thumbnailUrl);
        ((EMAVideoMessageBody)this.emaObject).setLocalPath(fileName);
        ((EMAVideoMessageBody)this.emaObject).setRemotePath(remoteUrl);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailRemotePath(thumbnailUrl);
        ((EMAVideoMessageBody)this.emaObject).setFileLength(length);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailFileLength(FileHelper.getInstance().getFileLength(thumbnailUrl));
    }

    public long getVideoFileLength() {
        return ((EMAVideoMessageBody)this.emaObject).fileLength();
    }

    public void setVideoFileLength(long filelength) {
        ((EMAVideoMessageBody)this.emaObject).setFileLength(filelength);
    }

    public String getThumbnailUrl() {
        return ((EMAVideoMessageBody)this.emaObject).thumbnailRemotePath();
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailRemotePath(thumbnailUrl);
    }

    public void setThumbnailSize(int width, int height) {
        ((EMAVideoMessageBody)this.emaObject).setSize(width, height);
    }

    public int getThumbnailWidth() {
        return ((EMAVideoMessageBody)this.emaObject).width();
    }

    public int getThumbnailHeight() {
        return ((EMAVideoMessageBody)this.emaObject).height();
    }

    public String getLocalThumb() {
        return FileHelper.getInstance().formatOutLocalUrl(((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath());
    }

    public Uri getLocalThumbUri() {
        return FileHelper.getInstance().formatOutUri(((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath());
    }

    public void setLocalThumb(String localThumbPath) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(FileHelper.getInstance().formatInUriToString(localThumbPath));
        ((EMAVideoMessageBody)this.emaObject).setThumbnailFileLength(FileHelper.getInstance().getFileLength(localThumbPath));
    }

    public void setLocalThumb(Uri localThumbPath) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(FileHelper.getInstance().formatInUriToString(localThumbPath));
        ((EMAVideoMessageBody)this.emaObject).setThumbnailFileLength(FileHelper.getInstance().getFileLength(localThumbPath));
    }

    public int getDuration() {
        return ((EMAVideoMessageBody)this.emaObject).duration();
    }

    public String toString() {
        return "video: " + ((EMAVideoMessageBody)this.emaObject).displayName() + ", localUrl: " + ((EMAVideoMessageBody)this.emaObject).getLocalUrl() + ", remoteUrl: " + ((EMAVideoMessageBody)this.emaObject).getRemoteUrl() + ", thumbnailUrl: " + ((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath() + ", length: " + ((EMAVideoMessageBody)this.emaObject).fileLength();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMAVideoMessageBody)this.emaObject).displayName());
        dest.writeString(((EMAVideoMessageBody)this.emaObject).getLocalUrl());
        dest.writeString(((EMAVideoMessageBody)this.emaObject).getRemoteUrl());
        dest.writeString(((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath());
        dest.writeString(((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath());
        dest.writeInt(((EMAVideoMessageBody)this.emaObject).duration());
        dest.writeLong(((EMAVideoMessageBody)this.emaObject).fileLength());
        dest.writeInt(((EMAVideoMessageBody)this.emaObject).width());
        dest.writeInt(((EMAVideoMessageBody)this.emaObject).height());
        dest.writeLong(((EMAVideoMessageBody)this.emaObject).thumbnailFileLength());
    }

    private VideoMessageBody(Parcel in) {
        super("", 2);
        ((EMAVideoMessageBody)this.emaObject).setDisplayName(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setLocalPath(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setRemotePath(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setThumbnailRemotePath(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setDuration(in.readInt());
        ((EMAVideoMessageBody)this.emaObject).setFileLength(in.readLong());
        int n = in.readInt();
        int n2 = in.readInt();
        ((EMAVideoMessageBody)this.emaObject).setSize(n, n2);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailFileLength(in.readLong());
    }

    public String getThumbnailSecret() {
        return ((EMAVideoMessageBody)this.emaObject).thumbnailSecretKey();
    }

    public void setThumbnailSecret(String secret) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailSecretKey(secret);
    }

    public FileMessageBody.EMDownloadStatus thumbnailDownloadStatus() {
        EMAFileMessageBody.EMADownloadStatus eMADownloadStatus = ((EMAVideoMessageBody)this.emaObject).thumbnailDownloadStatus();
        switch (eMADownloadStatus) {
            case DOWNLOADING: {
                return FileMessageBody.EMDownloadStatus.DOWNLOADING;
            }
            case SUCCESSED: {
                return FileMessageBody.EMDownloadStatus.SUCCESSED;
            }
            case FAILED: {
                return FileMessageBody.EMDownloadStatus.FAILED;
            }
            case PENDING: {
                return FileMessageBody.EMDownloadStatus.PENDING;
            }
        }
        return FileMessageBody.EMDownloadStatus.SUCCESSED;
    }

    public void setThumbnailDownloadStatus(FileMessageBody.EMDownloadStatus status) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailDownloadStatus(EMAFileMessageBody.EMADownloadStatus.valueOf(status.name()));
    }
}

